/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Stack;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TrimEnable;

public class CharDataGenerator
extends Generator
implements TrimEnable {
    private static final int ONE_WRITE_LIMIT = 8192;
    private char[] chars;
    private Stack outStack = null;
    private boolean notIncludeQuote;
    private boolean isTextPlain;
    private int starting;
    private int limit;

    public CharDataGenerator(char[] chars, Mark start, Mark stop) {
        this.start = start;
        this.stop = stop;
        this.chars = chars;
        this.starting = 0;
        this.limit = chars == null ? 0 : chars.length;
    }

    public CharDataGenerator(char[] chars, Mark start, Mark stop, boolean notIncludeQuote, boolean isTextPlain) {
        this(chars, start, stop);
        this.notIncludeQuote = notIncludeQuote;
        this.isTextPlain = isTextPlain;
        this.starting = 0;
        this.limit = chars == null ? 0 : chars.length;
    }

    public CharDataGenerator(char[] chars, Mark start, Mark stop, Stack outStack) {
        this.start = start;
        this.stop = stop;
        this.chars = chars;
        this.outStack = outStack;
        this.starting = 0;
        this.limit = chars == null ? 0 : chars.length;
    }

    public void generate(StringBuffer buf) {
        buf.append(this.chars);
    }

    public void forwardTrim() {
        if (this.chars == null || this.chars.length == 0) {
            return;
        }
        for (int i = this.starting; i < this.limit && Character.isWhitespace(this.chars[i]); ++i) {
            ++this.starting;
        }
    }

    public void backwardTrim() {
        if (this.chars == null || this.chars.length == 0) {
            return;
        }
        for (int i = this.limit - 1; i >= this.starting && Character.isWhitespace(this.chars[i]); --i) {
            --this.limit;
        }
    }

    public boolean generate(ServletWriter writer, String phase) {
        int total = this.limit - this.starting;
        if (total > 8192) {
            int blocks = total / 8192;
            for (int i = 0; i < blocks; ++i) {
                this.writeOneBlock(writer, (i + 1) * 8192, this.starting + i * 8192);
            }
            this.writeOneBlock(writer, this.limit, this.starting + blocks * 8192);
        } else {
            this.writeOneBlock(writer, this.limit, this.starting);
        }
        return true;
    }

    private void writeOneBlock(ServletWriter writer, int end, int start) {
        String outputName = "out";
        if (this.outStack != null && this.outStack.size() != 0) {
            outputName = (String)this.outStack.peek();
        }
        writer.indent();
        writer.print(outputName + ".write(");
        this.appendDoubleQuote(writer);
        StringBuffer sb = new StringBuffer();
        block7: for (int i = start; i < end; ++i) {
            char ch = this.chars[i];
            switch (ch) {
                case '\"': {
                    this.appendDoubleQutoeInString(sb);
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    if (i + 1 != end && this.chars[i + 1] == '\n') continue block7;
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\n': {
                    if (this.isTextPlain) {
                        sb.append("\\n");
                        continue block7;
                    }
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        writer.print(sb.toString());
        this.appendDoubleQuote(writer);
        writer.print("); //CodeDataGenerator\r\n");
    }

    private void appendDoubleQuote(ServletWriter writer) {
        if (!this.notIncludeQuote) {
            writer.print("\"");
        }
    }

    private void appendDoubleQutoeInString(StringBuffer sb) {
        if (this.notIncludeQuote) {
            sb.append("\"");
        } else {
            sb.append("\\\"");
        }
    }
}

