/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.FunctionInfo;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.jsp.JspDefaultConstants;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineContext;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TLDInfo;
import jeus.servlet.jsp.TLDManager;
import jeus.servlet.jsp.compiler.BeanCache;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.Checker;
import jeus.servlet.jsp.compiler.ELFunctionParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ScriptingVariableChecker;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TagLibraryInfoImpl;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public abstract class CodeGenerator {
    public static final String SERVICE_METHOD_PHASE = "ServiceMethodPhase";
    public static final String CLASS_DECL_PHASE = "ClassDeclarationPhase";
    public static final String INIT_METHOD_PHASE = "InitMethodPhase";
    public static final String DESTROY_METHOD_PHASE = "DestroyMethodPhase";
    public static final String TEMPLATE_DECL_PHASE = "TemplateStringDeclarationPhase";
    public static final String SPLITTED_SERVICE_METHOD_PHASE = "SplittedServiceMethodPhase";
    public static final String TAG_METHOD_DECL_PHASE = "TagMethodDeclarationPhase";
    public static final String FRAGMENT_IMPL_DECL_PHASE = "JspFragmentImplDeclarationPhase";
    public static final String DEFAULT_TAG_CONTENT_NAME = "pageContext";
    public static final String TAG_FRAG_CONTENT_NAME = "(javax.servlet.jsp.PageContext)jspContext";
    public static final String PARENT_TAG_NAME = "_jspx_parentTag";
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    protected JspEngine jspEngine;
    protected TLDManager tldManager;
    protected String jspURI;
    protected JspReader reader;
    protected ServletWriter writer;
    protected JspParser parser;
    protected String servletPageEncoding = null;
    public String pageEncodingInXml = null;
    protected String servletContentType = "text/html";
    protected boolean xmlPrologGenerated = false;
    private String compileEncoding = null;
    private String javaEncoding = null;
    protected String jspPropertyEncoding = null;
    protected Vector imports = new Vector();
    protected boolean genSessionVariable = true;
    private BeanCache beanInfo;
    private Hashtable libraries;
    protected Hashtable genStore = new Hashtable();
    protected boolean languageDir = false;
    protected boolean pageEncodingDir = false;
    private Stack tagOutStack = new Stack();
    private Stack tagContentStack = new Stack();
    private Hashtable tagVarNumbers = new Hashtable();
    private ScriptingVariableChecker scriptingVariableChecker = new ScriptingVariableChecker();
    private Stack rootElementNames = new Stack();
    public String isELIgnored = null;
    private Integer functionVarNumber = new Integer(0);
    private Hashtable functionStaticNames = new Hashtable();
    private ArrayList elStaticFunctionMap = new ArrayList();
    private boolean existRoot = false;
    private String language;
    private String nameSpace;
    private boolean specialXmlDocument;
    Checker currentBrace = new Checker();
    Checker currentCustomTag = new Checker();
    private int numberOfCharData = 0;
    private int numberOfJspAttribute = 0;
    private int numberOfJspFragment = 0;
    private Stack parentGeneratorStack = new Stack();

    protected CodeGenerator(JspEngine jspEngine, String jspURI, JspReader reader, ServletWriter writer) {
        this.jspEngine = jspEngine;
        this.tldManager = jspEngine.getTLDManager();
        this.jspURI = jspURI;
        this.reader = reader;
        this.writer = writer;
        this.beanInfo = new BeanCache();
        this.libraries = new Hashtable();
        this.genStore.put(CLASS_DECL_PHASE, new Vector());
        this.genStore.put(SERVICE_METHOD_PHASE, new Vector());
        this.genStore.put(SPLITTED_SERVICE_METHOD_PHASE, new Vector());
        this.genStore.put(TEMPLATE_DECL_PHASE, new Vector());
    }

    public String getJspURI() {
        return this.jspURI;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    Stack peekTagOutStack() {
        return this.tagOutStack;
    }

    Stack getTagOutStack() {
        if (this.tagOutStack.size() == 0) {
            this.tagOutStack.push("out");
        }
        return this.tagOutStack;
    }

    Stack getTagContentStack() {
        if (this.tagContentStack.size() == 0) {
            this.tagContentStack.push(DEFAULT_TAG_CONTENT_NAME);
        }
        return this.tagContentStack;
    }

    Hashtable getTagVarNumbers() {
        return this.tagVarNumbers;
    }

    ScriptingVariableChecker getScriptingVariableChecker() {
        return this.scriptingVariableChecker;
    }

    public String getPageEncoding() {
        return this.servletPageEncoding;
    }

    public boolean isPageEncodingAccepted() {
        return this.isPageEncodingAccepted(this.servletPageEncoding);
    }

    public boolean isPageEncodingAccepted(String _suggestedEncoding) {
        return _suggestedEncoding == null || this.pageEncodingInXml == null || _suggestedEncoding.equalsIgnoreCase(this.pageEncodingInXml);
    }

    final void setJspParser(JspParser parser) {
        this.parser = parser;
    }

    public BeanCache getBeanCache() {
        return this.beanInfo;
    }

    public TagLibraryInfoImpl getTagLibraryInfo(String prefix) {
        if (prefix == null) {
            return null;
        }
        return (TagLibraryInfoImpl)((Object)this.libraries.get(prefix));
    }

    public boolean getGenSessionVariable() {
        return this.genSessionVariable;
    }

    public void pushParentGeneratorStack(Generator gen) {
        this.parentGeneratorStack.push(gen);
    }

    public void popParentGeneratorStack() {
        this.parentGeneratorStack.pop();
    }

    public void addGenerator(Generator gen, String phase) throws JspEngineException {
        this.addGenerator(gen, phase, true);
    }

    public void addGenerator(Generator gen, String phase, boolean doInit) throws JspEngineException {
        if (doInit) {
            gen.init(this.jspEngine);
        }
        if (!this.parentGeneratorStack.isEmpty() && phase.equals(SERVICE_METHOD_PHASE)) {
            Generator parent = (Generator)this.parentGeneratorStack.peek();
            parent.addChild(gen);
        } else {
            Vector generators = (Vector)this.genStore.get(phase);
            generators.addElement(gen);
        }
    }

    protected void generateAll(String phase) throws JspEngineException {
        Vector generators = (Vector)this.genStore.get(phase);
        for (int i = 0; i < generators.size(); ++i) {
            Generator gen = (Generator)generators.elementAt(i);
            gen.generateCode(this.writer, phase);
        }
    }

    public void addGenerator(Generator gen, String phase, int pos) throws JspEngineException {
        gen.init(this.jspEngine);
        Vector generators = (Vector)this.genStore.get(phase);
        if (pos < 0) {
            generators.addElement(gen);
        } else {
            generators.add(pos, gen);
        }
    }

    public void beginPageProcessing() throws JspEngineException {
        for (int i = 0; i < JspDefaultConstants.STANDARD_IMPORTS.length; ++i) {
            this.imports.addElement(JspDefaultConstants.STANDARD_IMPORTS[i]);
        }
    }

    public abstract void endPageProcessing() throws JspEngineException;

    public abstract void handleDirective(String var1, Mark var2, Mark var3, Hashtable var4) throws JspEngineException;

    protected void handleIncludeDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        this.parser.flushCharData();
        Vector files = (Vector)attrs.get("file");
        Vector encodings = (Vector)attrs.get("encoding");
        if (files == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5529));
        }
        String file = (String)files.elementAt(0);
        if (file == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5529));
        }
        try {
            if (!this.reader.isTemp) {
                ServletManager servletManager;
                if (this.jspEngine.getContext().getJspResourceProvider() != null && (servletManager = this.jspEngine.getContext().getServletManager()) != null) {
                    servletManager.downloadIncludeFile(file);
                }
                this.reader.pushFile(file, true, this.getCompileEncoding());
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5530, (Object)file));
        }
    }

    protected void handleTaglibDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        String _location;
        String uri;
        this.parser.flushCharData();
        Vector uris = (Vector)attrs.get("uri");
        Vector prefixes = (Vector)attrs.get("prefix");
        Vector tagdirs = (Vector)attrs.get("tagdir");
        String uriorg = uri = uris == null ? null : (String)uris.elementAt(0);
        if (uri != null && (_location = this.jspEngine.getJspConfig().getLocation(uri)) != null) {
            uriorg = uri;
            uri = _location;
        }
        String prefix = prefixes == null ? null : (String)prefixes.elementAt(0);
        String tagdir = tagdirs == null ? null : (String)tagdirs.elementAt(0);
        this.handleTagLibraryInfo(prefix, uriorg, uri, tagdir);
    }

    public void handleTagLibraryInfo(String prefix, String uriorg, String uri, String tagdir) throws JspEngineException {
        if (uri == null) {
            if (tagdir != null) {
                this.addTagDirInfo(prefix, tagdir);
                return;
            }
            throw new JspEngineException("taglib of prefix(" + prefix + ") should contain uri or tagdir");
        }
        this.addTagLibraryInfo(prefix, uriorg, uri);
    }

    private void addTagDirInfo(String prefix, String tagdir) throws JspEngineException {
        if (!tagdir.startsWith("/WEB-INF/tags")) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5359, (Object)tagdir));
        }
        try {
            TagLibraryInfoImpl tl = null;
            if (this.libraries.get(prefix) == null) {
                TLDInfo info = this.tldManager.getTagFiles(tagdir);
                if (info == null) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5651, (Object[])new String[]{tagdir, prefix}));
                }
                tl = new TagLibraryInfoImpl(info, null, prefix);
                this.libraries.put(prefix, tl);
                FunctionInfo[] finfos = tl.getFunctions();
                for (int i = 0; i < finfos.length; ++i) {
                    this.putFunctionStaticNames(prefix, finfos[i].getName().trim());
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5528, (Object[])new String[]{tagdir, prefix, ex.getMessage()}), ex);
        }
    }

    public void handleXmlRoot(Hashtable attrs) throws JspEngineException {
        this.parser.flushCharData();
        this.updateTagNameSpace(attrs, false);
    }

    public void updateTagNameSpace(Hashtable attrs, boolean customTag) throws JspEngineException {
        if (attrs == null) {
            return;
        }
        Enumeration enum1 = attrs.keys();
        while (enum1.hasMoreElements()) {
            String _nameSpaceValue;
            String prefix;
            String ns = (String)enum1.nextElement();
            if (!ns.startsWith("xmlns:") || (prefix = ns.substring("xmlns:".length())) == null || prefix.length() == 0 || prefix.equals("jsp") || (_nameSpaceValue = (String)attrs.get(ns)) == null) continue;
            if (_nameSpaceValue.startsWith("\"")) {
                _nameSpaceValue = _nameSpaceValue.substring(0);
            }
            if (_nameSpaceValue.endsWith("\"")) {
                _nameSpaceValue = _nameSpaceValue.substring(0, _nameSpaceValue.length() - 1);
            }
            if (_nameSpaceValue.indexOf("urn:jsptagdir:") >= 0) {
                String _tagDir = _nameSpaceValue.substring("urn:jsptagdir:".length());
                if (_tagDir == null || _tagDir.equalsIgnoreCase("")) continue;
                this.handleTagLibraryInfo(prefix, null, null, _tagDir);
                continue;
            }
            if (customTag) continue;
            this.handleTagLibraryInfo(prefix, _nameSpaceValue, _nameSpaceValue, null);
        }
    }

    private void addTagLibraryInfo(String prefix, String uriorg, String uri) throws JspEngineException {
        try {
            TagLibraryInfoImpl tl = null;
            if (this.libraries.get(prefix) == null) {
                TLDInfo info = this.tldManager.getTLDInfo(uri, this.jspURI);
                tl = new TagLibraryInfoImpl(info, uriorg, prefix);
                this.libraries.put(prefix, tl);
                FunctionInfo[] finfos = tl.getFunctions();
                for (int i = 0; i < finfos.length; ++i) {
                    this.putFunctionStaticNames(prefix, finfos[i].getName().trim());
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5528, (Object[])new String[]{uri, prefix, ex.getMessage()}), ex);
        }
    }

    public String checkBeanImport(String beanClassName) {
        if (beanClassName != null && beanClassName.indexOf(".") < 0) {
            boolean ok = false;
            try {
                this.jspEngine.getContext().getContextLoader().loadClass(beanClassName);
                ok = true;
            }
            catch (ClassNotFoundException fnfe) {
                // empty catch block
            }
            if (ok) {
                this.imports.addElement(beanClassName);
            } else {
                int sz = this.imports.size();
                if (sz > 0) {
                    for (int i = sz - 1; i >= 0; --i) {
                        String im = (String)this.imports.get(i);
                        int pos = im.lastIndexOf(beanClassName);
                        if (pos < 0 || pos + beanClassName.length() != im.length()) continue;
                        return im;
                    }
                }
            }
        }
        return null;
    }

    protected void languageHandler(Vector languages) throws JspEngineException {
        if (languages == null) {
            return;
        }
        Enumeration enum1 = languages.elements();
        while (enum1.hasMoreElements()) {
            String value = (String)enum1.nextElement();
            if (value == null) continue;
            if (!value.equalsIgnoreCase("java") && WebProperties.J2EE_COMPATIBLE.value) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5532, (Object)value));
            }
            if (!this.languageDir) {
                this.languageDir = true;
                this.language = value;
                continue;
            }
            if (!WebProperties.J2EE_COMPATIBLE.value || this.language.equals(value)) continue;
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5360));
        }
    }

    protected void importHandler(Vector importPkgs) {
        if (importPkgs == null) {
            return;
        }
        int size = importPkgs.size();
        for (int i = 0; i < size; ++i) {
            String importPkg = (String)importPkgs.elementAt(i);
            if (importPkg == null) continue;
            if (importPkg.indexOf("//") < 0) {
                StringTokenizer tokenizer = new StringTokenizer(importPkg, " ,;\n\t\r");
                while (tokenizer.hasMoreTokens()) {
                    String importStr = tokenizer.nextToken();
                    if (importStr.equals("import")) continue;
                    this.imports.addElement(importStr);
                }
                continue;
            }
            String delim = " ,;\n\t\r";
            StringTokenizer tokenizer = new StringTokenizer(importPkg, delim, true);
            while (tokenizer.hasMoreTokens()) {
                String importStr = tokenizer.nextToken();
                if (importStr.length() == 1 && delim.indexOf(importStr) >= 0) continue;
                if (importStr.indexOf("//") >= 0) {
                    while (tokenizer.hasMoreTokens() && ((importStr = tokenizer.nextToken()).length() != 1 || importStr.charAt(0) != '\n')) {
                    }
                    continue;
                }
                if (importStr.equals("import")) continue;
                this.imports.addElement(importStr);
            }
        }
    }

    protected void pageEncodingHandler(Vector pageEncodings) throws JspEngineException {
        if (pageEncodings == null) {
            return;
        }
        if (this.pageEncodingDir) {
            if (!WebProperties.J2EE_COMPATIBLE.value) {
                return;
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5554));
        }
        if (pageEncodings.size() > 1 && WebProperties.J2EE_COMPATIBLE.value) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5554));
        }
        this.pageEncodingDir = true;
        String pageEncoding = (String)pageEncodings.elementAt(0);
        if (pageEncoding == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5555));
        }
        this.servletPageEncoding = pageEncoding;
    }

    protected void isELIgnoredHandler(Vector iselignoreds) throws JspEngineException {
        if (iselignoreds == null) {
            return;
        }
        if (iselignoreds.size() > 1 && WebProperties.J2EE_COMPATIBLE.value) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5682));
        }
        String iselignored = (String)iselignoreds.elementAt(0);
        if (iselignored == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5683));
        }
        if (iselignored.equalsIgnoreCase("true")) {
            this.isELIgnored = "true";
        } else if (iselignored.equalsIgnoreCase("false")) {
            this.isELIgnored = "false";
        } else {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5684, (Object)iselignored));
        }
    }

    public void handleCharData(char[] chars, Stack outStack) throws JspEngineException {
        this.handleCharData(null, null, chars, outStack);
    }

    public void handleCharData(char[] chars) throws JspEngineException {
        this.handleCharData(null, null, chars);
    }

    public void handleCharData(char[] chars, int pos) throws JspEngineException {
        CharDataGenerator gen = new CharDataGenerator(chars, null, null);
        this.addGenerator((Generator)gen, SERVICE_METHOD_PHASE, pos);
    }

    public void handleCharData(Mark start, Mark stop, char[] chars) throws JspEngineException {
        this.handleCharData(start, stop, chars, this.peekTagOutStack());
    }

    private void handleCharData(Mark start, Mark stop, char[] chars, Stack tagOutStack) throws JspEngineException {
        int limit = chars.length;
        int ONE_WRITE_LIMIT = 4096;
        if (limit > ONE_WRITE_LIMIT) {
            int blocks = limit / ONE_WRITE_LIMIT;
            for (int i = 0; i < blocks; ++i) {
                VariableCharDataGenerator gen = new VariableCharDataGenerator(this.getCharDataVariable(), chars, start, stop, (i + 1) * ONE_WRITE_LIMIT, i * ONE_WRITE_LIMIT, tagOutStack);
                this.addGenerator(gen, TEMPLATE_DECL_PHASE);
                this.addGenerator(gen, SERVICE_METHOD_PHASE);
            }
            VariableCharDataGenerator gen = new VariableCharDataGenerator(this.getCharDataVariable(), chars, start, stop, limit, blocks * ONE_WRITE_LIMIT, tagOutStack);
            this.addGenerator(gen, TEMPLATE_DECL_PHASE);
            this.addGenerator(gen, SERVICE_METHOD_PHASE);
        } else {
            VariableCharDataGenerator gen = new VariableCharDataGenerator(this.getCharDataVariable(), chars, start, stop, limit, 0, tagOutStack);
            this.addGenerator(gen, TEMPLATE_DECL_PHASE);
            this.addGenerator(gen, SERVICE_METHOD_PHASE);
        }
    }

    String getRootElementName() {
        if (this.rootElementNames.size() == 0) {
            return null;
        }
        return (String)this.rootElementNames.peek();
    }

    public void setRootNoNameSpace(boolean _rootNoNameSpace, String _rootElementName) throws JspEngineException {
        this.rootElementNames.push(_rootElementName);
        this.reader.skipSpaces();
        CharArrayWriter _caw = new CharArrayWriter();
        try {
            _caw.write("<" + _rootElementName + ">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.handleCharData(_caw.toCharArray());
    }

    public void setNameSpace(String _nameSpace) {
        this.nameSpace = _nameSpace;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void resetRootNoNameSpace() throws JspEngineException {
        this.nameSpace = null;
        if (this.rootElementNames.size() == 0) {
            return;
        }
        String rootElementName = (String)this.rootElementNames.pop();
        CharArrayWriter _caw = new CharArrayWriter();
        try {
            _caw.write("</" + rootElementName + ">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.handleCharData(_caw.toCharArray());
    }

    public String findFunctionStaticNames(String defaultNamespace, String expression, boolean includeELOPEN) throws JspParseException {
        HashMap fns = ELFunctionParser.parseFunction(defaultNamespace, expression, includeELOPEN);
        if (fns != null && fns.size() > 0) {
            FunctionMap map;
            int size = this.elStaticFunctionMap.size();
            for (int i = 0; i < size; ++i) {
                map = (FunctionMap)this.elStaticFunctionMap.get(i);
                if (!map.matchMap(fns)) continue;
                return map.mapName;
            }
            for (String fn : fns.keySet()) {
                if (this.functionStaticNames.get(fn) != null) continue;
                throw new JspParseException("no such function is defined in tld : " + fn);
            }
            map = new FunctionMap(fns);
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5676_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5676_LEVEL, JeusMessage_WebContainer5_4._5676, (Object)map.mapName);
            }
            this.elStaticFunctionMap.add(map);
            return map.mapName;
        }
        return null;
    }

    public void putFunctionStaticNames(String prefix, String shortTagName) {
        String tag = prefix + ":" + shortTagName;
        if (this.functionStaticNames.get(tag) == null) {
            this.functionStaticNames.put(tag, tag);
        } else if (logger.isLoggable(JeusMessage_WebContainer5_4._5674_LEVEL)) {
            logger.log(JeusMessage_WebContainer5_4._5674_LEVEL, JeusMessage_WebContainer5_4._5674, (Object)tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFunctionNumber() {
        Integer n = this.functionVarNumber;
        synchronized (n) {
            int i = this.functionVarNumber;
            this.functionVarNumber = new Integer(i + 1);
            return Integer.toString(i);
        }
    }

    public void generateStaticFields() throws JspParseException {
        int functionSize = this.elStaticFunctionMap.size();
        if (functionSize == 0) {
            return;
        }
        for (FunctionMap map : this.elStaticFunctionMap) {
            this.writer.println("private static jeus.servlet.jsp.el.FunctionMapperImpl " + map.mapName + ";");
        }
        this.writer.println("");
        this.writer.println("static {");
        this.writer.pushIndent();
        for (FunctionMap map : this.elStaticFunctionMap) {
            this.writer.println(map.mapName + " = jeus.servlet.jsp.el.FunctionMapperImpl.getInstance();");
            for (String key : map.funcList.keySet()) {
                ELFunctionParser.Function fn = (ELFunctionParser.Function)map.funcList.get(key);
                TagLibraryInfoImpl tli = (TagLibraryInfoImpl)((Object)this.libraries.get(fn.prefix));
                FunctionInfo fi = tli.getFunction(fn.functionName);
                String methodValue = this.makeMethodValue(fi.getFunctionSignature());
                String paramValue = this.makeParamValue(fi.getFunctionSignature());
                this.writer.println(map.mapName + ".mapFunction(\"" + fn.getFullName() + "\", " + fi.getFunctionClass() + ".class, \"" + methodValue + "\", new Class[] {" + paramValue + "});");
            }
            this.writer.println();
        }
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("");
    }

    protected void generateSplittedFunctions() throws JspEngineException {
        Vector generators = (Vector)this.genStore.get(SPLITTED_SERVICE_METHOD_PHASE);
        if (generators == null || generators.size() == 0) {
            return;
        }
        int i = 0;
        do {
            Generator gen = (Generator)generators.elementAt(i);
            gen.generateCode(this.writer, SPLITTED_SERVICE_METHOD_PHASE);
        } while (++i < generators.size());
    }

    protected String makeMethodValue(String param) throws JspParseException {
        StringTokenizer stk = new StringTokenizer(param, " (");
        if (stk.hasMoreTokens()) {
            stk.nextToken();
        }
        if (stk.hasMoreTokens()) {
            return stk.nextToken().trim();
        }
        throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5361));
    }

    protected String makeParamValue(String param) {
        param = param.substring(param.indexOf(40));
        StringBuffer sbf = new StringBuffer();
        StringTokenizer stk = new StringTokenizer(param, ", \t()");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken().trim();
            sbf.append(token + ".class");
            if (!stk.hasMoreTokens()) continue;
            sbf.append(", ");
        }
        return sbf.toString();
    }

    public void setExistRoot(boolean b) {
        this.existRoot = b;
    }

    public boolean getExistRoot() {
        return this.existRoot;
    }

    public String getContentType() {
        return this.servletContentType;
    }

    public void setContentType(String _servletContentType) {
        this.servletContentType = _servletContentType;
    }

    public boolean isSpecialXmlDocument() {
        return this.specialXmlDocument;
    }

    public void setSpecialXmlDocument(boolean _specialXmlDocument) {
        this.specialXmlDocument = _specialXmlDocument;
    }

    public String getCharDataVariable() {
        return new String("_jspx_template" + this.numberOfCharData++);
    }

    public String getJspAttributeVariable() {
        return "_jspx_jspattr" + this.numberOfJspAttribute++;
    }

    public String getJspFragmentClassName() {
        return "_jspx_fragment" + this.numberOfJspFragment++;
    }

    public static String getPageContextName(Generator parentGen) {
        return DEFAULT_TAG_CONTENT_NAME;
    }

    public void generateSplittedTagFunctionHeader() {
        this.writer.println("JspWriter\tout = pageContext.getOut();");
        this.writer.println("HttpSession session = pageContext.getSession();");
        this.writer.println("ServletContext application = pageContext.getServletContext();");
        this.writer.println("HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();");
        this.writer.println();
    }

    public boolean isXmlPrologGenerated() {
        return this.xmlPrologGenerated;
    }

    public void setXmlPrologGenerated(boolean b) {
        this.xmlPrologGenerated = b;
    }

    public abstract JspEngineContext getCtxt();

    public String getCompileEncoding() {
        return this.compileEncoding;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setEncoding(String result0, String result1) {
        JspEngineContext ctxt = this.getCtxt();
        String compileEncoding = ctxt.getCompileEncoding();
        if (compileEncoding == null || compileEncoding.equals("")) {
            compileEncoding = "UsePageEncoding";
        }
        String pageEncoding = null;
        String responseEncoding = null;
        String forcedPageEncoding = ctxt.getForcedPageEncoding();
        String defaultPageEncoding = ctxt.getDefaultPageEncoding();
        if (forcedPageEncoding != null) {
            pageEncoding = forcedPageEncoding;
            responseEncoding = forcedPageEncoding;
        } else {
            pageEncoding = result0;
            responseEncoding = result1;
        }
        if (responseEncoding == null) {
            responseEncoding = "ISO-8859-1";
        }
        String javaEncoding = null;
        if (compileEncoding.equalsIgnoreCase("UTF8") || compileEncoding.equalsIgnoreCase("UTF-8")) {
            compileEncoding = "UTF-8";
            javaEncoding = "UTF-8";
            if (pageEncoding == null) {
                pageEncoding = defaultPageEncoding;
            }
        } else if (compileEncoding.equalsIgnoreCase("UsePageEncoding")) {
            if (pageEncoding == null) {
                javaEncoding = defaultPageEncoding;
                pageEncoding = defaultPageEncoding;
                compileEncoding = defaultPageEncoding;
            } else {
                compileEncoding = pageEncoding;
                javaEncoding = pageEncoding;
            }
        } else if (pageEncoding == null) {
            javaEncoding = compileEncoding;
            pageEncoding = defaultPageEncoding;
        } else {
            javaEncoding = compileEncoding;
        }
        String[] result = new String[3];
        result[0] = pageEncoding;
        this.javaEncoding = javaEncoding;
        this.compileEncoding = compileEncoding;
        this.javaEncoding = pageEncoding;
        if (logger.isLoggable(JeusMessage_WebContainer5._5320_LEVEL)) {
            logger.log(JeusMessage_WebContainer5._5320_LEVEL, JeusMessage_WebContainer5._5320, (Object[])new String[]{ctxt.getJspFile(), pageEncoding, javaEncoding, compileEncoding});
        }
    }

    private class FunctionMap {
        private String mapName;
        private HashMap funcList;

        public FunctionMap(HashMap funcList) {
            this.mapName = "_jspx_fnmap_" + CodeGenerator.this.getFunctionNumber();
            this.funcList = funcList;
        }

        public boolean matchMap(HashMap flist) {
            if (flist.size() != this.funcList.size()) {
                return false;
            }
            for (String key : flist.keySet()) {
                if (this.funcList.get(key) != null) continue;
                return false;
            }
            return true;
        }
    }
}

