/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.Checker;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionParser;
import jeus.servlet.jsp.compiler.FragmentClassGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.JspCodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ScriptingVariableChecker;
import jeus.servlet.jsp.compiler.ScriptletParser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.jsp.compiler.TagCache;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.servlet.jsp.compiler.TagGenerator;
import jeus.servlet.jsp.compiler.TagLibraryInfoImpl;
import jeus.servlet.jsp.compiler.TextParser;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class CustomTagParser
extends Parser {
    private static final String CLOSE_1 = "/>";
    private static final String CLOSE_2 = "></";
    private static final String CLOSE = ">";
    public static final String URN_JSPTAGDIR = "urn:jsptagdir:";
    private static final Vector CUSTOMTAG_NOT_ACCEPT_SET = new Vector();
    private static final JeusLogger logger;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument = xmlViewer == null;
        try {
            if (reader.peekChar() != 60) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Mark start = reader.mark();
        reader.nextChar();
        String tag = reader.parseTagName();
        int i = tag.indexOf(58);
        if (i == -1 || tag.startsWith("!--") || tag.length() == i + 1) {
            reader.reset(start);
            return false;
        }
        if (tag.startsWith("jsp:root")) {
            throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5580));
        }
        if (tag.startsWith("jsp:directive")) {
            reader.reset(start);
            return false;
        }
        Stack outStack = codeGen.getTagOutStack();
        Stack contentStack = codeGen.getTagContentStack();
        Hashtable tagVars = codeGen.getTagVarNumbers();
        ScriptingVariableChecker svChecker = codeGen.getScriptingVariableChecker();
        try {
            String prefix = tag.substring(0, i);
            String shortTagName = null;
            if (i++ < tag.length() - 1) {
                shortTagName = tag.substring(i);
            }
            if (shortTagName == null) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5557));
            }
            if (!isJspDocument && tag.startsWith("jsp:")) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5362));
            }
            Hashtable attrs = reader.parseTagAttributes(false);
            try {
                codeGen.updateTagNameSpace(attrs, true);
            }
            catch (JspEngineException e) {
                // empty catch block
            }
            TagLibraryInfoImpl tli = codeGen.getTagLibraryInfo(prefix);
            if (tli == null) {
                reader.reset(start);
                return false;
            }
            String jspVersion = tli.getRequiredVersion();
            TagInfo ti = tli.getTag(shortTagName);
            if (ti == null) {
                TagFileInfoImpl tfi = tli.getTagFileInfoImpl(shortTagName, codeGen.getContentType());
                if (tfi == null) throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5558, (Object)tag));
                ti = tfi.getTagInfo(tli);
            }
            if (ti == null) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5558, (Object)tag));
            }
            String bc = ti.getBodyContent();
            reader.skipSpaces();
            Mark bodyStart = null;
            Object bodyStop = null;
            if (reader.matches(CLOSE_1) || bc.equalsIgnoreCase("empty")) {
                parser.flushCharData();
                Hashtable jspAttributes = null;
                if (reader.matches(CLOSE_1)) {
                    reader.advance(CLOSE_1.length());
                } else {
                    if (!reader.matches(CLOSE)) throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5559, (Object)tag));
                    reader.advance(CLOSE.length());
                    reader.skipSpaces();
                    jspAttributes = this.checkJspAttribute(ti, reader, xmlViewer, parser, codeGen, attrs, prefix);
                    reader.skipSpaces();
                    String tagEnd = "</" + tag + CLOSE;
                    if (!reader.matches(tagEnd)) {
                        throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5559, (Object)tag));
                    }
                    reader.advance(tagEnd.length());
                }
                Mark stop = reader.mark();
                TagBeginGenerator bgen = null;
                codeGen.currentCustomTag = Checker.increase(codeGen.currentCustomTag);
                bgen = new TagBeginGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, isJspDocument, svChecker, codeGen.isELIgnored);
                if (bc.equalsIgnoreCase("tagdependent") || bc.equalsIgnoreCase("JSP") || bc.equalsIgnoreCase("scriptless")) {
                    // empty if block
                }
                if (jspAttributes != null) {
                    bgen.addAttributes(jspAttributes);
                }
                codeGen.addGenerator(bgen, "ServiceMethodPhase");
                parser.flushCharData();
                TagEndGenerator egen = new TagEndGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, svChecker, parser.isTagFile(), bgen);
                codeGen.addGenerator(egen, "ServiceMethodPhase");
                codeGen.currentCustomTag = Checker.decrease(codeGen.currentCustomTag);
                if (isJspDocument) return true;
                xmlViewer.addCustomTag(reader, start, stop);
                return true;
            } else if (reader.matches(CLOSE_2 + tag + CLOSE)) {
                String tagEnd = CLOSE_2 + tag + CLOSE;
                reader.advance(tagEnd.length());
                Mark stop = reader.mark();
                parser.flushCharData();
                codeGen.currentCustomTag = Checker.increase(codeGen.currentCustomTag);
                TagBeginGenerator bgen = new TagBeginGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, isJspDocument, svChecker, codeGen.isELIgnored);
                if (bc.equalsIgnoreCase("tagdependent") || bc.equalsIgnoreCase("JSP") || bc.equalsIgnoreCase("scriptless")) {
                    // empty if block
                }
                codeGen.addGenerator(bgen, "ServiceMethodPhase");
                parser.flushCharData();
                TagEndGenerator egen = new TagEndGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, svChecker, parser.isTagFile(), bgen);
                codeGen.addGenerator(egen, "ServiceMethodPhase");
                codeGen.currentCustomTag = Checker.decrease(codeGen.currentCustomTag);
                if (isJspDocument) return true;
                xmlViewer.addCustomTag(reader, start, stop);
                return true;
            } else {
                if (!reader.matches(CLOSE)) throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5561, (Object)tag));
                reader.advance(CLOSE.length());
                bodyStart = reader.mark();
                if (!isJspDocument) {
                    xmlViewer.addCustomTag(reader, start, bodyStart);
                }
                parser.flushCharData();
                codeGen.currentCustomTag = Checker.increase(codeGen.currentCustomTag);
                TagBeginGenerator bgen = new TagBeginGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, isJspDocument, svChecker, codeGen.isELIgnored);
                if (!bc.equalsIgnoreCase("tagdependent") && !bc.equalsIgnoreCase("JSP") && !bc.equalsIgnoreCase("scriptless")) throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5560, (Object[])new String[]{tag, bc}));
                svChecker.increaseDepth();
                Hashtable jspAttributes = this.checkJspAttribute(ti, reader, xmlViewer, parser, codeGen, attrs, prefix);
                bgen.addAttributes(jspAttributes);
                codeGen.addGenerator(bgen, "ServiceMethodPhase");
                Vector<TextParser> bodyParserSet = null;
                if (bc.equalsIgnoreCase("tagdependent")) {
                    if (isJspDocument) {
                        bodyParserSet = new Vector<TextParser>();
                        bodyParserSet.add(new TextParser());
                    } else {
                        bodyParserSet = new Vector();
                    }
                } else {
                    bodyParserSet = null;
                }
                JspbodyParser.parse(this, xmlViewer, reader, parser, codeGen, bgen, tag, bodyParserSet, CUSTOMTAG_NOT_ACCEPT_SET, jspAttributes.size() > 0);
                svChecker.decreaseDepth();
                String tagEnd = "</" + tag + CLOSE;
                Mark stop = reader.mark();
                if (!isJspDocument) {
                    xmlViewer.addCustomTagEnd(tagEnd);
                }
                TagEndGenerator egen = new TagEndGenerator(codeGen, jspVersion, prefix, shortTagName, attrs, tli, ti, null, null, outStack, contentStack, tagVars, svChecker, parser.isTagFile(), bgen);
                codeGen.addGenerator(egen, "ServiceMethodPhase");
                codeGen.currentCustomTag = Checker.decrease(codeGen.currentCustomTag);
            }
            return true;
        }
        catch (JspParseException jpe) {
            if (WebProperties.J2EE_COMPATIBLE.value) throw jpe;
            reader.reset(start);
            if (!logger.isLoggable(JeusMessage_WebContainer5_4._5685_LEVEL)) return false;
            logger.log(JeusMessage_WebContainer5_4._5685_LEVEL, JeusMessage_WebContainer5_4._5685, (Object)tag, (Throwable)((Object)jpe));
            return false;
        }
    }

    private Hashtable checkJspAttribute(TagInfo ti, JspReader reader, JspXmlViewer xmlViewer, JspParser parser, CodeGenerator codeGen, Hashtable attrs, String prefix) throws JspEngineException {
        CustomTagJspAttributeInfo rtmap = new CustomTagJspAttributeInfo(ti);
        Hashtable<String, Attribute> jspAttributes = new Hashtable<String, Attribute>();
        Attribute jspAttribute = null;
        while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
            jspAttributes.put(jspAttribute.attributeName, jspAttribute);
        }
        Enumeration enu = attrs.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (!jspAttributes.containsKey(key)) continue;
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5365, (Object)key));
        }
        this.checkJspAttributePrefix(jspAttributes, prefix);
        return jspAttributes;
    }

    private void checkJspAttributePrefix(Hashtable attr, String prefix) throws JspParseException {
        Enumeration keys = attr.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = attr.get(key);
            int i = key.indexOf(58);
            if (i < 0) continue;
            String _prefix = key.substring(0, i);
            if (!prefix.equalsIgnoreCase(_prefix)) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5367, (Object)key));
            }
            String _shortTagName = null;
            if (++i < key.length() - 1) {
                _shortTagName = key.substring(i);
            }
            if (_shortTagName == null) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5368, (Object)prefix));
            }
            attr.remove(key);
            attr.put(_shortTagName, value);
        }
    }

    private TagLibraryInfoImpl getNSUri(JspReader reader, String prefix, CodeGenerator codeGen, Hashtable attrs) throws JspEngineException {
        if (attrs == null) {
            return null;
        }
        String _nameSpaceValue = (String)attrs.get("xmlns:" + prefix);
        if (_nameSpaceValue == null) {
            return null;
        }
        if (_nameSpaceValue.startsWith("\"")) {
            _nameSpaceValue = _nameSpaceValue.substring(0);
        }
        if (_nameSpaceValue.endsWith("\"")) {
            _nameSpaceValue = _nameSpaceValue.substring(0, _nameSpaceValue.length() - 1);
        }
        if (_nameSpaceValue.indexOf(URN_JSPTAGDIR) >= 0) {
            return null;
        }
        codeGen.handleTagLibraryInfo(prefix, _nameSpaceValue, _nameSpaceValue, null);
        TagLibraryInfoImpl tl = codeGen.getTagLibraryInfo(prefix);
        return tl;
    }

    private String getUrnJsptagdir(JspReader reader, String prefix, Hashtable attrs) throws JspEngineException {
        if (attrs == null) {
            return null;
        }
        String _nameSpaceValue = (String)attrs.get("xmlns:" + prefix);
        if (_nameSpaceValue == null || !_nameSpaceValue.startsWith(URN_JSPTAGDIR)) {
            return null;
        }
        String _tagDir = _nameSpaceValue.substring(URN_JSPTAGDIR.length());
        if (_tagDir == null || _tagDir.equalsIgnoreCase("")) {
            return null;
        }
        return _tagDir;
    }

    static {
        CUSTOMTAG_NOT_ACCEPT_SET.add(new ParamParser());
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    }

    public class TagEndGenerator
    extends TagGenerator {
        Checker braceChecker;
        Checker customTagChecker;
        String jspVersion;
        String prefix;
        String shortTagName;
        TagLibraryInfoImpl tli;
        TagInfo ti;
        Hashtable attrs;
        private boolean tagFile;
        private boolean implementsSimpleTag;
        private boolean implementsBodyTag;
        private boolean implementsIterationTag;
        private boolean implementsTryCatchFinally;
        private VariableInfo[] vi;
        private TagVariableInfo[] tvi;
        private TagBeginGenerator beginGenerator;
        private CodeGenerator codeGen;

        public TagEndGenerator(CodeGenerator codeGen, String jspVersion, String prefix, String shortTagName, Hashtable attrs, TagLibraryInfoImpl tli, TagInfo ti, Mark start, Mark stop, Stack outStack, Stack contentStack, Hashtable vars, ScriptingVariableChecker svChecker, boolean tagFile, TagBeginGenerator beginGenerator) {
            super(outStack, contentStack, vars, svChecker);
            this.codeGen = codeGen;
            this.braceChecker = codeGen.currentBrace;
            this.customTagChecker = codeGen.currentCustomTag;
            this.jspVersion = jspVersion;
            this.start = start;
            this.stop = stop;
            this.prefix = prefix;
            this.shortTagName = shortTagName;
            this.tli = tli;
            this.ti = ti;
            this.attrs = attrs;
            this.tagFile = tagFile;
            this.beginGenerator = beginGenerator;
            this.checkTagClass();
        }

        private void checkTagClass() {
            this.vi = this.ti.getVariableInfo(new TagData(this.attrs));
            this.tvi = this.ti.getTagVariableInfos();
            Class tagHandlerClass = this.tli.getTagCache(this.shortTagName).getTagHandlerClass();
            this.implementsBodyTag = BodyTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsIterationTag = IterationTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsTryCatchFinally = TryCatchFinally.class.isAssignableFrom(tagHandlerClass);
            this.implementsSimpleTag = SimpleTag.class.isAssignableFrom(tagHandlerClass);
        }

        boolean isTagMethodSplittable() {
            return this.beginGenerator.isTagMethodSplittable();
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            if (this.isTagMethodSplittable()) {
                if (phase.equals("ServiceMethodPhase")) {
                    this.generateMethodInvoke(writer);
                    this.codeGen.addGenerator(this, "SplittedServiceMethodPhase");
                } else if (phase.equals("SplittedServiceMethodPhase") && !this.implementsSimpleTag) {
                    this.generateTagMethod(writer);
                }
            } else if (phase.equals("ServiceMethodPhase")) {
                this.generateServiceMethodPhase(writer);
            }
            return true;
        }

        private void generateServiceMethodPhase(ServletWriter writer) {
            String thVarName = this.beginGenerator.getTagHandlerVariableName();
            String evalVarName = this.beginGenerator.getTagEvalVariableName();
            if (!this.implementsSimpleTag) {
                if (this.beginGenerator.hasChildren()) {
                    writer.popIndent();
                    if (this.implementsBodyTag || this.implementsIterationTag) {
                        writer.println("} while (" + thVarName + ".doAfterBody() == BodyTag.EVAL_BODY_AGAIN);");
                    } else {
                        writer.println("} while (false);");
                    }
                    this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
                    if (this.implementsBodyTag) {
                        writer.popIndent();
                        writer.println("} finally {");
                        writer.pushIndent();
                        writer.println("if (" + evalVarName + " != Tag.EVAL_BODY_INCLUDE)");
                        writer.pushIndent();
                        String tagOutput = this.getOutName();
                        if (tagOutput.equals("out")) {
                            writer.println("out = pageContext.popBody();");
                        } else {
                            writer.println(tagOutput + " = jspContext.popBody();");
                        }
                        writer.popIndent();
                        writer.popIndent();
                        writer.println("}");
                    }
                    writer.popIndent();
                    writer.println("}");
                }
                writer.println("if (" + thVarName + ".doEndTag() == Tag.SKIP_PAGE)");
                writer.pushIndent();
                if (this.tagFile) {
                    writer.println("throw new SkipPageException();");
                } else {
                    writer.println("return;");
                }
                writer.popIndent();
                writer.popIndent();
                if (this.implementsTryCatchFinally) {
                    writer.println("} catch (Throwable t) {");
                    writer.pushIndent();
                    writer.println(thVarName + ".doCatch(t);");
                    writer.popIndent();
                    writer.println("} finally {");
                    writer.pushIndent();
                    writer.println(thVarName + ".doFinally();");
                    writer.popIndent();
                    writer.println("}");
                    writer.popIndent();
                }
                writer.println("} finally {");
                writer.pushIndent();
                writer.println(thVarName + ".release();");
                writer.popIndent();
                writer.println("}");
            }
            this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
            this.declareVariables(writer, this.vi, this.tvi, true, true, 2, this.braceChecker, this.customTagChecker);
        }

        private void generateMethodInvoke(ServletWriter writer) {
            this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
            this.declareVariables(writer, this.vi, this.tvi, true, true, 2, this.braceChecker, this.customTagChecker);
        }

        private void generateTagMethod(ServletWriter writer) {
            String thVarName = this.beginGenerator.getTagHandlerVariableName();
            String evalVarName = this.beginGenerator.getTagEvalVariableName();
            if (this.beginGenerator.hasChildren()) {
                writer.popIndent();
                if (this.implementsBodyTag || this.implementsIterationTag) {
                    writer.println("} while (" + thVarName + ".doAfterBody() == BodyTag.EVAL_BODY_AGAIN);");
                } else {
                    writer.println("} while (false);");
                }
                this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
                if (this.implementsBodyTag) {
                    writer.popIndent();
                    writer.println("} finally {");
                    writer.pushIndent();
                    writer.println("if (" + evalVarName + " != Tag.EVAL_BODY_INCLUDE)");
                    writer.pushIndent();
                    String tagOutput = this.getOutName();
                    if (tagOutput.equals("out")) {
                        writer.println("out = pageContext.popBody();");
                    } else {
                        writer.println(tagOutput + " = jspContext.popBody();");
                    }
                    writer.popIndent();
                    writer.popIndent();
                    writer.println("}");
                }
                writer.popIndent();
                writer.println("}");
            }
            writer.println("if (" + thVarName + ".doEndTag() == Tag.SKIP_PAGE)");
            writer.pushIndent();
            if (this.tagFile) {
                writer.println("throw new SkipPageException();");
            } else {
                writer.println("return true;");
            }
            writer.popIndent();
            writer.popIndent();
            if (this.implementsTryCatchFinally) {
                writer.println("} catch (Throwable t) {");
                writer.pushIndent();
                writer.println(thVarName + ".doCatch(t);");
                writer.popIndent();
                writer.println("} finally {");
                writer.pushIndent();
                writer.println(thVarName + ".doFinally();");
                writer.popIndent();
                writer.println("}");
                writer.popIndent();
            }
            writer.println("} finally {");
            writer.pushIndent();
            writer.println(thVarName + ".release();");
            writer.popIndent();
            writer.println("}");
            writer.println("return false;");
            writer.popIndent();
            writer.println("}");
        }
    }

    public class TagBeginGenerator
    extends TagGenerator {
        Checker braceChecker;
        Checker customTagChecker;
        String jspVersion;
        String prefix;
        String shortTagName;
        private Hashtable attrs;
        private Hashtable attrsIgnoreCase;
        TagLibraryInfoImpl tli;
        TagInfo ti;
        TagAttributeInfo[] attributes;
        private String baseVarName;
        private String thVarName;
        private String evalVarName;
        TagCache tc;
        TagData tagData;
        boolean isJspDocument;
        private String elIgnore;
        private boolean implementsSimpleTag;
        private boolean implementsBodyTag;
        private boolean implementsIterationTag;
        private boolean implementsTryCatchFinally;
        private VariableInfo[] vi;
        private TagVariableInfo[] tvi;
        private CodeGenerator codeGen;

        public void addAttributes(Hashtable _attrs) {
            this.attrs.putAll(_attrs);
        }

        public TagBeginGenerator(CodeGenerator codeGen, String jspVersion, String prefix, String shortTagName, Hashtable attrs, TagLibraryInfoImpl tli, TagInfo ti, Mark start, Mark stop, Stack outStack, Stack contentStack, Hashtable vars, boolean isJspDocument, ScriptingVariableChecker svChecker, String elIgnore) {
            super(outStack, contentStack, vars, svChecker);
            this.codeGen = codeGen;
            this.braceChecker = codeGen.currentBrace;
            this.customTagChecker = codeGen.currentCustomTag;
            this.jspVersion = jspVersion;
            this.start = start;
            this.stop = stop;
            this.prefix = prefix;
            this.shortTagName = shortTagName;
            this.attrs = attrs;
            this.tli = tli;
            this.ti = ti;
            this.attributes = ti.getAttributes();
            this.baseVarName = this.getTagVarName(prefix, shortTagName);
            this.thVarName = "_jspx_th_" + this.baseVarName;
            this.evalVarName = "_jspx_eval_" + this.baseVarName;
            this.isJspDocument = isJspDocument;
            this.elIgnore = elIgnore;
            this.attrsIgnoreCase = new Hashtable();
            Enumeration enum1 = attrs.keys();
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                this.attrsIgnoreCase.put(key.toLowerCase(), attrs.get(key));
            }
        }

        private void checkTagClass() {
            Class tagHandlerClass = this.tli.getTagCache(this.shortTagName).getTagHandlerClass();
            this.implementsSimpleTag = SimpleTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsBodyTag = BodyTag.class.isAssignableFrom(this.tc.getTagHandlerClass());
            this.implementsIterationTag = IterationTag.class.isAssignableFrom(this.tc.getTagHandlerClass());
            this.implementsTryCatchFinally = TryCatchFinally.class.isAssignableFrom(this.tc.getTagHandlerClass());
            this.vi = this.ti.getVariableInfo(this.tagData);
            this.tvi = this.ti.getTagVariableInfos();
        }

        public String getTagHandlerVariableName() {
            return this.thVarName;
        }

        public String getTagEvalVariableName() {
            return this.evalVarName;
        }

        public boolean isImplementSimpleTag() {
            return this.implementsSimpleTag;
        }

        boolean isTagMethodSplittable() {
            if (this.vi != null && this.vi.length > 0 || this.tvi != null && this.tvi.length > 0 || this.hasRuntimeExpressionAttribute()) {
                return false;
            }
            Enumeration enum1 = this.children.elements();
            while (enum1.hasMoreElements()) {
                Generator gen = (Generator)enum1.nextElement();
                if (gen instanceof TagBeginGenerator) {
                    if (((TagBeginGenerator)gen).isTagMethodSplittable()) continue;
                    return false;
                }
                if (gen instanceof ExpressionParser.ExpressionGenerator) {
                    return false;
                }
                if (!(gen instanceof ScriptletParser.ScriptletGenerator)) continue;
                return false;
            }
            return true;
        }

        private boolean hasRuntimeExpressionAttribute() {
            for (int i = 0; i < this.attributes.length; ++i) {
                String attrValue = null;
                Object attrValueObj = this.attrs.get(this.attributes[i].getName());
                if (!(attrValueObj instanceof String)) continue;
                attrValue = (String)attrValueObj;
                if (!this.attributes[i].canBeRequestTime() || attrValue == null || !JspUtil.isExpression(attrValue, this.isJspDocument)) continue;
                return true;
            }
            return false;
        }

        public void init(JspEngine engine) throws JspEngineException {
            this.validate();
            this.tc = this.tli.getTagCache(this.shortTagName);
            if (this.tc == null) {
                this.tc = new TagCache(this.shortTagName);
                Class<?> clz = null;
                try {
                    clz = Thread.currentThread().getContextClassLoader().loadClass(this.ti.getTagClassName());
                }
                catch (Exception ex) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5562, (Object[])new String[]{this.shortTagName, this.ti.getTagClassName()}), ex);
                }
                this.tc.setTagHandlerClass(clz);
                this.tli.putTagCache(this.shortTagName, this.tc);
            }
            this.checkTagClass();
        }

        private void validate() throws JspEngineException {
            if (!this.ti.hasDynamicAttributes()) {
                for (int i = 0; i < this.attributes.length; ++i) {
                    if (!this.attributes[i].isRequired() || this.attrs.get(this.attributes[i].getName()) != null || this.attrsIgnoreCase.get(this.attributes[i].getName().toLowerCase()) != null) continue;
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5563, (Object[])new String[]{this.shortTagName, this.attributes[i].getName()}));
                }
                Enumeration e = this.attrs.keys();
                while (e.hasMoreElements()) {
                    String attr = (String)e.nextElement();
                    boolean found = false;
                    for (int i = 0; i < this.attributes.length; ++i) {
                        if (!attr.equals(this.attributes[i].getName())) continue;
                        found = true;
                    }
                    if (attr.startsWith("xmlns") || found || !WebProperties.J2EE_COMPATIBLE.value) continue;
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5564, (Object[])new String[]{this.shortTagName, attr}));
                }
            }
            this.tagData = this.makeTagData();
            ValidationMessage[] msg = this.ti.validate(this.tagData);
            if (msg != null && msg.length > 0) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5565, (Object[])new Object[]{this.shortTagName, msg[0].getMessage()}));
            }
        }

        private TagData makeTagData() {
            Hashtable attrs0 = (Hashtable)this.attrs.clone();
            Hashtable<String, Object> nattrs = new Hashtable<String, Object>();
            for (int i = 0; i < this.attributes.length; ++i) {
                Object value = attrs0.get(this.attributes[i].getName());
                if (value == null) continue;
                attrs0.remove(this.attributes[i].getName());
                if (value instanceof String) {
                    nattrs.put(this.attributes[i].getName(), value);
                    continue;
                }
                if (value instanceof StringAttribute) {
                    nattrs.put(this.attributes[i].getName(), ((StringAttribute)value).getAttributeValue());
                    continue;
                }
                nattrs.put(this.attributes[i].getName(), TagData.REQUEST_TIME_VALUE);
            }
            Enumeration enum1 = attrs0.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                nattrs.put(name, TagData.REQUEST_TIME_VALUE);
            }
            return new TagData(nattrs);
        }

        private final void generateSetters(ServletWriter writer, String parentVarName, boolean parentImplementsSimpleTag) throws JspEngineException {
            StringAttribute stringAttribute;
            Class<?>[] c;
            Method m;
            if (this.implementsSimpleTag) {
                writer.println(this.thVarName + ".setJspContext(" + "pageContext" + ");");
                if (parentVarName != null) {
                    if (parentImplementsSimpleTag) {
                        writer.println(this.thVarName + ".setParent(" + parentVarName + ");");
                    } else {
                        writer.println(this.thVarName + ".setParent((javax.servlet.jsp.tagext.Tag)" + parentVarName + ");");
                    }
                }
            } else {
                writer.println(this.thVarName + ".setPageContext(" + "pageContext" + ");");
                if (this.parent != null) {
                    if (parentImplementsSimpleTag) {
                        writer.println(this.thVarName + ".setParent(new javax.servlet.jsp.tagext.TagAdapter((javax.servlet.jsp.tagext.SimpleTag)" + parentVarName + "));");
                    } else {
                        writer.println(this.thVarName + ".setParent((javax.servlet.jsp.tagext.Tag)" + parentVarName + ");");
                    }
                }
            }
            Hashtable attrs2 = (Hashtable)this.attrs.clone();
            if (this.attributes.length != 0) {
                boolean expressionFlag = false;
                boolean jspattrsFlag = false;
                for (int i = 0; i < this.attributes.length; ++i) {
                    Class<?>[] c2;
                    Method m2;
                    String attrName;
                    expressionFlag = false;
                    Object attrValue = null;
                    attrValue = attrs2.remove(this.attributes[i].getName());
                    if (attrValue == null) continue;
                    if (attrValue instanceof Attribute) {
                        jspattrsFlag = true;
                    } else if (!(attrValue instanceof String)) continue;
                    if (attrValue instanceof JspAttribute) {
                        attrName = this.attributes[i].getName();
                        m = this.tc.getSetterMethod(attrName);
                        if (m == null) continue;
                        c = m.getParameterTypes();
                        JspAttribute jspAttribute = attrValue;
                        jspAttribute.generate(writer, this.codeGen, this.isJspDocument, this.prefix, c[0], this.tc.getPropertyEditorClass(jspAttribute.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName);
                        if (jspAttribute.jspFragment) {
                            writer.println(this.thVarName + "." + m.getName() + "(" + jspAttribute.variableName + ");");
                            continue;
                        }
                        String valueStr = "(" + c[0].getName().substring(c[0].getName().lastIndexOf(46) + 1) + ")jeus.servlet.jsp.JspRuntimeLibrary.coerce(" + jspAttribute.variableName + ", " + c[0].getName() + ".class)";
                        writer.println(this.thVarName + "." + m.getName() + "( " + valueStr + ");");
                        continue;
                    }
                    if (attrValue instanceof StringAttribute) {
                        attrName = this.attributes[i].getName();
                        stringAttribute = attrValue;
                        m2 = this.tc.getSetterMethod(attrName);
                        if (m2 == null) continue;
                        c2 = m2.getParameterTypes();
                        writer.println(this.thVarName + "." + m2.getName() + "(" + stringAttribute.generate(writer, this.codeGen, this.isJspDocument, this.prefix, c2[0], this.tc.getPropertyEditorClass(stringAttribute.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
                        continue;
                    }
                    attrName = this.attributes[i].getName();
                    String attrValueString = attrValue;
                    m2 = this.tc.getSetterMethod(attrName);
                    if (m2 == null) continue;
                    c2 = m2.getParameterTypes();
                    StringAttribute stringAttribute2 = new StringAttribute(attrName, attrValueString, this.codeGen.getJspAttributeVariable(), false, this.attributes[i].isFragment(), this.attributes[i].canBeRequestTime());
                    writer.println(this.thVarName + "." + m2.getName() + "(" + stringAttribute2.generate(writer, this.codeGen, this.isJspDocument, this.prefix, c2[0], this.tc.getPropertyEditorClass(stringAttribute2.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
                }
            }
            if (attrs2.size() == 0) {
                return;
            }
            boolean supportDynamicAttribute = this.ti.hasDynamicAttributes();
            Enumeration enum1 = attrs2.keys();
            while (enum1.hasMoreElements()) {
                String attrName = (String)enum1.nextElement();
                Object value = attrs2.get(attrName);
                if (value instanceof JspAttribute) {
                    JspAttribute jspAttribute = (JspAttribute)value;
                    jspAttribute.generate(writer, this.codeGen, this.isJspDocument, this.prefix, null, this.tc.getPropertyEditorClass(jspAttribute.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName);
                    if (supportDynamicAttribute) {
                        writer.println(this.thVarName + ".setDynamicAttribute(null, \"" + attrName + "\", " + jspAttribute.variableName + ");");
                        continue;
                    }
                    m = this.tc.getSetterMethod(attrName);
                    if (m == null) continue;
                    c = m.getParameterTypes();
                    if (jspAttribute.jspFragment) {
                        writer.println(this.thVarName + "." + m.getName() + "(" + jspAttribute.variableName + ");");
                        continue;
                    }
                    String valueStr = "(" + c[0].getName().substring(c[0].getName().lastIndexOf(46) + 1) + ")jeus.servlet.jsp.JspRuntimeLibrary.coerce(" + jspAttribute.variableName + ", " + c[0].getName() + ".class)";
                    writer.println(this.thVarName + "." + m.getName() + "( " + valueStr + ");");
                    continue;
                }
                if (value instanceof StringAttribute) {
                    StringAttribute stringAttribute3 = (StringAttribute)value;
                    if (supportDynamicAttribute) {
                        writer.println(this.thVarName + ".setDynamicAttribute(null, \"" + attrName + "\", " + stringAttribute3.generate(writer, this.codeGen, this.isJspDocument, this.prefix, String.class, this.tc.getPropertyEditorClass(stringAttribute3.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
                        continue;
                    }
                    m = this.tc.getSetterMethod(attrName);
                    if (m == null) continue;
                    c = m.getParameterTypes();
                    writer.println(this.thVarName + "." + m.getName() + "(" + stringAttribute3.generate(writer, this.codeGen, this.isJspDocument, this.prefix, c[0], this.tc.getPropertyEditorClass(stringAttribute3.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
                    continue;
                }
                String attrValue = (String)value;
                if (supportDynamicAttribute) {
                    stringAttribute = new StringAttribute(attrName, attrValue, this.codeGen.getJspAttributeVariable(), false, false, true);
                    writer.println(this.thVarName + ".setDynamicAttribute(null, \"" + attrName + "\", " + stringAttribute.generate(writer, this.codeGen, this.isJspDocument, this.prefix, String.class, this.tc.getPropertyEditorClass(stringAttribute.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
                    continue;
                }
                if (attrValue == null || (m = this.tc.getSetterMethod(attrName)) == null) continue;
                c = m.getParameterTypes();
                StringAttribute stringAttribute4 = new StringAttribute(attrName, attrValue, this.codeGen.getJspAttributeVariable(), false, false, true);
                writer.println(this.thVarName + "." + m.getName() + "(" + stringAttribute4.generate(writer, this.codeGen, this.isJspDocument, this.prefix, c[0], this.tc.getPropertyEditorClass(stringAttribute4.attributeName), CodeGenerator.getPageContextName(this.parent), this.thVarName) + ");");
            }
        }

        private void generateServiceMethodPhase(ServletWriter writer, String phase) throws JspEngineException {
            this.generateTagCreation(writer, false);
            if (!this.implementsSimpleTag) {
                writer.println("try {");
                writer.pushIndent();
                if (this.implementsTryCatchFinally) {
                    writer.println("try {");
                    writer.pushIndent();
                }
                writer.println("int " + this.evalVarName + " = " + this.thVarName + ".doStartTag();");
                this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
                if (this.hasChildren()) {
                    String tagOutput = this.getOutName();
                    writer.println("if (" + this.evalVarName + " != Tag.SKIP_BODY) {");
                    writer.pushIndent();
                    if (this.implementsBodyTag) {
                        writer.println("try {");
                        writer.pushIndent();
                        writer.println("if (" + this.evalVarName + " != Tag.EVAL_BODY_INCLUDE) {");
                        writer.pushIndent();
                        if (tagOutput.equals("out")) {
                            writer.println("out = pageContext.pushBody();");
                            writer.println(this.thVarName + ".setBodyContent((BodyContent) out);");
                        } else {
                            writer.println(tagOutput + " = ((javax.servlet.jsp.PageContext)jspContext).pushBody();");
                            writer.println(this.thVarName + ".setBodyContent((BodyContent) " + tagOutput + ");");
                        }
                        writer.println(this.thVarName + ".doInitBody();");
                        writer.popIndent();
                        writer.println("}");
                    }
                    writer.println("do {");
                    writer.pushIndent();
                }
                this.declareVariables(writer, this.vi, this.tvi, true, true, 0, this.braceChecker, this.customTagChecker);
                this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
                if (this.hasChildren()) {
                    for (int i = 0; i < this.children.size(); ++i) {
                        Generator gen = (Generator)this.children.get(i);
                        gen.generateCode(writer, phase);
                    }
                }
            } else {
                if (this.children.size() > 0) {
                    String fragClassName = this.thVarName + "_body_frag";
                    FragmentClassGenerator fgen = new FragmentClassGenerator(fragClassName, this);
                    this.codeGen.addGenerator(fgen, "SplittedServiceMethodPhase");
                    String contentName = CodeGenerator.getPageContextName(this.parent);
                    writer.println(this.thVarName + ".setJspBody(new " + fragClassName + "(" + contentName + ", " + this.thVarName + "));");
                }
                writer.println(this.thVarName + ".doTag();");
            }
        }

        private void generateTagCreation(ServletWriter writer, boolean splitted) throws JspEngineException {
            String parentVariableName = null;
            boolean parentImplementsSimpleTag = false;
            TagBeginGenerator parentTagGenerator = this.getParentTag();
            if (parentTagGenerator != null) {
                parentImplementsSimpleTag = parentTagGenerator.isImplementSimpleTag();
                parentVariableName = splitted ? "_jspx_parentTag" : parentTagGenerator.getTagHandlerVariableName();
            }
            writer.println("// ----  " + this.prefix + ":" + this.shortTagName + " ---- //");
            writer.println(this.ti.getTagClassName() + " " + this.thVarName + " = new " + this.ti.getTagClassName() + "();");
            this.generateSetters(writer, parentVariableName, parentImplementsSimpleTag);
            if (this.tvi != null && this.tvi.length > 0 && this.vi != null && this.vi.length > 0) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5567, (Object[])new String[]{this.prefix, this.shortTagName}));
            }
            this.declareVariables(writer, this.vi, this.tvi, true, false, 1, this.braceChecker, this.customTagChecker);
        }

        private void generateMethodInvoke(ServletWriter writer) {
            String parentName;
            boolean inJspServiceMethod = this.customTagChecker.parent != null && (this.customTagChecker.parent.inJspServiceMethod || this.customTagChecker.parent.parent == null);
            String contentName = CodeGenerator.getPageContextName(this.parent);
            boolean inFragmentInvoke = this.parent != null && this.parent instanceof FragmentClassGenerator;
            writer.println("// ----  " + this.prefix + ":" + this.shortTagName + " ---- invoke //");
            this.declareVariables(writer, this.vi, this.tvi, true, false, 1, this.braceChecker, this.customTagChecker);
            TagBeginGenerator parentTagGenerator = this.getParentTag();
            String string = parentName = parentTagGenerator == null ? "null" : parentTagGenerator.getTagHandlerVariableName();
            if (inJspServiceMethod) {
                writer.println("if (" + this.thVarName + "_fn(" + contentName + ", " + parentName + ")) return;");
            } else if (inFragmentInvoke) {
                writer.println("if (" + this.thVarName + "_fn(getPageContext(), getParentTag())) return;");
            } else {
                writer.println("if (" + this.thVarName + "_fn(" + contentName + ", " + parentName + ")) return true;");
            }
        }

        private void generateTagMethod(ServletWriter writer, String phase) throws JspEngineException {
            this.customTagChecker.inJspServiceMethod = false;
            writer.println("private boolean " + this.thVarName + "_fn(javax.servlet.jsp.PageContext pageContext, javax.servlet.jsp.tagext.JspTag " + "_jspx_parentTag" + ") throws Throwable {");
            writer.pushIndent();
            this.codeGen.generateSplittedTagFunctionHeader();
            this.generateTagCreation(writer, true);
            writer.println("try {");
            writer.pushIndent();
            if (this.implementsTryCatchFinally) {
                writer.println("try {");
                writer.pushIndent();
            }
            writer.println("int " + this.evalVarName + " = " + this.thVarName + ".doStartTag();");
            this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
            if (this.children.size() > 0) {
                String tagOutput = this.getOutName();
                writer.println("if (" + this.evalVarName + " != Tag.SKIP_BODY) {");
                writer.pushIndent();
                if (this.implementsBodyTag) {
                    writer.println("try {");
                    writer.pushIndent();
                    writer.println("if (" + this.evalVarName + " != Tag.EVAL_BODY_INCLUDE) {");
                    writer.pushIndent();
                    if (tagOutput.equals("out")) {
                        writer.println("out = pageContext.pushBody();");
                        writer.println(this.thVarName + ".setBodyContent((BodyContent) out);");
                    } else {
                        writer.println(tagOutput + " = ((javax.servlet.jsp.PageContext)jspContext).pushBody();");
                        writer.println(this.thVarName + ".setBodyContent((BodyContent) " + tagOutput + ");");
                    }
                    writer.println(this.thVarName + ".doInitBody();");
                    writer.popIndent();
                    writer.println("}");
                }
                writer.println("do {");
                writer.pushIndent();
            }
            this.declareVariables(writer, this.vi, this.tvi, true, true, 0, this.braceChecker, this.customTagChecker);
            this.declareVariables(writer, this.vi, this.tvi, false, true, 1, this.braceChecker, this.customTagChecker);
            if (this.children.size() > 0) {
                for (int i = 0; i < this.children.size(); ++i) {
                    Generator gen = (Generator)this.children.get(i);
                    gen.generateCode(writer, phase);
                }
            }
        }

        private void generateFragmentMethod(ServletWriter writer) throws JspEngineException {
            this.customTagChecker.inJspServiceMethod = false;
            writer.println("private boolean " + this.thVarName + "_fn(javax.servlet.jsp.PageContext pageContext, javax.servlet.jsp.tagext.JspTag " + "_jspx_parentTag" + ") throws Throwable {");
            writer.pushIndent();
            if (this.codeGen instanceof JspCodeGenerator) {
                ((JspCodeGenerator)this.codeGen).generateSplittedTagFunctionHeader();
            }
            this.generateTagCreation(writer, true);
            if (this.children.size() > 0) {
                String fragClassName = this.thVarName + "_body_frag";
                FragmentClassGenerator fgen = new FragmentClassGenerator(fragClassName, this);
                this.codeGen.addGenerator(fgen, "SplittedServiceMethodPhase");
                String contentName = CodeGenerator.getPageContextName(this.parent);
                writer.println(this.thVarName + ".setJspBody(new " + fragClassName + "(" + contentName + ", " + this.thVarName + "));");
            }
            writer.println(this.thVarName + ".doTag();");
            writer.println("return false;");
            writer.popIndent();
            writer.println("}");
            writer.println();
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            if (this.isTagMethodSplittable()) {
                if (phase.equals("ServiceMethodPhase")) {
                    this.generateMethodInvoke(writer);
                    this.codeGen.addGenerator((Generator)this, "SplittedServiceMethodPhase", false);
                } else if (phase.equals("SplittedServiceMethodPhase")) {
                    if (this.implementsSimpleTag) {
                        this.generateFragmentMethod(writer);
                    } else {
                        this.generateTagMethod(writer, "ServiceMethodPhase");
                    }
                }
            } else if (phase.equals("ServiceMethodPhase")) {
                this.generateServiceMethodPhase(writer, phase);
            }
            return true;
        }
    }

    private class CustomTagJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private boolean supportDynamicAttribute;
        private HashMap rtattrs;
        private HashMap fragattrs;

        private CustomTagJspAttributeInfo(TagInfo ti) {
            this.supportDynamicAttribute = ti.hasDynamicAttributes();
            this.rtattrs = new HashMap();
            this.fragattrs = new HashMap();
            TagAttributeInfo[] tagAttributes = ti.getAttributes();
            if (tagAttributes != null && tagAttributes.length > 0) {
                for (int i = 0; i < tagAttributes.length; ++i) {
                    if (tagAttributes[i].canBeRequestTime()) {
                        this.rtattrs.put(tagAttributes[i].getName(), new Boolean(true));
                    }
                    if (!tagAttributes[i].isFragment()) continue;
                    this.fragattrs.put(tagAttributes[i].getName(), new Boolean(true));
                }
            }
        }

        public boolean isRTExprAttribute(String attrname) {
            return this.rtattrs.get(attrname) != null || this.supportDynamicAttribute;
        }

        public boolean isEnableScript(String attrname) {
            return this.fragattrs.get(attrname) == null;
        }

        public boolean isJspFragment(String attrname) {
            return this.fragattrs.get(attrname) != null;
        }
    }
}

