/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.JspProperty;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.XmlCdataProcessor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class ExpressionEvaluatorParser
extends Parser {
    private static final String OPEN_EXPR = "${";
    private static final String CLOSE_EXPR = "}";

    ExpressionEvaluatorParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (codeGen.isELIgnored == null) {
            JspProperty jspProperty = parser.getJspProperty();
            if (parser.isWebApp_2_3()) {
                return false;
            }
            if (jspProperty != null && jspProperty.isElIgnored()) {
                return false;
            }
        } else if (codeGen.isELIgnored.equalsIgnoreCase("true")) {
            return false;
        }
        boolean isJspDocument = xmlViewer == null;
        String open = OPEN_EXPR;
        String close = CLOSE_EXPR;
        if (!reader.matches(open)) {
            return false;
        }
        reader.advance(open.length());
        Mark start = reader.mark();
        Mark stop = null;
        char[] data = null;
        if (!isJspDocument) {
            stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)open));
            }
            parser.flushCharData();
            xmlViewer.addExpression(reader, start, stop);
            data = reader.getChars(start, stop);
        } else {
            XmlCdataProcessor xcp = new XmlCdataProcessor(reader, open, close);
            data = xcp.process();
            parser.flushCharData();
        }
        String functionVarName = "null";
        String exp = new String(data);
        functionVarName = codeGen.findFunctionStaticNames(null, exp, false);
        ExpressionEvaluatorGenerator gen = new ExpressionEvaluatorGenerator(data, open, close, start, stop, functionVarName);
        codeGen.addGenerator(gen, "ServiceMethodPhase");
        return true;
    }

    public static boolean checkEL(String _phase, String elIgnore) {
        if (_phase == null) {
            return false;
        }
        String phase = _phase;
        int index = _phase.indexOf(OPEN_EXPR);
        if (index > 0 && _phase.charAt(index - 1) != '\\') {
            phase = _phase.substring(_phase.indexOf(OPEN_EXPR));
        }
        if (phase.startsWith(OPEN_EXPR) && phase.indexOf(CLOSE_EXPR) > 1) {
            if (elIgnore == null) {
                return true;
            }
            return elIgnore.equals("false");
        }
        return false;
    }

    private static String checkCRLF(String input) {
        int len = input.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '\n') {
                buf.append("\\n");
                continue;
            }
            if (ch == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String generate(String phase, Class returnType, String functionValueName) {
        return ExpressionEvaluatorParser.generate(phase, returnType, functionValueName, "pageContext");
    }

    public static String generate(String phase, Class returnType, String functionValueName, String contentName) {
        if (returnType == null) {
            returnType = String.class;
        }
        String targetType = returnType.getName();
        String primitiveConverterMethod = null;
        if (returnType.isPrimitive()) {
            if (returnType.equals(Boolean.TYPE)) {
                targetType = Boolean.class.getName();
                primitiveConverterMethod = "booleanValue";
            } else if (returnType.equals(Byte.TYPE)) {
                targetType = Byte.class.getName();
                primitiveConverterMethod = "byteValue";
            } else if (returnType.equals(Character.TYPE)) {
                targetType = Character.class.getName();
                primitiveConverterMethod = "charValue";
            } else if (returnType.equals(Short.TYPE)) {
                targetType = Short.class.getName();
                primitiveConverterMethod = "shortValue";
            } else if (returnType.equals(Integer.TYPE)) {
                targetType = Integer.class.getName();
                primitiveConverterMethod = "intValue";
            } else if (returnType.equals(Long.TYPE)) {
                targetType = Long.class.getName();
                primitiveConverterMethod = "longValue";
            } else if (returnType.equals(Float.TYPE)) {
                targetType = Float.class.getName();
                primitiveConverterMethod = "floatValue";
            } else if (returnType.equals(Double.TYPE)) {
                targetType = Double.class.getName();
                primitiveConverterMethod = "doubleValue";
            }
        }
        String _functionValueName = "null";
        if (functionValueName != null) {
            _functionValueName = functionValueName;
        }
        String _body = new String(JspUtil.addQuotes(phase));
        String head = "";
        String body = _body;
        int index = _body.indexOf(OPEN_EXPR);
        if (index > 0 && _body.charAt(index - 1) != '\\') {
            head = "\"" + _body.substring(0, _body.indexOf(OPEN_EXPR)) + "\" + ";
            body = _body.substring(_body.indexOf(OPEN_EXPR));
        }
        body = ExpressionEvaluatorParser.checkCRLF(body);
        String content = contentName;
        if (contentName.indexOf(41) > 0) {
            content = "(" + contentName + ")";
        }
        StringBuffer call = new StringBuffer("(" + targetType + ")jeus.servlet.jsp.el.JeusExpressionEvaluator.evaluate(\"" + body + "\", " + targetType + ".class , " + content + ".getVariableResolver(), " + _functionValueName + ")");
        if (primitiveConverterMethod != null) {
            call.insert(0, "(");
            call.append(")." + primitiveConverterMethod + "()");
        }
        return head + call.toString();
    }

    class ExpressionEvaluatorGenerator
    extends Generator {
        char[] chars;
        String open;
        String close;
        String functionVarName;

        public ExpressionEvaluatorGenerator(char[] chars, String open, String close, Mark start, Mark stop, String functionVarName) {
            this.start = start;
            this.stop = stop;
            this.chars = chars;
            this.open = open;
            this.close = close;
            this.functionVarName = functionVarName;
        }

        public boolean generate(ServletWriter writer, String phase) {
            String body = new String(JspUtil.addQuotes(this.chars));
            body = ExpressionEvaluatorParser.checkCRLF(body);
            String outStr = "(String)jeus.servlet.jsp.el.JeusExpressionEvaluator.evaluate(\"" + this.open + body + this.close + "\",java.lang.String.class , pageContext.getVariableResolver(), " + this.functionVarName + ")";
            writer.println("out.write(" + outStr + ");");
            return true;
        }
    }
}

