/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CustomTagParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.ServletWriter;

public class FragmentClassGenerator
extends Generator {
    private String className;
    private String content;

    public FragmentClassGenerator(JspAttribute attr, String fragmentClassName) {
        this.className = fragmentClassName;
        this.content = null;
    }

    public FragmentClassGenerator(String className, CustomTagParser.TagBeginGenerator bgen) {
        this.className = className;
        this.content = null;
        this.parent = bgen;
        this.children = bgen.children;
        for (int i = 0; i < this.children.size(); ++i) {
            ((Generator)this.children.get((int)i)).parent = this;
        }
        bgen.children = new Vector();
        bgen.addChild(this);
    }

    public FragmentClassGenerator(String className, String content) {
        this.className = className;
        this.content = content;
    }

    public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
        if (!phase.equals("SplittedServiceMethodPhase")) {
            return false;
        }
        writer.println("private class " + this.className + " extends jeus.servlet.jsp.compiler.JspFragmentBase {");
        writer.pushIndent();
        writer.println("private " + this.className + "(JspContext jspContext, JspTag parentTag) {");
        writer.pushIndent();
        writer.println("super(jspContext, parentTag);");
        writer.popIndent();
        writer.println("}");
        writer.println("public void invoke(java.io.Writer writer) throws JspException, IOException {");
        writer.pushIndent();
        writer.println("javax.servlet.jsp.JspWriter out;");
        writer.println("if (writer == null) {");
        writer.pushIndent();
        writer.println("out = getJspContext().getOut();");
        writer.popIndent();
        writer.println("} else {");
        writer.pushIndent();
        writer.println("out = getJspContext().pushBody(writer);");
        writer.popIndent();
        writer.println("}");
        writer.println("try{");
        writer.pushIndent();
        if (this.content != null) {
            writer.println("out.write(" + ServletWriter.quoteString(this.content) + ");");
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                ((Generator)this.children.get(i)).generateCode(writer, "ServiceMethodPhase");
            }
        }
        writer.popIndent();
        writer.println("} catch (Throwable t) {");
        writer.pushIndent();
        writer.println("if (t instanceof JspException)");
        writer.pushIndent();
        writer.println("throw (JspException)t;");
        writer.popIndent();
        writer.println("else if (t instanceof IOException)");
        writer.pushIndent();
        writer.println("throw (IOException)t;");
        writer.popIndent();
        writer.println("else");
        writer.pushIndent();
        writer.println("throw new JspException(t);");
        writer.popIndent();
        writer.popIndent();
        writer.println("} finally {");
        writer.pushIndent();
        writer.println("if (writer != null) getJspContext().popBody();");
        writer.popIndent();
        writer.println("}");
        writer.popIndent();
        writer.println("}");
        writer.popIndent();
        writer.println("}");
        return true;
    }
}

