/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;

final class HtmlScriptParser
extends Parser {
    private static final String SCRIPT_START = "<script ";
    private static final String SCRIPT_END = "</script>";

    HtmlScriptParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        Mark start = null;
        Mark stop = null;
        if (reader.matchesIgnoreCase(SCRIPT_START)) {
            start = reader.mark();
            reader.advance(SCRIPT_START.length());
            stop = reader.mark();
            parser.flushCharData();
            char[] data = reader.getChars(start, stop);
            codeGen.handleCharData(data);
            parser.setInHtmlScript(true);
            return true;
        }
        if (reader.matchesIgnoreCase(SCRIPT_END)) {
            start = reader.mark();
            reader.advance(SCRIPT_END.length());
            stop = reader.mark();
            parser.flushCharData();
            char[] data = reader.getChars(start, stop);
            codeGen.handleCharData(data);
            parser.setInHtmlScript(false);
            return true;
        }
        return false;
    }
}

