/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.jsp.compiler.JavaCompiler;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JavacJavaCompiler
extends JavaCompiler {
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String fs = System.getProperty("file.separator");

    public JavacJavaCompiler(String classPath, String encoding, String outDir, String opt, String source) {
        super(classPath, encoding, outDir, opt, source);
    }

    public void compile() throws JspCompileException {
        int j;
        Process java_compiler = null;
        String[] argv = null;
        String jrePath = System.getProperty(PROP_JAVA_HOME);
        String command = jrePath.substring(0, jrePath.lastIndexOf(fs)) + fs + "bin" + fs + "javac";
        int i = 0;
        if (this.encoding != null) {
            argv = new String[8 + this.option.length];
            argv[i++] = command;
            if (this.option.length > 0) {
                for (j = 0; j < this.option.length; ++j) {
                    argv[i++] = this.option[j];
                }
            }
            argv[i++] = "-encoding";
            argv[i++] = this.encoding;
            argv[i++] = "-classpath";
            argv[i++] = this.classPath;
            argv[i++] = "-d";
            argv[i++] = this.outDir;
            argv[i++] = this.source;
        } else {
            argv = new String[6 + this.option.length];
            argv[i++] = command;
            if (this.option.length > 0) {
                for (j = 0; j < this.option.length; ++j) {
                    argv[i++] = this.option[j];
                }
            }
            argv[i++] = "-classpath";
            argv[i++] = this.classPath;
            argv[i++] = "-d";
            argv[i++] = this.outDir;
            argv[i++] = this.source;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int j2 = 0; j2 < argv.length; ++j2) {
            sbuf.append(" " + argv[j2] + " ");
        }
        if (logger.isLoggable(JeusMessage_WebContainer5._5301_LEVEL)) {
            logger.log(JeusMessage_WebContainer5._5301_LEVEL, JeusMessage_WebContainer5._5301, (Object[])new String[]{"javac :", sbuf.toString()});
        }
        this.checkOutputDirectory();
        RequestProcessor worker = null;
        try {
            worker = (RequestProcessor)Thread.currentThread();
        }
        catch (ClassCastException cce) {
            worker = null;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            java_compiler = runtime.exec(argv);
        }
        catch (IOException ioe) {
            throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5585), ioe);
        }
        int err = 0;
        int avail = 0;
        BufferedInputStream outStream = new BufferedInputStream(java_compiler.getInputStream(), 4096);
        BufferedInputStream errStream = new BufferedInputStream(java_compiler.getErrorStream(), 4096);
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int exitVal = 0;
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                exitVal = java_compiler.exitValue();
                if (exitVal == 0) {
                    this.errorMessage = "";
                    return;
                }
                try {
                    while ((avail = outStream.available()) > 0) {
                        buffer = new byte[avail];
                        err = outStream.read(buffer, 0, avail);
                        byteOutStream.write(buffer, 0, err);
                    }
                    while ((avail = errStream.available()) > 0) {
                        buffer = new byte[avail];
                        err = errStream.read(buffer, 0, avail);
                        byteOutStream.write(buffer, 0, err);
                    }
                }
                catch (IOException exIO) {
                    // empty catch block
                }
                this.errorMessage = " " + byteOutStream.toString();
                throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5586, (Object[])new String[]{this.source, this.errorMessage}));
            }
            catch (IllegalThreadStateException ex) {
                try {
                    while ((avail = outStream.available()) > 0) {
                        buffer = new byte[avail];
                        err = outStream.read(buffer, 0, avail);
                        byteOutStream.write(buffer, 0, err);
                    }
                    while ((avail = errStream.available()) > 0) {
                        buffer = new byte[avail];
                        err = errStream.read(buffer, 0, avail);
                        byteOutStream.write(buffer, 0, err);
                    }
                    if (worker == null || worker.isRunning()) continue;
                    java_compiler.destroy();
                    this.errorMessage = "compilation time is too long. process killed." + byteOutStream.toString();
                    throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5586, (Object[])new String[]{this.source, this.errorMessage}));
                }
                catch (IOException exIO) {
                    continue;
                }
            }
            break;
        }
    }
}

