/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagFileInfo;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.JspProperty;
import jeus.servlet.jsp.compiler.BeanParser;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.CommentParser;
import jeus.servlet.jsp.compiler.CustomTagParser;
import jeus.servlet.jsp.compiler.DeclarationParser;
import jeus.servlet.jsp.compiler.DoBodyParser;
import jeus.servlet.jsp.compiler.ElementParser;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.ExpressionParser;
import jeus.servlet.jsp.compiler.FallbackParser;
import jeus.servlet.jsp.compiler.ForwardParser;
import jeus.servlet.jsp.compiler.GetPropertyParser;
import jeus.servlet.jsp.compiler.IncludeDirectiveParser;
import jeus.servlet.jsp.compiler.IncludeParser;
import jeus.servlet.jsp.compiler.InvokeParser;
import jeus.servlet.jsp.compiler.JspCodeGenerator;
import jeus.servlet.jsp.compiler.JspDocumentStartParser;
import jeus.servlet.jsp.compiler.JspOutputParser;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspRootParser;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.JspparamsParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.PageDirectiveParser;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.PluginParser;
import jeus.servlet.jsp.compiler.QuoteEscapeParser;
import jeus.servlet.jsp.compiler.ScriptletParser;
import jeus.servlet.jsp.compiler.SetPropertyParser;
import jeus.servlet.jsp.compiler.TagFileAttributeDirectiveParser;
import jeus.servlet.jsp.compiler.TagFileCodeGenerator;
import jeus.servlet.jsp.compiler.TagFileTagDirectiveParser;
import jeus.servlet.jsp.compiler.TagFileVariableDirectiveParser;
import jeus.servlet.jsp.compiler.TaglibDirectiveParser;
import jeus.servlet.jsp.compiler.TextParser;
import jeus.servlet.jsp.compiler.XmlAttributeDirectiveParser;
import jeus.servlet.jsp.compiler.XmlCdataParser;
import jeus.servlet.jsp.compiler.XmlIncludeDirectiveParser;
import jeus.servlet.jsp.compiler.XmlPageDirectiveParser;
import jeus.servlet.jsp.compiler.XmlRootEndParser;
import jeus.servlet.jsp.compiler.XmlTagDirectiveParser;
import jeus.servlet.jsp.compiler.XmlVariableDirectiveParser;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.xml.binding.j2ee.PathType;

public class JspParser {
    private static final Vector parsers = new Vector();
    private static final Vector parsers_invalidScriptlet = new Vector();
    private static final Vector xmlParsers = new Vector();
    private static final Vector xmlParsers_invalidScriptlet = new Vector();
    private static final Parser jspDocumentStartParser = new JspDocumentStartParser();
    private Vector currentParser;
    private static final Vector tagFileParsers = new Vector();
    private static final Vector tagFileParsers_invalidScriptlet = new Vector();
    private static final Vector xmlTagFileParsers = new Vector();
    private static final Vector xmlTagFileParsers_invalidScriptlet = new Vector();
    private JspProperty jspProperty;
    public boolean jspRootExist;
    public boolean isJspDocument = false;
    private String _addXmlDeclaration = null;
    private TagFileInfo tagFileInfo = null;
    public boolean isXml = false;
    private boolean tagFile;
    private JspReader reader;
    private CodeGenerator codeGen;
    CharArrayWriter caw;
    JspXmlViewer xmlViewer;
    private boolean inHtmlScript = false;
    private boolean WebApp_2_3;
    private boolean resolveEncodingPhase;

    public JspParser(JspReader reader, CodeGenerator gen, boolean resolveEncoding) {
        this(reader, gen, resolveEncoding, false);
    }

    public JspParser(JspReader reader, CodeGenerator gen, boolean resolveEncoding, boolean tagFile) {
        this.reader = reader;
        this.codeGen = gen;
        this.codeGen.setJspParser(this);
        this.caw = new CharArrayWriter();
        this.xmlViewer = new JspXmlViewer(this.codeGen.getJspURI());
        this.tagFile = tagFile;
        this.resolveEncodingPhase = resolveEncoding;
        if (this.codeGen instanceof JspCodeGenerator) {
            this.jspProperty = ((JspCodeGenerator)this.codeGen).getCtxt().getReloader().getJspProperty();
        }
        if (this.codeGen instanceof TagFileCodeGenerator) {
            this.tagFileInfo = ((TagFileCodeGenerator)this.codeGen).getTagFileClassHandler().getTagFileInfo();
        }
    }

    public boolean isTagFile() {
        return this.tagFile;
    }

    void flushCharData(boolean eof) throws JspEngineException {
        char[] array = this.caw.toCharArray();
        if (array.length != 0) {
            char[] array2 = null;
            if (WebProperties.J2EE_COMPATIBLE.value && eof) {
                int pos = array.length - 1;
                int i = 0;
                for (i = pos; i >= 0 && Character.isWhitespace(array[i]); --i) {
                }
                if (i < 0) {
                    array2 = null;
                } else if (i < pos) {
                    array2 = new char[i + 1];
                    System.arraycopy(array, 0, array2, 0, i + 1);
                } else {
                    array2 = array;
                }
            } else {
                array2 = array;
            }
            if (array2 != null) {
                this.codeGen.handleCharData(array2);
            }
        }
        this.caw = new CharArrayWriter();
    }

    void flushCharData() throws JspEngineException {
        this.flushCharData(false);
    }

    void flushCharData(Stack outStack) throws JspEngineException {
        char[] array = this.caw.toCharArray();
        if (array.length != 0) {
            this.codeGen.handleCharData(this.caw.toCharArray(), outStack);
        }
        this.caw = new CharArrayWriter();
    }

    void flushCharData(Mark start, Mark stop) throws JspEngineException {
        char[] array = this.caw.toCharArray();
        if (array.length != 0) {
            this.codeGen.handleCharData(start, stop, this.caw.toCharArray());
        }
        this.caw = new CharArrayWriter();
    }

    void setInHtmlScript(boolean value) {
        this.inHtmlScript = value;
    }

    boolean isInHtmlScript() {
        return this.inHtmlScript;
    }

    private void setCurrentParser(boolean _isJspDocument) {
        if (this.jspProperty == null) {
            this.currentParser = this.tagFile ? (_isJspDocument ? xmlTagFileParsers : tagFileParsers) : (_isJspDocument ? xmlParsers : parsers);
            return;
        }
        this.currentParser = this.jspProperty.isScriptingInvalid() ? (this.tagFile ? (_isJspDocument ? xmlTagFileParsers_invalidScriptlet : tagFileParsers_invalidScriptlet) : (_isJspDocument ? xmlParsers_invalidScriptlet : parsers_invalidScriptlet)) : (this.tagFile ? (_isJspDocument ? xmlTagFileParsers : tagFileParsers) : (_isJspDocument ? xmlParsers : parsers));
    }

    public void parse() throws JspEngineException {
        this.parse(null, null, null, null, false);
    }

    public void parseTagFile() throws JspEngineException {
        this.parse(null, null, null, null, true);
    }

    public void parse(Parser parentParser, String until, Vector accept, Vector notAccept, boolean localParsing) throws JspEngineException {
        boolean untilMatched = false;
        if (!localParsing && this.jspProperty != null) {
            this.doImplicitIncludes(this.jspProperty.getIncludePrelude());
        }
        do {
            if (this.reader.isJspDocument()) {
                this.setCurrentParser(true);
                untilMatched = this.parseJspDocument(parentParser, until, accept, notAccept);
                continue;
            }
            this.setCurrentParser(false);
            untilMatched = this.parseJspPage(parentParser, until, accept, notAccept);
        } while (!untilMatched && this.reader.popFile());
        if (!localParsing && this.jspProperty != null) {
            while (this.reader.popFile()) {
            }
            if (this.doImplicitIncludes(this.jspProperty.getIncludeCoda())) {
                do {
                    if (this.reader.isJspDocument()) {
                        this.setCurrentParser(true);
                        this.parseJspDocument(parentParser, until, accept, notAccept);
                        continue;
                    }
                    this.setCurrentParser(false);
                    this.parseJspPage(parentParser, until, accept, notAccept);
                } while (this.reader.popFile());
            }
        }
        if (!this.resolveEncodingPhase && !localParsing) {
            this.xmlViewer.validate();
        }
    }

    public boolean isJspDocument() throws JspEngineException {
        boolean tagx;
        String path;
        if (this.jspProperty != null) {
            this.isJspDocument = true;
            if (this.jspProperty.isXml()) {
                this.isXml = true;
            }
        } else {
            path = this.tagFileInfo.getPath();
            boolean bl = tagx = path != null && path.endsWith(".tagx");
            if (tagx) {
                this.isXml = true;
            }
        }
        this.jspRootExist = jspDocumentStartParser.accept(this.codeGen, this.reader, this, null, null);
        if (this.jspProperty != null) {
            this.isJspDocument = true;
            if (this.jspProperty.isXml()) {
                return this.isJspDocument;
            }
        } else {
            path = this.tagFileInfo.getPath();
            boolean bl = tagx = path != null && path.endsWith(".tagx");
            if (tagx) {
                this.isJspDocument = true;
                return this.isJspDocument;
            }
        }
        this.isJspDocument = this.jspRootExist;
        return this.isJspDocument;
    }

    private boolean doImplicitIncludes(ArrayList arrayList) {
        Vector<String> includeList = new Vector<String>();
        boolean ret = false;
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                List subList = (List)arrayList.get(i);
                for (int j = subList.size() - 1; j >= 0; --j) {
                    PathType path = (PathType)subList.get(j);
                    includeList = new Vector();
                    includeList.add(path.getValue());
                    Hashtable<String, Vector<String>> attrs = new Hashtable<String, Vector<String>>();
                    attrs.put("file", includeList);
                    try {
                        this.codeGen.handleDirective("include", null, null, attrs);
                        ret = true;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    public void setXmlDeclaration(String in) {
        this._addXmlDeclaration = in;
    }

    private boolean parseJspDocument(Parser parentParser, String until, Vector accept, Vector notAccept) throws JspEngineException {
        boolean xmlEnd = false;
        while (this.reader.hasMoreInput()) {
            Parser p;
            if (until != null && this.reader.matches(until)) {
                return true;
            }
            this.setCurrentParser(this.reader.jspDocument);
            Enumeration e = this.currentParser.elements();
            if (accept != null) {
                e = accept.elements();
            }
            if (notAccept != null) {
                Enumeration e2 = notAccept.elements();
                while (e2.hasMoreElements()) {
                    p = (Parser)e2.nextElement();
                    p.accept(this.codeGen, this.reader, this, null, parentParser);
                }
            }
            boolean accepted = false;
            while (e.hasMoreElements()) {
                p = (Parser)e.nextElement();
                Mark m = this.reader.mark();
                if (!p.accept(this.codeGen, this.reader, this, null, parentParser)) continue;
                accepted = true;
                if (!(p instanceof XmlRootEndParser)) break;
                xmlEnd = true;
                break;
            }
            if (accepted) continue;
            String s = this.reader.nextContent();
            if ((s = this.trimLine(s)).length() <= 0) continue;
            this.caw.write(s, 0, s.length());
        }
        if (this._addXmlDeclaration == null) {
            this._addXmlDeclaration = this.tagFile ? "false" : (!this.jspRootExist && this.isJspDocument ? "true" : "false");
        }
        if (this._addXmlDeclaration.equals("true") && !this.codeGen.isXmlPrologGenerated()) {
            CharArrayWriter _caw = new CharArrayWriter();
            try {
                _caw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
            this.codeGen.handleCharData(_caw.toCharArray(), 0);
            this.codeGen.setXmlPrologGenerated(true);
        }
        this.flushCharData(true);
        if (!xmlEnd && this.jspRootExist && !(this.codeGen instanceof TagFileCodeGenerator)) {
            throw new JspParseException(this.reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:root>"));
        }
        return false;
    }

    private String trimLine(String s) {
        int off;
        char[] value = s.toCharArray();
        for (off = value.length - 1; off >= 0 && (value[off] == '\n' || value[off] == '\r'); --off) {
        }
        return s.substring(0, off + 1);
    }

    private boolean parseJspPage(Parser parentParser, String until, Vector accept, Vector notAccept) throws JspEngineException {
        while (this.reader.hasMoreInput()) {
            Parser p;
            if (until != null && this.reader.matches(until)) {
                return true;
            }
            this.setCurrentParser(this.reader.jspDocument);
            Enumeration e = this.currentParser.elements();
            if (accept != null) {
                e = accept.elements();
            }
            if (notAccept != null) {
                Enumeration e2 = notAccept.elements();
                while (e2.hasMoreElements()) {
                    p = (Parser)e2.nextElement();
                    p.accept(this.codeGen, this.reader, this, null, parentParser);
                }
            }
            boolean accepted = false;
            while (e.hasMoreElements()) {
                p = (Parser)e.nextElement();
                Mark m = this.reader.mark();
                if (!p.accept(this.codeGen, this.reader, this, this.xmlViewer, parentParser)) continue;
                accepted = true;
                this.xmlViewer.textEnd();
                break;
            }
            if (accepted) continue;
            String s = this.reader.nextContent();
            s = this.removeELEscape(s);
            this.xmlViewer.appendText(s);
            this.caw.write(s, 0, s.length());
        }
        this.flushCharData(true);
        return false;
    }

    private String removeELEscape(String s) {
        StringBuffer sb = new StringBuffer(s);
        int index = 0;
        while ((index = sb.indexOf("\\$", index)) >= 0) {
            sb.replace(index, index + 2, "$");
        }
        return sb.toString();
    }

    public static void checkAttributes(String typeOfTag, Enumeration enum_, String[] validAttributes) throws JspEngineException {
        String attribute = null;
        while (enum_.hasMoreElements()) {
            boolean valid = false;
            attribute = (String)enum_.nextElement();
            for (int i = 0; i < validAttributes.length; ++i) {
                if (!attribute.equalsIgnoreCase(validAttributes[i])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5587, (Object[])new String[]{typeOfTag, attribute}));
        }
    }

    public void setWebApp_2_3(boolean b) {
        this.WebApp_2_3 = b;
    }

    public boolean isWebApp_2_3() {
        return this.WebApp_2_3;
    }

    public JspProperty getJspProperty() {
        return this.jspProperty;
    }

    public CodeGenerator getCodeGen() {
        return this.codeGen;
    }

    static {
        parsers.addElement(new JspRootParser(true));
        parsers.addElement(new FallbackParser(true));
        parsers.addElement(new JspparamsParser(true));
        parsers.addElement(new ParamParser(true));
        parsers.addElement(new ExpressionEvaluatorParser());
        parsers.addElement(new ElementParser());
        parsers.addElement(new JspOutputParser(true));
        parsers.addElement(new JspattributeParser(true));
        parsers.addElement(new InvokeParser());
        parsers.addElement(new JspbodyParser(true));
        parsers.addElement(new TagFileTagDirectiveParser(true));
        parsers.addElement(new TagFileAttributeDirectiveParser(true));
        parsers.addElement(new TagFileVariableDirectiveParser(true));
        parsers.addElement(new PageDirectiveParser());
        parsers.addElement(new IncludeDirectiveParser());
        parsers.addElement(new TaglibDirectiveParser());
        parsers.addElement(new IncludeParser());
        parsers.addElement(new ForwardParser());
        parsers.addElement(new CommentParser());
        parsers.addElement(new DeclarationParser());
        parsers.addElement(new ExpressionParser());
        parsers.addElement(new ScriptletParser());
        parsers.addElement(new BeanParser());
        parsers.addElement(new GetPropertyParser());
        parsers.addElement(new SetPropertyParser());
        parsers.addElement(new PluginParser());
        parsers.addElement(new TextParser());
        parsers.addElement(new QuoteEscapeParser());
        parsers.addElement(new XmlPageDirectiveParser());
        parsers.addElement(new XmlIncludeDirectiveParser());
        parsers.addElement(new CustomTagParser());
        parsers_invalidScriptlet.addElement(new JspRootParser(true));
        parsers_invalidScriptlet.addElement(new FallbackParser(true));
        parsers_invalidScriptlet.addElement(new JspparamsParser(true));
        parsers_invalidScriptlet.addElement(new ParamParser(true));
        parsers_invalidScriptlet.addElement(new ExpressionEvaluatorParser());
        parsers_invalidScriptlet.addElement(new ElementParser());
        parsers_invalidScriptlet.addElement(new JspOutputParser(true));
        parsers_invalidScriptlet.addElement(new JspattributeParser(true));
        parsers_invalidScriptlet.addElement(new JspbodyParser(true));
        parsers_invalidScriptlet.addElement(new TagFileTagDirectiveParser(true));
        parsers_invalidScriptlet.addElement(new TagFileAttributeDirectiveParser(true));
        parsers_invalidScriptlet.addElement(new TagFileVariableDirectiveParser(true));
        parsers_invalidScriptlet.addElement(new PageDirectiveParser());
        parsers_invalidScriptlet.addElement(new IncludeDirectiveParser());
        parsers_invalidScriptlet.addElement(new TaglibDirectiveParser());
        parsers_invalidScriptlet.addElement(new IncludeParser());
        parsers_invalidScriptlet.addElement(new ForwardParser());
        parsers_invalidScriptlet.addElement(new CommentParser());
        parsers_invalidScriptlet.addElement(new DeclarationParser(true));
        parsers_invalidScriptlet.addElement(new ExpressionParser(true));
        parsers_invalidScriptlet.addElement(new ScriptletParser(true));
        parsers_invalidScriptlet.addElement(new BeanParser());
        parsers_invalidScriptlet.addElement(new GetPropertyParser());
        parsers_invalidScriptlet.addElement(new SetPropertyParser());
        parsers_invalidScriptlet.addElement(new PluginParser());
        parsers_invalidScriptlet.addElement(new TextParser());
        parsers_invalidScriptlet.addElement(new QuoteEscapeParser());
        parsers_invalidScriptlet.addElement(new XmlPageDirectiveParser());
        parsers_invalidScriptlet.addElement(new XmlIncludeDirectiveParser());
        parsers_invalidScriptlet.addElement(new CustomTagParser());
        xmlParsers.addElement(new ExpressionEvaluatorParser());
        xmlParsers.addElement(new ElementParser());
        xmlParsers.addElement(new JspOutputParser());
        xmlParsers.addElement(new JspattributeParser(true));
        xmlParsers.addElement(new JspbodyParser(true));
        xmlParsers.addElement(new InvokeParser());
        xmlParsers.addElement(new XmlTagDirectiveParser(true));
        xmlParsers.addElement(new XmlPageDirectiveParser());
        xmlParsers.addElement(new XmlIncludeDirectiveParser());
        xmlParsers.addElement(new DeclarationParser());
        xmlParsers.addElement(new ScriptletParser());
        xmlParsers.addElement(new ExpressionParser());
        xmlParsers.addElement(new CommentParser());
        xmlParsers.addElement(new IncludeParser());
        xmlParsers.addElement(new ForwardParser());
        xmlParsers.addElement(new BeanParser());
        xmlParsers.addElement(new GetPropertyParser());
        xmlParsers.addElement(new SetPropertyParser());
        xmlParsers.addElement(new PluginParser());
        xmlParsers.addElement(new TextParser());
        xmlParsers.addElement(new XmlRootEndParser());
        xmlParsers.addElement(new XmlCdataParser());
        xmlParsers.addElement(new CustomTagParser());
        xmlParsers_invalidScriptlet.addElement(new ElementParser());
        xmlParsers_invalidScriptlet.addElement(new JspOutputParser());
        xmlParsers_invalidScriptlet.addElement(new JspattributeParser(true));
        xmlParsers_invalidScriptlet.addElement(new JspbodyParser(true));
        xmlParsers_invalidScriptlet.addElement(new XmlTagDirectiveParser(true));
        xmlParsers_invalidScriptlet.addElement(new XmlPageDirectiveParser());
        xmlParsers_invalidScriptlet.addElement(new XmlIncludeDirectiveParser());
        xmlParsers_invalidScriptlet.addElement(new DeclarationParser(true));
        xmlParsers_invalidScriptlet.addElement(new ScriptletParser(true));
        xmlParsers_invalidScriptlet.addElement(new ExpressionParser(true));
        xmlParsers_invalidScriptlet.addElement(new CommentParser());
        xmlParsers_invalidScriptlet.addElement(new IncludeParser());
        xmlParsers_invalidScriptlet.addElement(new ForwardParser());
        xmlParsers_invalidScriptlet.addElement(new BeanParser());
        xmlParsers_invalidScriptlet.addElement(new GetPropertyParser());
        xmlParsers_invalidScriptlet.addElement(new SetPropertyParser());
        xmlParsers_invalidScriptlet.addElement(new PluginParser());
        xmlParsers_invalidScriptlet.addElement(new TextParser());
        xmlParsers_invalidScriptlet.addElement(new XmlRootEndParser());
        xmlParsers_invalidScriptlet.addElement(new XmlCdataParser());
        xmlParsers_invalidScriptlet.addElement(new ExpressionEvaluatorParser());
        xmlParsers_invalidScriptlet.addElement(new CustomTagParser());
        tagFileParsers.addElement(new JspRootParser(true));
        tagFileParsers.addElement(new FallbackParser(true));
        tagFileParsers.addElement(new JspparamsParser(true));
        tagFileParsers.addElement(new ParamParser(true));
        tagFileParsers.addElement(new PageDirectiveParser(true));
        tagFileParsers.addElement(new ElementParser());
        tagFileParsers.addElement(new JspOutputParser(true));
        tagFileParsers.addElement(new ExpressionEvaluatorParser());
        tagFileParsers.addElement(new IncludeDirectiveParser());
        tagFileParsers.addElement(new TaglibDirectiveParser());
        tagFileParsers.addElement(new TagFileTagDirectiveParser());
        tagFileParsers.addElement(new TagFileAttributeDirectiveParser());
        tagFileParsers.addElement(new TagFileVariableDirectiveParser());
        tagFileParsers.addElement(new InvokeParser());
        tagFileParsers.addElement(new JspbodyParser());
        tagFileParsers.addElement(new DoBodyParser());
        tagFileParsers.addElement(new IncludeParser());
        tagFileParsers.addElement(new ForwardParser());
        tagFileParsers.addElement(new CommentParser());
        tagFileParsers.addElement(new DeclarationParser());
        tagFileParsers.addElement(new ExpressionParser());
        tagFileParsers.addElement(new ScriptletParser());
        tagFileParsers.addElement(new BeanParser());
        tagFileParsers.addElement(new GetPropertyParser());
        tagFileParsers.addElement(new SetPropertyParser());
        tagFileParsers.addElement(new PluginParser());
        tagFileParsers.addElement(new TextParser());
        tagFileParsers.addElement(new QuoteEscapeParser());
        tagFileParsers.addElement(new CustomTagParser());
        tagFileParsers_invalidScriptlet.addElement(new JspRootParser(true));
        tagFileParsers_invalidScriptlet.addElement(new FallbackParser(true));
        tagFileParsers_invalidScriptlet.addElement(new JspparamsParser(true));
        tagFileParsers_invalidScriptlet.addElement(new ParamParser(true));
        tagFileParsers_invalidScriptlet.addElement(new PageDirectiveParser(true));
        tagFileParsers_invalidScriptlet.addElement(new JspOutputParser(true));
        tagFileParsers_invalidScriptlet.addElement(new ExpressionEvaluatorParser());
        tagFileParsers_invalidScriptlet.addElement(new IncludeDirectiveParser());
        tagFileParsers_invalidScriptlet.addElement(new TaglibDirectiveParser());
        tagFileParsers_invalidScriptlet.addElement(new TagFileTagDirectiveParser());
        tagFileParsers_invalidScriptlet.addElement(new TagFileAttributeDirectiveParser());
        tagFileParsers_invalidScriptlet.addElement(new TagFileVariableDirectiveParser());
        tagFileParsers_invalidScriptlet.addElement(new IncludeParser());
        tagFileParsers_invalidScriptlet.addElement(new ForwardParser());
        tagFileParsers_invalidScriptlet.addElement(new CommentParser());
        tagFileParsers_invalidScriptlet.addElement(new DeclarationParser(true));
        tagFileParsers_invalidScriptlet.addElement(new ExpressionParser(true));
        tagFileParsers_invalidScriptlet.addElement(new ScriptletParser(true));
        tagFileParsers_invalidScriptlet.addElement(new BeanParser());
        tagFileParsers_invalidScriptlet.addElement(new GetPropertyParser());
        tagFileParsers_invalidScriptlet.addElement(new SetPropertyParser());
        tagFileParsers_invalidScriptlet.addElement(new PluginParser());
        tagFileParsers_invalidScriptlet.addElement(new TextParser());
        tagFileParsers_invalidScriptlet.addElement(new QuoteEscapeParser());
        tagFileParsers_invalidScriptlet.addElement(new CustomTagParser());
        xmlTagFileParsers.addElement(new XmlPageDirectiveParser(true));
        xmlTagFileParsers.addElement(new XmlTagDirectiveParser());
        xmlTagFileParsers.addElement(new XmlIncludeDirectiveParser());
        xmlTagFileParsers.addElement(new XmlAttributeDirectiveParser());
        xmlTagFileParsers.addElement(new XmlVariableDirectiveParser());
        xmlTagFileParsers.addElement(new ElementParser());
        xmlTagFileParsers.addElement(new InvokeParser());
        xmlTagFileParsers.addElement(new JspbodyParser());
        xmlTagFileParsers.addElement(new DoBodyParser());
        xmlTagFileParsers.addElement(new JspOutputParser());
        xmlTagFileParsers.addElement(new DeclarationParser());
        xmlTagFileParsers.addElement(new ScriptletParser());
        xmlTagFileParsers.addElement(new ExpressionParser());
        xmlTagFileParsers.addElement(new CommentParser());
        xmlTagFileParsers.addElement(new IncludeParser());
        xmlTagFileParsers.addElement(new ForwardParser());
        xmlTagFileParsers.addElement(new BeanParser());
        xmlTagFileParsers.addElement(new GetPropertyParser());
        xmlTagFileParsers.addElement(new SetPropertyParser());
        xmlTagFileParsers.addElement(new PluginParser());
        xmlTagFileParsers.addElement(new TextParser());
        xmlTagFileParsers.addElement(new XmlRootEndParser());
        xmlTagFileParsers.addElement(new XmlCdataParser());
        xmlTagFileParsers.addElement(new ExpressionEvaluatorParser());
        xmlTagFileParsers.addElement(new CustomTagParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlPageDirectiveParser(true));
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlTagDirectiveParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlIncludeDirectiveParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlAttributeDirectiveParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlVariableDirectiveParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new DeclarationParser(true));
        xmlTagFileParsers_invalidScriptlet.addElement(new ScriptletParser(true));
        xmlTagFileParsers_invalidScriptlet.addElement(new ExpressionParser(true));
        xmlTagFileParsers_invalidScriptlet.addElement(new JspOutputParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new CommentParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new IncludeParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new ForwardParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new BeanParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new GetPropertyParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new SetPropertyParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new PluginParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new TextParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlRootEndParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new XmlCdataParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new ExpressionEvaluatorParser());
        xmlTagFileParsers_invalidScriptlet.addElement(new CustomTagParser());
    }
}

