/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.DeclarationParser;
import jeus.servlet.jsp.compiler.ExpressionParser;
import jeus.servlet.jsp.compiler.ForwardParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.IncludeParser;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.PluginParser;
import jeus.servlet.jsp.compiler.ScriptletParser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.SetPropertyParser;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class JspattributeParser
extends Parser {
    static final String JSPATTRIBUTE_START = "<jsp:attribute";
    static final String JSPATTRIBUTE_START_END = ">";
    static final String JSPATTRIBUTE_EMPTY_END = "/>";
    static final String JSPATTRIBUTE_END = "</jsp:attribute>";
    private static final String[] validAttributes = new String[]{"name", "trim"};
    private static final Vector DISABLE_SCRIPT = new Vector();
    private static final HashMap RTEXPRLIST;

    public JspattributeParser() {
    }

    public JspattributeParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean match(JspReader reader) throws JspEngineException {
        if (!reader.matches(JSPATTRIBUTE_START)) {
            return false;
        }
        reader.advance(JSPATTRIBUTE_START.length());
        return true;
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!this.match(reader)) {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5378));
        }
        return true;
    }

    public static Attribute parse(JspXmlViewer xmlViewer, JspReader reader, JspParser parser, CodeGenerator codeGen, Parser _parentParser, JspAttributeInfo rtmap) throws JspEngineException {
        Mark m = reader.mark();
        reader.skipSpaces();
        if (!reader.matches(JSPATTRIBUTE_START)) {
            reader.reset(m);
            return null;
        }
        Mark start = reader.mark();
        reader.advance(JSPATTRIBUTE_START.length());
        reader.skipSpaces();
        boolean trim = true;
        Hashtable attrs = reader.parseTagAttributes();
        JspParser.checkAttributes("jsp:attribute", attrs.keys(), validAttributes);
        String name = (String)attrs.get("name");
        if (name == null) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5379));
        }
        String v = (String)attrs.get("trim");
        if (v != null && v.equalsIgnoreCase("false")) {
            trim = false;
        }
        if (reader.matches(JSPATTRIBUTE_EMPTY_END)) {
            reader.advance(JSPATTRIBUTE_EMPTY_END.length());
            return new StringAttribute(name, "", codeGen.getJspAttributeVariable(), trim, rtmap.isJspFragment(name), false);
        }
        reader.skipSpaces();
        if (!reader.matches(JSPATTRIBUTE_START_END)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)JSPATTRIBUTE_START));
        }
        reader.advance(JSPATTRIBUTE_START_END.length());
        boolean rtattr = rtmap.isRTExprAttribute(name);
        boolean enableScript = rtmap.isEnableScript(name);
        boolean jspFragment = rtmap.isJspFragment(name);
        JspAttribute attr = new JspAttribute(name, codeGen.getJspAttributeVariable(), trim, jspFragment, codeGen);
        Generator gen = attr.getGenerator();
        codeGen.pushParentGeneratorStack(gen);
        parser.parse(null, JSPATTRIBUTE_END, null, enableScript ? null : DISABLE_SCRIPT, true);
        parser.flushCharData();
        codeGen.popParentGeneratorStack();
        if (!reader.matches(JSPATTRIBUTE_END)) {
            throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:attribute>"));
        }
        reader.advance(JSPATTRIBUTE_END.length());
        StringBuffer sbuf = JspattributeParser.checkJspAttribute(gen);
        if (sbuf != null) {
            gen.setObsolete();
            return new StringAttribute(name, sbuf.toString(), codeGen.getJspAttributeVariable(), trim, jspFragment, rtattr);
        }
        attr.trim();
        return attr;
    }

    private static StringBuffer checkJspAttribute(Generator attrGen) {
        if (attrGen instanceof JspAttributeGenerator) {
            Vector children = attrGen.children;
            Enumeration enum1 = children.elements();
            StringBuffer sbuf = new StringBuffer();
            while (enum1.hasMoreElements()) {
                Generator gen = (Generator)enum1.nextElement();
                if (gen instanceof CharDataGenerator) {
                    ((CharDataGenerator)gen).generate(sbuf);
                    continue;
                }
                if (gen instanceof VariableCharDataGenerator) {
                    ((VariableCharDataGenerator)gen).generate(sbuf);
                    continue;
                }
                return null;
            }
            return sbuf;
        }
        return null;
    }

    static {
        DISABLE_SCRIPT.add(new DeclarationParser(true));
        DISABLE_SCRIPT.add(new ExpressionParser(true));
        DISABLE_SCRIPT.add(new ScriptletParser(true));
        RTEXPRLIST = new HashMap();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("value", new Boolean(true));
        RTEXPRLIST.put(SetPropertyParser.class, map);
        map = new HashMap();
        map.put("page", new Boolean(true));
        RTEXPRLIST.put(IncludeParser.class, map);
        map = new HashMap();
        map.put("page", new Boolean(true));
        RTEXPRLIST.put(ForwardParser.class, map);
        map = new HashMap();
        map.put("height", new Boolean(true));
        map.put("width", new Boolean(true));
        RTEXPRLIST.put(PluginParser.class, map);
    }

    public static class JspAttributeGenerator
    extends Generator {
        private JspAttribute attribute;

        public JspAttributeGenerator(JspAttribute attribute) {
            this.attribute = attribute;
        }

        public boolean generate(ServletWriter out, String phase) throws JspEngineException {
            out.println("// evaluate value of '" + this.attribute.attributeName + "' START");
            out.println("out = pageContext.pushBody();");
            for (int i = 0; i < this.children.size(); ++i) {
                ((Generator)this.children.get(i)).generateCode(out, "ServiceMethodPhase");
            }
            out.println("String " + this.attribute.variableName + " = ((javax.servlet.jsp.tagext.BodyContent)out).getString();");
            out.println("out = pageContext.popBody();");
            out.println("// evaluate value of '" + this.attribute.attributeName + "' END");
            return true;
        }
    }

    public static interface JspAttributeInfo {
        public boolean isRTExprAttribute(String var1);

        public boolean isEnableScript(String var1);

        public boolean isJspFragment(String var1);
    }
}

