/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class JspbodyParser
extends Parser {
    static final String JSPBODY_START = "<jsp:body>";
    static final String JSPBODY_END = "</jsp:body>";
    static final String JSPBODY_ONLY = "<jsp:body/>";

    public JspbodyParser() {
    }

    public JspbodyParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean matchJspBodyStart(JspReader reader) {
        Mark jspbodyStart = reader.mark();
        reader.skipSpaces();
        if (reader.matches(JSPBODY_START)) {
            reader.advance(JSPBODY_START.length());
            return true;
        }
        reader.reset(jspbodyStart);
        return false;
    }

    public boolean matchEmptyJspBody(JspReader reader) {
        Mark jspbodyStart = reader.mark();
        reader.skipSpaces();
        if (reader.matches(JSPBODY_ONLY)) {
            reader.advance(JSPBODY_ONLY.length());
            return true;
        }
        reader.reset(jspbodyStart);
        return false;
    }

    public boolean match(JspReader reader) {
        Mark jspbodyStart = reader.mark();
        reader.skipSpaces();
        if (!reader.matches(JSPBODY_START) && !reader.matches(JSPBODY_ONLY)) {
            reader.reset(jspbodyStart);
            return false;
        }
        if (reader.matches(JSPBODY_START)) {
            reader.advance(JSPBODY_START.length());
        }
        return true;
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!this.match(reader)) {
            return false;
        }
        if (this.isInvalidated && !codeGen.getExistRoot()) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)JSPBODY_START));
        }
        return true;
    }

    public static void parse(Parser parentParser, JspXmlViewer xmlViewer, JspReader reader, JspParser parser, CodeGenerator codeGen, Generator parentGen, String enclosingTagName, Vector parserSet, Vector notAcceptSet, boolean jspAttributeExist) throws JspEngineException {
        Mark tagStart = reader.mark();
        reader.skipSpaces();
        Mark jspBodyStart = reader.mark();
        String enclosingStartTag = "<" + enclosingTagName + ">";
        String enclosingEndTag = "</" + enclosingTagName + ">";
        if (reader.matches(JSPBODY_ONLY)) {
            reader.advance(JSPBODY_ONLY.length());
            if (reader.skipUntil(enclosingEndTag) == null) {
                throw new JspParseException(tagStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)enclosingStartTag));
            }
            parser.flushCharData();
            return;
        }
        String until = null;
        if (reader.matches(JSPBODY_START)) {
            reader.advance(JSPBODY_START.length());
            until = JSPBODY_END;
        } else {
            until = enclosingEndTag;
            if (jspAttributeExist) {
                if (reader.matches(until)) {
                    reader.advance(until.length());
                } else if (reader.skipUntil(until) == null) {
                    throw new JspParseException(tagStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)until));
                }
                parser.flushCharData();
                return;
            }
            reader.reset(tagStart);
        }
        Mark m = reader.mark();
        if (until.equals(JSPBODY_END) && reader.skipUntil(JSPBODY_END) == null) {
            throw new JspParseException(jspBodyStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)JSPBODY_START));
        }
        reader.reset(m);
        codeGen.pushParentGeneratorStack(parentGen);
        parser.parse(parentParser, until, parserSet, notAcceptSet, true);
        parser.flushCharData();
        codeGen.popParentGeneratorStack();
        reader.skipSpaces();
        if (until.equals(JSPBODY_END)) {
            if (!reader.matches(JSPBODY_END)) {
                throw new JspParseException(tagStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)JSPBODY_START));
            }
            reader.advance(JSPBODY_END.length());
            if (reader.skipUntil(enclosingEndTag) == null) {
                throw new JspParseException(tagStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)enclosingStartTag));
            }
        } else {
            if (!reader.matches(enclosingEndTag)) {
                throw new JspParseException(tagStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)enclosingStartTag));
            }
            reader.advance(enclosingEndTag.length());
        }
        parentGen.stop = reader.mark();
    }
}

