/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ParamParser;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.PluginParser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class JspparamsParser
extends Parser {
    static final String JSPPARAMS_START = "<jsp:params>";
    private static final String JSPPARAMS_END = "</jsp:params>";
    private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
    private static final String CLOSE_INDIVIDUAL_PARAM = "/>";

    public JspparamsParser() {
    }

    public JspparamsParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public static boolean match(JspReader reader) throws JspEngineException {
        if (!reader.matches(JSPPARAMS_START)) {
            return false;
        }
        reader.advance(JSPPARAMS_START.length());
        return true;
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!JspparamsParser.match(reader)) {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)JSPPARAMS_START));
        }
        this.process(xmlViewer, reader, parser, codeGen, parentParser);
        return true;
    }

    private void process(JspXmlViewer xmlViewer, JspReader reader, JspParser parser, CodeGenerator codeGen, Parser _parentParser) throws JspEngineException {
        reader.skipSpaces();
        Mark jspparamsStart = reader.mark();
        Mark jspparamsStop = reader.skipUntil(JSPPARAMS_END);
        if (jspparamsStop == null) {
            throw new JspParseException(jspparamsStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)JSPPARAMS_START));
        }
        reader.reset(jspparamsStart);
        reader.skipSpaces();
        parser.flushCharData();
        if (_parentParser instanceof PluginParser) {
            JspparamsGenerator gen = new JspparamsGenerator();
            if (!reader.matches(OPEN_INDIVIDUAL_PARAM) && !reader.matches("<jsp:body>")) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5307));
            }
            JspbodyParser.parse(this, xmlViewer, reader, parser, codeGen, gen, "jsp:params", ParamParser.ACCEPT_JSPPARAM, null, false);
            reader.skipSpaces();
            parser.flushCharData();
            codeGen.addGenerator(gen, "ServiceMethodPhase");
        }
    }

    class JspparamsGenerator
    extends Generator {
        public boolean generate(ServletWriter out, String phase) throws JspEngineException {
            if (this.hasChildren()) {
                Enumeration enum1 = this.children.elements();
                while (enum1.hasMoreElements()) {
                    Generator gen = (Generator)enum1.nextElement();
                    if (gen instanceof ParamParser.ParamGenerator) {
                        gen.generate(out, phase);
                        continue;
                    }
                    if (gen instanceof VariableCharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    if (gen instanceof CharDataGenerator) {
                        gen.setObsolete();
                        continue;
                    }
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5573));
                }
                return true;
            }
            return false;
        }
    }
}

