/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.ForwardParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.IncludeParser;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.JspparamsParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class ParamParser
extends Parser {
    static final String PARAM_START = "<jsp:param";
    private static final String PARAM_START_END = ">";
    private static final String PARAM_END = "</jsp:param>";
    private static final String PARAM_END_SELF = "/>";
    public static final Vector ACCEPT_JSPPARAM = new Vector();

    public ParamParser() {
    }

    public ParamParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public static boolean match(JspReader reader) {
        if (reader.matches(PARAM_START) && !reader.matches("<jsp:params>")) {
            reader.advance(PARAM_START.length());
            return true;
        }
        return false;
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!ParamParser.match(reader)) {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"<jsp:param>"));
        }
        this.process(xmlViewer, reader, parser, codeGen, parentParser);
        return true;
    }

    private void process(JspXmlViewer xmlViewer, JspReader reader, JspParser parser, CodeGenerator codeGen, Parser _parentParser) throws JspEngineException {
        reader.skipSpaces();
        Mark fallBackStart = reader.mark();
        String[] result = new String[2];
        reader.reset(fallBackStart);
        reader.skipSpaces();
        if (_parentParser instanceof JspparamsParser || _parentParser instanceof IncludeParser || _parentParser instanceof ForwardParser) {
            Attribute attr;
            Hashtable attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            boolean bodyExist = false;
            if (reader.matches(PARAM_END_SELF)) {
                reader.advance(PARAM_END_SELF.length());
                bodyExist = false;
            } else if (reader.matches(PARAM_START_END)) {
                reader.advance(PARAM_START_END.length());
                bodyExist = true;
            }
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            JspParamJspAttributeInfo rtmap = new JspParamJspAttributeInfo();
            if (name == null) {
                if (!bodyExist) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5593));
                }
                reader.skipSpaces();
                attr = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap);
                if (attr != null) {
                    name = ((StringAttribute)attr).getAttributeValue();
                }
                if (name == null) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5593));
                }
            }
            if (value == null) {
                if (!bodyExist) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5594));
                }
                reader.skipSpaces();
                attr = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap);
                if (attr != null) {
                    value = ((StringAttribute)attr).getAttributeValue();
                }
                if (value == null) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5594));
                }
            }
            if (WebProperties.J2EE_COMPATIBLE.value && ExpressionEvaluatorParser.checkEL(name, codeGen.isELIgnored)) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5400));
            }
            if (WebProperties.J2EE_COMPATIBLE.value && JspUtil.isExpression(name, reader.isJspDocument())) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5401));
            }
            result[0] = name;
            result[1] = value;
            reader.skipSpaces();
            parser.flushCharData();
            if (bodyExist) {
                if (reader.matches(PARAM_END)) {
                    reader.advance(PARAM_END.length());
                    codeGen.addGenerator(new ParamGenerator(result[0], result[1], xmlViewer == null, codeGen.isELIgnored), "ServiceMethodPhase");
                    return;
                }
            } else {
                codeGen.addGenerator(new ParamGenerator(result[0], result[1], xmlViewer == null, codeGen.isELIgnored), "ServiceMethodPhase");
                return;
            }
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:param>"));
        }
        throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5679));
    }

    static {
        ACCEPT_JSPPARAM.add(new ParamParser());
    }

    class ParamGenerator
    extends Generator {
        private String name;
        private String value;
        boolean isJspDocument = false;
        private String elIgnore;

        ParamGenerator(String name, String value, boolean isJspDocument, String elIgnore) {
            this.name = name;
            this.value = value;
            this.isJspDocument = isJspDocument;
            this.elIgnore = elIgnore;
        }

        public boolean generate(ServletWriter out, String phase) throws JspEngineException {
            if (this.parent instanceof IncludeParser.IncludeGenerator) {
                return this.generateInclude(out, phase);
            }
            if (this.parent instanceof ForwardParser.ForwardGenerator) {
                return this.generateForward(out, phase);
            }
            if (this.parent instanceof JspparamsParser.JspparamsGenerator) {
                return this.generatePlugin(out, phase);
            }
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5679));
        }

        private boolean generateInclude(ServletWriter out, String phase) throws JspEngineException {
            return this.generateDispatch(out, phase);
        }

        private boolean generateForward(ServletWriter out, String phase) throws JspEngineException {
            return this.generateDispatch(out, phase);
        }

        private boolean generateDispatch(ServletWriter out, String phase) throws JspEngineException {
            String key = null;
            WebProperties props = PropertyUtil.getContextProperties();
            key = JspUtil.isExpression(this.name, this.isJspDocument) ? (props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + JspUtil.getExpr(this.name, this.isJspDocument) + ")) + \"=\"" : "(" + JspUtil.getExpr(this.name, this.isJspDocument) + ") + \"=\"") : (ExpressionEvaluatorParser.checkEL(this.name, this.elIgnore) ? (props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + ExpressionEvaluatorParser.generate(this.name, null, null) + ")) + \"=\"" : "(" + ExpressionEvaluatorParser.generate(this.name, null, null) + ") + \"=\"") : (props.URL_ENCODE_JSP_PARAM.value ? "\"" + URLEncoder.encode(this.name) + "=\"" : "\"" + this.name + "=\""));
            String tmpStr = null;
            tmpStr = JspUtil.isExpression(this.value, this.isJspDocument) ? (props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + JspUtil.getExpr(this.value, this.isJspDocument) + "))" : "(" + JspUtil.getExpr(this.value, this.isJspDocument) + ")") : (ExpressionEvaluatorParser.checkEL(this.value, this.elIgnore) ? (props.URL_ENCODE_JSP_PARAM.value ? "java.net.URLEncoder.encode(\"\" + (" + ExpressionEvaluatorParser.generate(this.value, null, null) + "))" : "(" + ExpressionEvaluatorParser.generate(this.value, null, null) + ")") : (props.URL_ENCODE_JSP_PARAM.value ? "\"" + URLEncoder.encode(this.value) + "\"" : "\"" + this.value + "\""));
            out.print(" + " + key + " + " + tmpStr);
            return true;
        }

        private boolean generatePlugin(ServletWriter writer, String phase) {
            if (phase.equals("PluginGenPhase1")) {
                writer.indent();
                writer.print("out.println (\"<PARAM name=\\\"");
                if (this.name.equalsIgnoreCase("object")) {
                    writer.print("java_object");
                } else if (this.name.equalsIgnoreCase("type")) {
                    writer.print("java_type");
                } else {
                    writer.print(this.name);
                }
                writer.print("\\\"");
                writer.print(" value=\\\"");
                if (JspUtil.isExpression(this.value, this.isJspDocument)) {
                    writer.print("\"+(" + JspUtil.getExpr(this.value, this.isJspDocument) + ")+\"");
                } else if (ExpressionEvaluatorParser.checkEL(this.value, this.elIgnore)) {
                    writer.print("(" + ExpressionEvaluatorParser.generate(this.value, null, null) + ")");
                } else {
                    writer.print(this.value);
                }
                writer.print("\\\"");
                writer.print(">\");");
                writer.println();
            } else {
                if (this.name.equalsIgnoreCase("object")) {
                    writer.print("java_object");
                } else if (this.name.equalsIgnoreCase("type")) {
                    writer.print("java_type");
                } else {
                    writer.print(this.name);
                }
                writer.print("=\\\"");
                if (JspUtil.isExpression(this.value, this.isJspDocument)) {
                    writer.print("\"+(" + JspUtil.getExpr(this.value, this.isJspDocument) + ")+\"");
                } else if (ExpressionEvaluatorParser.checkEL(this.value, this.elIgnore)) {
                    writer.print("(" + ExpressionEvaluatorParser.generate(this.value, null, null) + ")");
                } else {
                    writer.print(this.value);
                }
                writer.print("\\\"");
                writer.print(" ");
            }
            return true;
        }
    }

    private class JspParamJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private JspParamJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return false;
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

