/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.IOException;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;

final class QuoteEscapeParser
extends Parser {
    private static String QUOTED_START_TAG = "<\\%";
    private static String QUOTED_END_TAG = "%\\>";
    private static String START_TAG = "<%";
    private static String END_TAG = "%>";

    QuoteEscapeParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        try {
            Mark start = reader.mark();
            if (reader.matches(QUOTED_START_TAG)) {
                reader.advance(QUOTED_START_TAG.length());
                Mark end = reader.mark();
                xmlViewer.appendText(START_TAG);
                parser.caw.write(START_TAG);
                parser.flushCharData(start, end);
                return true;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return false;
    }
}

