/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import javax.servlet.jsp.tagext.JspFragment;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.FragmentClassGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;

public class StringAttribute
extends Attribute {
    private String attributeValue;
    private boolean canBeRequestTime;

    public StringAttribute(String attr, String value, String varname, boolean trim, boolean jspFragment, boolean canBeRequestTime) {
        super(attr, varname, trim, jspFragment);
        if (trim && value != null) {
            value = value.trim();
        }
        this.attributeValue = value;
        this.canBeRequestTime = canBeRequestTime;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public String generate(ServletWriter out, CodeGenerator codeGen, boolean isJspDocument, String defaultNamespace, Class returnType, Class propEditor, String pageContextName, String parentTagName) throws JspEngineException {
        String parsedString = this.parseRuntime(this.attributeValue, codeGen, isJspDocument, defaultNamespace, returnType, propEditor);
        if (this.jspFragment) {
            String className = codeGen.getJspFragmentClassName();
            FragmentClassGenerator gen = new FragmentClassGenerator(className, parsedString);
            codeGen.addGenerator(gen, "SplittedServiceMethodPhase");
            return "new " + className + "(" + pageContextName + ", " + parentTagName + ")";
        }
        return parsedString;
    }

    private String parseRuntime(String attrValueString, CodeGenerator codeGen, boolean isJspDocument, String defaultNamespace, Class returnType, Class propEditor) throws JspEngineException {
        if (this.canBeRequestTime) {
            if (JspUtil.isExpression(attrValueString, isJspDocument)) {
                attrValueString = JspUtil.getExpr(attrValueString, isJspDocument);
            } else if (ExpressionEvaluatorParser.checkEL(attrValueString, codeGen.isELIgnored)) {
                String functionVarName = "null";
                String exp = new String(attrValueString);
                functionVarName = codeGen.findFunctionStaticNames(defaultNamespace, exp, true);
                if (returnType == JspFragment.class) {
                    returnType = String.class;
                }
                attrValueString = ExpressionEvaluatorParser.generate(attrValueString, returnType, functionVarName);
            } else {
                attrValueString = this.convertString(returnType, attrValueString, this.attributeName, propEditor);
            }
        } else {
            if (WebProperties.J2EE_COMPATIBLE.value && ExpressionEvaluatorParser.checkEL(attrValueString, codeGen.isELIgnored)) {
                throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5369));
            }
            attrValueString = this.convertString(returnType, attrValueString, this.attributeName, propEditor);
        }
        return attrValueString;
    }

    public String convertString(Class c, String s, String attrName, Class propertyEditorClass) {
        if (propertyEditorClass != null) {
            return "(" + c.getName() + ")jeus.servlet.jsp.JspMethodProxy.getValueWithPropertyEditor(" + c.getName() + ".class, \"" + attrName + "\", " + ServletWriter.quoteString(s) + ", " + propertyEditorClass.getName() + ".class)";
        }
        if (c == String.class) {
            return ServletWriter.quoteString(s);
        }
        if (c == Boolean.TYPE) {
            return Boolean.valueOf(s).toString();
        }
        if (c == Boolean.class) {
            return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
        }
        if (c == Byte.TYPE) {
            return "((byte)" + Byte.valueOf(s).toString() + ")";
        }
        if (c == Byte.class) {
            return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
        }
        if (c == Character.TYPE) {
            if (s.length() > 0) {
                char ch = s.charAt(0);
                return "((char) " + ch + ")";
            }
            throw new NumberFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5370));
        }
        if (c == Character.class) {
            if (s.length() > 0) {
                char ch = s.charAt(0);
                return "new Character((char) " + ch + ")";
            }
            throw new NumberFormatException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5370));
        }
        if (c == Double.TYPE) {
            return Double.valueOf(s).toString();
        }
        if (c == Double.class) {
            return "new Double(" + Double.valueOf(s).toString() + ")";
        }
        if (c == Float.TYPE) {
            return Float.valueOf(s).toString() + "f";
        }
        if (c == Float.class) {
            return "new Float(" + Float.valueOf(s).toString() + "f)";
        }
        if (c == Integer.TYPE) {
            return Integer.valueOf(s).toString();
        }
        if (c == Integer.class) {
            return "new Integer(" + Integer.valueOf(s).toString() + ")";
        }
        if (c == Short.TYPE) {
            return Short.valueOf(s).toString();
        }
        if (c == Short.class) {
            return "new Short((short)" + Short.valueOf(s).toString() + ")";
        }
        if (c == Long.TYPE) {
            return Long.valueOf(s).toString() + "l";
        }
        if (c == Long.class) {
            return "new Long(" + Long.valueOf(s).toString() + "l)";
        }
        if (c == Object.class) {
            return ServletWriter.quoteString(s);
        }
        return "(" + c.getName() + ")jeus.servlet.jsp.JspMethodProxy.getValueWithPropertyEditorManager(" + c.getName() + ".class, \"" + attrName + "\", " + ServletWriter.quoteString(s) + ")";
    }
}

