/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CharDataGenerator;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.servlet.jsp.compiler.XmlCdataProcessor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class TextParser
extends Parser {
    private static final String TEXT_START = "<jsp:text>";
    private static final String TEXT_END = "</jsp:text>";
    private static final String TEXT_START_2 = "<jsp:text";
    private static final String TEXT_END_2 = "/>";

    TextParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        char[] data;
        if (!reader.matches(TEXT_START)) {
            if (reader.matches(TEXT_START_2)) {
                reader.advance(TEXT_START_2.length());
                Mark _start = reader.mark();
                reader.skipSpaces();
                if (reader.matches(TEXT_END_2)) {
                    reader.advance(TEXT_END_2.length());
                    return true;
                }
                throw new JspParseException(_start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)TEXT_START));
            }
            return false;
        }
        boolean isJspDocument = xmlViewer == null;
        Mark start = null;
        Mark stop = null;
        reader.advance(TEXT_START.length());
        start = reader.mark();
        if (!isJspDocument) {
            start = reader.mark();
            stop = reader.skipUntil(TEXT_END);
            if (stop == null) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)TEXT_START));
            }
            reader.reset(start);
            this.validate(reader);
            parser.flushCharData();
            xmlViewer.addText(reader, start, stop);
            data = reader.getChars(start, stop);
        } else {
            XmlCdataProcessor xcp = new XmlCdataProcessor(reader, TEXT_START, TEXT_END);
            data = xcp.process();
            parser.flushCharData();
        }
        boolean plainText = TextParser.isPlainText(codeGen);
        boolean notIncludeQuote = false;
        String strData = new String(data);
        if (ExpressionEvaluatorParser.checkEL(strData, codeGen.isELIgnored)) {
            CharDataGenerator gen = null;
            String _changedResult = ExpressionEvaluatorParser.generate(strData, null, null);
            data = _changedResult.toCharArray();
            notIncludeQuote = true;
            gen = new CharDataGenerator(data, start, stop, notIncludeQuote, plainText);
            codeGen.addGenerator(gen, "ServiceMethodPhase");
        } else {
            notIncludeQuote = false;
            int limit = data.length;
            int ONE_WRITE_LIMIT = 4096;
            if (limit > ONE_WRITE_LIMIT) {
                int blocks = limit / ONE_WRITE_LIMIT;
                int remainder = limit % ONE_WRITE_LIMIT;
                for (int i = 0; i < blocks; ++i) {
                    VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, (i + 1) * ONE_WRITE_LIMIT, i * ONE_WRITE_LIMIT, plainText, codeGen.peekTagOutStack());
                    codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
                    codeGen.addGenerator(gen, "ServiceMethodPhase");
                }
                VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, limit, blocks * ONE_WRITE_LIMIT, plainText, codeGen.peekTagOutStack());
                codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
                codeGen.addGenerator(gen, "ServiceMethodPhase");
            } else {
                VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, limit, 0, plainText, codeGen.peekTagOutStack());
                codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
                codeGen.addGenerator(gen, "ServiceMethodPhase");
            }
        }
        return true;
    }

    private static boolean isPlainText(CodeGenerator codeGen) {
        String servletContentType = codeGen.getContentType();
        return servletContentType != null && servletContentType.indexOf("text/plain") >= 0;
    }

    private boolean validate(JspReader reader) throws JspParseException {
        block3: {
            Mark start = reader.mark();
            while (true) {
                if (reader.matches("<![CDATA[")) {
                    reader.advance("<![CDATA[".length());
                    this.checkCData(reader);
                    continue;
                }
                if (reader.matches(TEXT_END)) break block3;
                if (reader.matches("<jsp:element") || reader.matches("<% ") || reader.matches("<%!") || reader.matches("<%=")) {
                    throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5225));
                }
                int ch = reader.nextChar();
                if (ch < 0) break;
            }
            throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)TEXT_START));
        }
        reader.advance(TEXT_END.length());
        return true;
    }

    private void checkCData(JspReader reader) throws JspParseException {
        int ch;
        Mark start = reader.mark();
        do {
            if (!reader.matches("]]>")) continue;
            reader.advance("]]>".length());
            return;
        } while ((ch = reader.nextChar()) >= 0);
        throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<![CDATA["));
    }
}

