/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.VariableCharDataGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class XmlCdataParser
extends Parser {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    XmlCdataParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!reader.matches(CDATA_START)) {
            return false;
        }
        Mark start = null;
        Mark stop = null;
        reader.advance(CDATA_START.length());
        start = reader.mark();
        stop = reader.skipUntil(CDATA_END);
        if (stop == null) {
            throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
        }
        char[] data = reader.getChars(start, stop);
        parser.flushCharData();
        int ONE_WRITE_LIMIT = 4096;
        int limit = data.length;
        if (limit > ONE_WRITE_LIMIT) {
            int blocks = limit / ONE_WRITE_LIMIT;
            int remainder = limit % ONE_WRITE_LIMIT;
            for (int i = 0; i < blocks; ++i) {
                VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, (i + 1) * ONE_WRITE_LIMIT, i * ONE_WRITE_LIMIT, codeGen.peekTagOutStack());
                codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
                codeGen.addGenerator(gen, "ServiceMethodPhase");
            }
            VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, limit, blocks * ONE_WRITE_LIMIT, codeGen.peekTagOutStack());
            codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
            codeGen.addGenerator(gen, "ServiceMethodPhase");
        } else {
            VariableCharDataGenerator gen = new VariableCharDataGenerator(codeGen.getCharDataVariable(), data, start, stop, limit, 0, codeGen.peekTagOutStack());
            codeGen.addGenerator(gen, "TemplateStringDeclarationPhase");
            codeGen.addGenerator(gen, "ServiceMethodPhase");
        }
        return true;
    }
}

