/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.manager.JeusVersion;
import jeus.servlet.deployment.ConfigUtil;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.servlet.jsp.compiler.batch.BatchCompiler;
import jeus.servlet.jsp.compiler.batch.CompileFailedException;
import jeus.servlet.jsp.compiler.batch.CompileManager;
import jeus.servlet.jsp.compiler.batch.CompileTarget;
import jeus.servlet.jsp.compiler.batch.MapCompileTarget;
import jeus.servlet.jsp.compiler.batch.NormalCompileTarget;
import jeus.servlet.jsp.compiler.batch.WarCompileTarget;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;

public class BatchCompiler2 {
    private String engineName = "precompile_servlet_engine1";
    private String classpath = null;
    private String compileopt = null;
    private boolean verboseMode = false;
    private CompileManager compiler = null;
    private CompileTarget target;

    private BatchCompiler2() throws StartingException {
        if (JeusBootstrapProperties.JEUS_HOME == null) {
            throw new StartingException(2110);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() throws StartingException, Throwable {
        this.compiler = new CompileManager();
        this.compiler.initConstants(this.engineName, true, false);
        this.compiler.setConfigByXML(false);
        WebMainDescriptorJB desc = new WebMainDescriptorJB();
        ContextGroupDescriptor grpDesc = new ContextGroupDescriptor();
        ContextDescriptor ctxDesc = new ContextDescriptor();
        WebAppDescriptor webAppDesc = ConfigUtil.readWebAppDescriptor(this.target.ctxroot, false);
        Hashtable<String, Object> jspConf = new Hashtable<String, Object>();
        String ps = System.getProperty("path.separator");
        jspConf.put("CompileOutputDir", this.target.getCompileOutputDir());
        jspConf.put("JspWorkDir", this.target.getJspWorkDir());
        jspConf.put("jeus.servlet.jsp.precompile.webadmin", new Boolean(true));
        if (this.compileopt != null) {
            jspConf.put("CompileOption", this.compileopt);
        }
        String contextName = "PreCompileContext";
        try {
            desc.setSecuritySwitch(false);
            JeusLogger l = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet");
            if (this.verboseMode) {
                l.setLevel(Level.FINEST);
            } else {
                l.setLevel(Level.WARNING);
            }
            grpDesc.setGroupName("precompile");
            grpDesc.setJspConfig(jspConf);
            ctxDesc.setContextName(contextName);
            String ctxpath = null;
            grpDesc.setGroupName("PreCompileContextGroup");
            ctxpath = "/PreCompileContext";
            ctxDesc.setContextPath(ctxpath);
            ctxDesc.setDocBase(this.target.getContextRoot());
            ctxDesc.setWebAppDescriptor(webAppDesc);
            if (this.classpath != null) {
                StringTokenizer tokenizer = new StringTokenizer(this.classpath, ps);
                while (tokenizer.hasMoreElements()) {
                    String p = tokenizer.nextToken();
                    if (!p.endsWith(File.separator)) {
                        p = p + File.separator;
                    }
                    ctxDesc.addAddedClassPath(p);
                }
            }
            VirtualHostDescriptor vhostDesc = grpDesc.getDefaultVirtualHostDescriptor();
            vhostDesc.addContextDescriptor(ctxDesc);
            desc.addContextGroupDescriptor("PreCompileContextGroup", grpDesc);
        }
        catch (DescriptorException de) {
            throw new StartingException(2809, (Throwable)((Object)de));
        }
        this.compiler.setWebContainerDescriptor(desc);
        this.compiler.startContainer(true);
        File jeusTagwork = new File(this.target.getJspWorkDir() + "/jeus_tagwork");
        if (!jeusTagwork.exists()) {
            jeusTagwork.mkdirs();
        }
        try {
            this.target.batchCompiler2 = this;
            this.target.start();
            this.compiler.startCompile(this.target);
        }
        finally {
            this.target.finish();
        }
    }

    public void destroy() {
        this.compiler.getClassLoadManager().destroy();
        this.compiler = null;
        System.gc();
    }

    public void parseArgs(String[] args) throws StartingException {
        if (args.length <= 0) {
            return;
        }
        String ctxroot = null;
        String srcdir = null;
        String workdir = null;
        String outdir = null;
        String mapdir = null;
        String mode = null;
        String outwar = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-mode")) {
                if (++i == args.length) {
                    this.exit("no value specified for -mode");
                }
                if (args[i].equalsIgnoreCase("normal")) {
                    mode = "normal";
                    continue;
                }
                if (args[i].equalsIgnoreCase("war")) {
                    mode = "war";
                    continue;
                }
                if (args[i].equalsIgnoreCase("map")) {
                    mode = "map";
                    continue;
                }
                this.exit("invalid -mode value : " + args[i]);
                continue;
            }
            if (args[i].equals("-ctxroot")) {
                if (++i == args.length) {
                    this.exit("no value specified for -ctxroot");
                }
                ctxroot = args[i];
                continue;
            }
            if (args[i].equals("-q")) {
                BatchCompiler.EXIT_ON_ERROR = true;
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.verboseMode = true;
                continue;
            }
            if (args[i].equals("-srcdir")) {
                if (++i == args.length) {
                    this.exit("no value specified for -srcdir");
                }
                srcdir = args[i];
                continue;
            }
            if (args[i].equals("-mapdir")) {
                if (++i == args.length) {
                    this.exit("no value specified for -mapdir");
                }
                mapdir = args[i];
                continue;
            }
            if (args[i].equals("-workdir")) {
                if (++i == args.length) {
                    this.exit("no value specified for -workdir");
                }
                workdir = args[i];
                continue;
            }
            if (args[i].equals("-outdir")) {
                if (++i == args.length) {
                    this.exit("no value specified for -outdir");
                }
                outdir = args[i];
                continue;
            }
            if (args[i].equals("-outwar")) {
                if (++i == args.length) {
                    this.exit("no value specified for -outwar");
                }
                outwar = args[i];
                continue;
            }
            if (args[i].equals("-classpath")) {
                if (++i == args.length) {
                    this.exit("no value specified for -classpath");
                }
                this.classpath = args[i];
                continue;
            }
            if (args[i].equals("-co")) {
                if (++i == args.length) {
                    this.exit("no value specified for -co");
                }
                this.compileopt = args[i];
                this.compileopt = this.compileopt.replace(',', ' ');
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-?") || args[i].equals("-help")) {
                BatchCompiler2.printUsage();
                continue;
            }
            if (!args[i].equals("-v") && !args[i].equals("-ver") && !args[i].equals("-version")) continue;
            BatchCompiler2.printVersion();
        }
        if (ctxroot == null || ctxroot.trim().equals("")) {
            this.exit("invalid ctxroot value");
        }
        if (!new File(ctxroot).exists()) {
            this.exit("ctxroot does not exist");
        }
        if ((ctxroot = new File(ctxroot).getAbsolutePath()).endsWith("/") || ctxroot.endsWith("\\")) {
            ctxroot = ctxroot.substring(0, ctxroot.length() - 1);
        }
        srcdir = srcdir == null ? "/" : srcdir.replace('\\', '/');
        if (workdir != null) {
            workdir = new File(workdir).getAbsolutePath();
        }
        if (outdir != null) {
            outdir = new File(outdir).getAbsolutePath();
        }
        if (mode.equals("normal")) {
            this.target = new NormalCompileTarget(ctxroot, srcdir, workdir, outdir);
        } else if (mode.equals("war")) {
            this.target = new WarCompileTarget(ctxroot, outwar);
        } else if (mode.equals("map")) {
            this.target = new MapCompileTarget(ctxroot, srcdir, workdir, outdir, mapdir);
        } else {
            this.exit("unknown -mode option");
        }
        this.target.initTarget();
    }

    private void exit(String msg) {
        System.out.println();
        System.out.println(msg);
        System.out.println();
        System.exit(1);
    }

    private static void printUsage() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.out.println("jspc2 -mode {normal|war|map}");
        System.out.println("      -ctxroot {<ctxroot>|<war file path>}");
        System.out.println("      [-outwar <output war filename>]");
        System.out.println("      [-srcdir <srcdir or srcfile>] [-workdir <working directory>]");
        System.out.println("      [-outdir <output directory>] [-mapdir <directory of jeus_jspmap.xml>]");
        System.out.println("      [-q] [-co \"javac options\"] [-verbose]");
        System.out.println("      [-classpath <extra classpath>]");
        System.out.println();
        System.out.println("  * -mode normal");
        System.out.println("    > pre-compile the jsp file(s) of corresponding context");
        System.out.println("    > if -srcdir is omitted, entire jsp files within <ctxroot> will ");
        System.out.println("      be pre-compiled. <srcdir or srcfile> is relative path of <ctxroot>");
        System.out.println("      starting with '/'");
        System.out.println("    > -mapdir option is not used");
        System.out.println("    > if -workdir is omitted, <ctxroot>/WEB-INF/.warjspwork will be default");
        System.out.println("    > if -outdir is omitted, <ctxroot>/WEB-INF/.warjspwork will be default");
        System.out.println("    > -outwar option is not used");
        System.out.println();
        System.out.println("  * -mode war");
        System.out.println("    > pre-compile the jsp file(s) of corresponding war file");
        System.out.println("    > if -outwar is omitted, \"./jspcout.war\" will be a default file name");
        System.out.println("    > -srcdir option is not used");
        System.out.println("    > -mapdir option is not used");
        System.out.println("    > -workdir option is not used");
        System.out.println("    > -outdir option is not used");
        System.out.println();
        System.out.println("  * -mode map");
        System.out.println("    > pre-compile the jsp file(s) of corresponding context and");
        System.out.println("      generate servlet-mapping table (jeus_jspmap.xml)");
        System.out.println("    > if -srcdir is omitted, entire jsp files within <ctxroot> will ");
        System.out.println("      be pre-compiled. <srcdir or srcfile> is relative path of <ctxroot>");
        System.out.println("      starting with '/'");
        System.out.println("    > if -mapdir is omitted, <ctxroot>/WEB-INF will be a default map directory");
        System.out.println("    > if -workdir is omitted, <ctxroot>/WEB-INF/classes will be default");
        System.out.println("      working directory");
        System.out.println("    > if -outdir is omitted, <ctxroot>/WEB-INF/classes will be default");
        System.out.println("      output directory");
        System.out.println("    > -outwar option is not used");
        System.out.println();
        System.out.println("  * common options");
        System.out.println("    -classpath <extra classpath> : extra classpath separated");
        System.out.println("        by ';'(Windows) or ':' (Unix)");
        System.out.println("    -q  : stop compilation on compile error");
        System.out.println("    -co : extra javac compile option. space must be replaced by ','");
        System.out.println("    -verbose : verbose mode");
        System.out.println("    -h  : this message");
        System.out.println("    -v  : version information");
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.exit(0);
    }

    public static void main(String[] args) throws JeusException {
        JeusRootClassLoader.loader = BatchCompiler2.class.getClassLoader();
        JeusRootClassLoader.inServer = true;
        JeusRootClassLoader.inModuleCompiler = true;
        Thread.currentThread().setContextClassLoader(JeusRootClassLoader.loader);
        EJBRootClassLoader ejbLoader = (EJBRootClassLoader)((RootClassLoader)JeusRootClassLoader.loader).getEJBRootClassLoader();
        if (ejbLoader == null) {
            ejbLoader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, "JspBatchContainer");
            ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(ejbLoader);
            EngineContainer.rootClassLoader = ejbLoader;
        }
        BatchCompiler2 batchCompiler = null;
        if (args.length == 0 || args[0] == null) {
            BatchCompiler2.printUsage();
        }
        try {
            batchCompiler = new BatchCompiler2();
        }
        catch (StartingException se) {
            se.printStackTrace();
            System.exit(1);
        }
        try {
            batchCompiler.parseArgs(args);
        }
        catch (StartingException se) {
            se.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            batchCompiler.configure();
        }
        catch (StartingException se) {
            System.out.println(ErrorMsgManager.getLocalizedString((Throwable)((Object)se)));
            se.printStackTrace(System.out);
            Throwable rootCause = se.getCause();
            if (rootCause != null) {
                rootCause.printStackTrace(System.out);
            }
            System.exit(1);
        }
        catch (CompileFailedException ce) {
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }
}

