/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.VirtualHost;
import jeus.servlet.jsp.compiler.batch.CompileContext;
import jeus.servlet.jsp.compiler.batch.CompileFailedException;
import jeus.servlet.jsp.compiler.batch.CompileTarget;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class CompileContextGroup
extends ContextGroup {
    private boolean isWebAdmin = false;

    public CompileContextGroup(ContextGroupDescriptor desc, WebContainerManager containerManager, boolean isWebAdmin) {
        super(desc, containerManager);
        this.isWebAdmin = isWebAdmin;
    }

    public void init() throws StartingException {
        this.initJSP();
        Object threadDesc = null;
        if (this.configByXML) {
            this.readWebCommonByXML();
        } else {
            this.readWebCommonBySer();
        }
        new VirtualHost(this, this.contextGroupDesc.getDefaultVirtualHostDescriptor()).batchModeInit(this.configByXML, !this.contextGroupDesc.isDisableDefaultContext(), this.isWebAdmin);
        Enumeration vhostDescs = this.contextGroupDesc.getVirtualHostDescriptors().elements();
        while (vhostDescs.hasMoreElements()) {
            VirtualHostDescriptor vhostDesc = (VirtualHostDescriptor)vhostDescs.nextElement();
            new VirtualHost(this, vhostDesc).batchModeInit(this.configByXML, !this.contextGroupDesc.isDisableDefaultContext(), this.isWebAdmin);
        }
    }

    public void start() throws StartingException {
    }

    void preCompile() throws FileNotFoundException, ServletException {
        Hashtable successTable = new Hashtable();
        Hashtable failTable = new Hashtable();
        int totalCount = 0;
        Enumeration enum1 = this.contextNames.keys();
        while (enum1.hasMoreElements()) {
            String ctxName = (String)enum1.nextElement();
            CompileContext ctx = (CompileContext)this.contextNames.get(ctxName);
            totalCount += ctx.prepareCompile("/");
        }
        int count = 0;
        enum1 = this.contextNames.keys();
        while (enum1.hasMoreElements()) {
            Vector successList = new Vector();
            Vector failList = new Vector();
            String ctxName = (String)enum1.nextElement();
            CompileContext ctx = (CompileContext)this.contextNames.get(ctxName);
            count += ctx.preCompile(totalCount, count, successList, failList, false);
            successTable.put(ctxName, successList);
            failTable.put(ctxName, failList);
        }
        this.printResult(successTable, failTable);
    }

    void preCompile(String ctxName) {
        this.preCompile(ctxName, null);
    }

    void preCompile(String ctxName, PrintWriter writer) {
        this.preCompile(ctxName, writer, "/");
    }

    void preCompile(CompileTarget target) {
        String ctxName = target.getContextName();
        if (ctxName == null || ctxName.equals("")) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5663, (Object)ctxName));
        }
        boolean samename = target.isSameName();
        CompileContext ctx = (CompileContext)this.contextNames.get(ctxName);
        if (ctx == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5661, (Object)ctxName));
            return;
        }
        int totalCount = ctx.prepareCompile(target.getCompileRoot());
        Vector successList = new Vector();
        Vector failList = new Vector();
        ctx.preCompile(totalCount, 0, successList, failList, samename);
        target.setSuccessList(successList);
        target.setFailList(failList);
        target.setContext(ctx);
        System.out.println();
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5662));
        this.printResult(ctxName, successList, failList);
    }

    void preCompile(String ctxName, PrintWriter writer, String srcRoot) {
        CompileContext ctx;
        if (ctxName == null || ctxName.equals("")) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5663, (Object)ctxName));
        }
        boolean samename = false;
        if (writer != null) {
            samename = true;
        }
        if ((ctx = (CompileContext)this.contextNames.get(ctxName)) == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5661, (Object)ctxName));
            return;
        }
        int totalCount = ctx.prepareCompile(srcRoot);
        Vector successList = new Vector();
        Vector failList = new Vector();
        ctx.preCompile(totalCount, 0, successList, failList, samename);
        System.out.println();
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5662));
        this.printResult(ctxName, successList, failList);
        if (writer != null) {
            this.writeResult(successList, ctx.getContextPath(), writer);
        }
    }

    void preCompile(String ctxName, PrintWriter writer, File listFile) {
        CompileContext ctx;
        if (ctxName == null || ctxName.equals("")) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5663, (Object)ctxName));
        }
        boolean samename = false;
        if (writer != null) {
            samename = true;
        }
        if ((ctx = (CompileContext)this.contextNames.get(ctxName)) == null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5661, (Object)ctxName));
            return;
        }
        int totalCount = ctx.prepareCompile(listFile);
        if (totalCount < 0) {
            return;
        }
        Vector successList = new Vector();
        Vector failList = new Vector();
        ctx.preCompile(totalCount, 0, successList, failList, samename);
        System.out.println();
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5662));
        this.printResult(ctxName, successList, failList);
        if (writer != null) {
            this.writeResult(successList, ctx.getContextPath(), writer);
        }
    }

    private void writeResult(Vector successList, String contextPath, PrintWriter writer) {
        if (successList == null || successList.size() == 0) {
            return;
        }
        int len = "/jeus/tool/webadmin/jsps".length();
        Enumeration enum1 = successList.elements();
        while (enum1.hasMoreElements()) {
            String urlpattern = (String)enum1.nextElement();
            int pos = urlpattern.lastIndexOf(".jsp");
            String servletName = urlpattern.substring(1, pos);
            String className = servletName = servletName.replace('/', '.');
            urlpattern = urlpattern.substring(len);
            writer.println("        jsps.put(\"" + servletName + "\",");
            writer.println("                   new ServletDescriptor(\"" + servletName + "\", \"" + className + "\"));");
            writer.println("        jspMaps.put(\"" + servletName + "\", \"" + urlpattern + "\");");
        }
    }

    private void printResult(String ctxName, Vector successList, Vector failList) {
        String uri;
        Enumeration enum1;
        System.out.println();
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5664, (Object)ctxName));
        if (successList != null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5665));
            enum1 = successList.elements();
            while (enum1.hasMoreElements()) {
                uri = (String)enum1.nextElement();
                System.out.println("[BatchCompiler]         " + uri);
            }
        }
        if (failList != null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5666));
            enum1 = failList.elements();
            while (enum1.hasMoreElements()) {
                uri = (String)enum1.nextElement();
                System.out.println("[BatchCompiler]         " + uri);
            }
        }
        int successCount = successList == null ? 0 : successList.size();
        int failCount = failList == null ? 0 : failList.size();
        System.out.println("[BatchCompiler]   =====================================================");
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5667, (Object[])new String[]{String.valueOf(successCount + failCount), String.valueOf(successCount), String.valueOf(failCount)}));
        System.out.println("[BatchCompiler]   =====================================================");
        if (failCount > 0) {
            throw new CompileFailedException("Failed count : " + failCount);
        }
    }

    private void printResult(Hashtable successList, Hashtable failList) {
        Enumeration enum1 = successList.keys();
        while (enum1.hasMoreElements()) {
            String ctxName = (String)enum1.nextElement();
            Vector list = (Vector)successList.get(ctxName);
            Vector list2 = (Vector)failList.get(ctxName);
            this.printResult(ctxName, list, list2);
        }
    }
}

