/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.jsp.compiler.batch.NormalCompileTarget;

public class MapCompileTarget
extends NormalCompileTarget {
    private String mapdir;
    private String mapfile;
    private File jspxmlFile;
    private PrintWriter writer;

    public MapCompileTarget(String ctxroot, String srcroot, String jspworkdir, String compileoutdir, String mapdir) throws StartingException {
        super(ctxroot, srcroot, jspworkdir, compileoutdir);
        this.mapdir = mapdir;
    }

    public void initTarget() throws StartingException {
        if (this.jspworkdir == null) {
            this.jspworkdir = this.getDefaultJspWorkDir();
        }
        if (this.compileoutdir == null) {
            this.compileoutdir = this.getDefaultJspWorkDir();
        }
        if (new File(this.ctxroot).isFile()) {
            throw new StartingException("ctxroot is not a directory");
        }
        if (this.mapdir == null) {
            this.mapdir = this.getContextRoot() + File.separator + "WEB-INF";
        }
        if (this.mapdir.endsWith(File.separator)) {
            this.mapdir = this.mapdir.substring(0, this.mapdir.length() - 1);
        }
        this.mapfile = this.mapdir + File.separator + "jeus_jspmap.xml";
        this.jspxmlFile = new File(this.mapfile);
        try {
            if (!this.jspxmlFile.exists()) {
                this.jspxmlFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            throw new StartingException(2807, this.mapfile, (Throwable)ioe);
        }
        try {
            this.start();
            this.finish();
        }
        catch (IOException ioe) {
            throw new StartingException(2808, this.mapfile, (Throwable)ioe);
        }
    }

    public void start() throws IOException {
        this.writer = new PrintWriter(new FileOutputStream(this.mapfile));
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.println("<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\" version=\"2.4\">");
    }

    public void finish() throws IOException {
        if (this.successList != null && this.successList.size() > 0) {
            Enumeration enum1 = this.successList.elements();
            while (enum1.hasMoreElements()) {
                String urlpattern = (String)enum1.nextElement();
                int pos = urlpattern.lastIndexOf(".");
                String servletName = urlpattern.substring(1, pos) + "_" + urlpattern.substring(pos + 1);
                servletName = servletName.replace('/', '.');
                this.writer.println("<servlet>");
                this.writer.println("  <servlet-name>" + servletName + "</servlet-name>");
                this.writer.println("  <servlet-class>" + servletName + "</servlet-class>");
                this.writer.println("</servlet>");
                this.writer.println("<servlet-mapping>");
                this.writer.println("  <servlet-name>" + servletName + "</servlet-name>");
                this.writer.println("  <url-pattern>" + urlpattern + "</url-pattern>");
                this.writer.println("</servlet-mapping>");
            }
        }
        this.writer.println("</web-app>");
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public boolean isSameName() {
        return true;
    }

    public String getDefaultJspWorkDir() {
        return this.getContextRoot() + File.separator + "WEB-INF" + File.separator + "classes";
    }
}

