/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import jeus.servlet.jsp.el.ArithmeticOperator;
import jeus.servlet.jsp.el.EqualityOperator;
import jeus.servlet.jsp.el.ExceptionHandler;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.jsp.el.PrimitiveObjects;
import jeus.servlet.jsp.el.RelationalOperator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer6;

public class Coercions {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp.el");
    private static final Number ZERO = new Integer(0);

    public static Object coerce(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pClass == String.class) {
            return Coercions.coerceToString(pValue, pLogger);
        }
        if (Coercions.isNumberClass(pClass)) {
            return Coercions.coerceToPrimitiveNumber(pValue, pClass, pLogger);
        }
        if (pClass == Character.class || pClass == Character.TYPE) {
            return Coercions.coerceToCharacter(pValue, pLogger);
        }
        if (pClass == Boolean.class || pClass == Boolean.TYPE) {
            return Coercions.coerceToBoolean(pValue, pLogger);
        }
        return Coercions.coerceToObject(pValue, pClass, pLogger);
    }

    static boolean isNumberClass(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE || pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE || pClass == BigInteger.class || pClass == BigDecimal.class;
    }

    public static String coerceToString(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            ExceptionHandler.handle(JeusMessage_WebContainer6._6014, pValue.getClass().getName(), (Throwable)exc);
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return Coercions.coerceToPrimitiveNumber(new Short((short)val), pClass);
        }
        if (pValue instanceof Boolean) {
            ExceptionHandler.handle(JeusMessage_WebContainer6._6015, new Object[]{pValue, pClass.getName()});
            return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue.getClass() == pClass) {
            return (Number)pValue;
        }
        if (pValue instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)pValue, pClass);
            }
            catch (ELException exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6016, new Object[]{(String)pValue, pClass.getName()});
                return Coercions.coerceToPrimitiveNumber(ZERO, pClass);
            }
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6017, new Object[]{pValue.getClass().getName(), pClass.getName()});
        return Coercions.coerceToPrimitiveNumber(0L, pClass);
    }

    public static Integer coerceToInteger(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)pValue).charValue());
        }
        if (pValue instanceof Boolean) {
            if (logger.isLoggable(JeusMessage_WebContainer6._6015_LEVEL)) {
                logger.log(JeusMessage_WebContainer6._6015_LEVEL, JeusMessage_WebContainer6._6015, new Object[]{pValue, Integer.class.getName()});
            }
            return PrimitiveObjects.getInteger((Boolean)pValue != false ? 1 : 0);
        }
        if (pValue instanceof Integer) {
            return (Integer)pValue;
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)pValue).intValue());
        }
        if (pValue instanceof String) {
            try {
                return Integer.valueOf((String)pValue);
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_WebContainer6._6016_LEVEL)) {
                    logger.log(JeusMessage_WebContainer6._6016_LEVEL, JeusMessage_WebContainer6._6016, new Object[]{(String)pValue, Integer.class.getName()});
                }
                return null;
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer6._6017_LEVEL)) {
            logger.log(JeusMessage_WebContainer6._6017_LEVEL, JeusMessage_WebContainer6._6017, new Object[]{pValue.getClass().getName(), Integer.class.getName()});
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong((long)pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte(pValue.byteValue());
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort(pValue.shortValue());
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger(pValue.intValue());
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue.longValue());
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue.floatValue());
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue.doubleValue());
        }
        if (pClass == BigInteger.class) {
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).toBigInteger();
            }
            return BigInteger.valueOf(pValue.longValue());
        }
        if (pClass == BigDecimal.class) {
            if (pValue instanceof BigInteger) {
                return new BigDecimal((BigInteger)pValue);
            }
            return new BigDecimal(pValue.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return Byte.valueOf(pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return Short.valueOf(pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return Integer.valueOf(pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return Long.valueOf(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return Float.valueOf(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return Double.valueOf(pValue);
        }
        if (pClass == BigInteger.class) {
            return new BigInteger(pValue);
        }
        if (pClass == BigDecimal.class) {
            return new BigDecimal(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Character) {
            return (Character)pValue;
        }
        if (pValue instanceof Boolean) {
            ExceptionHandler.handle(JeusMessage_WebContainer6._6018, pValue);
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)pValue).shortValue());
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return PrimitiveObjects.getCharacter(str.charAt(0));
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6020, pValue.getClass().getName());
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6022, pValue, (Throwable)exc);
                return Boolean.FALSE;
            }
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6023, pValue.getClass().getName());
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pClass.isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            PropertyEditor pe = PropertyEditorManager.findEditor(pClass);
            if (pe == null) {
                if ("".equals(str)) {
                    return null;
                }
                ExceptionHandler.handle(JeusMessage_WebContainer6._6025, new Object[]{str, pClass.getName()});
                return null;
            }
            try {
                pe.setAsText(str);
                return pe.getValue();
            }
            catch (IllegalArgumentException exc) {
                if ("".equals(str)) {
                    return null;
                }
                ExceptionHandler.handle(JeusMessage_WebContainer6._6026, new Object[]{pValue, pClass.getName()}, (Throwable)exc);
                return null;
            }
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6024, new Object[]{pValue.getClass().getName(), pClass.getName()});
        return null;
    }

    public static Object applyArithmeticOperator(Object pLeft, Object pRight, ArithmeticOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (logger.isLoggable(JeusMessage_WebContainer6._6027_LEVEL)) {
                logger.log(JeusMessage_WebContainer6._6027_LEVEL, JeusMessage_WebContainer6._6027, (Object)pOperator.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
            return pOperator.apply(left, right);
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pLeft) || Coercions.isFloatingPointString(pRight)) {
            if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
                BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
                BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
                return pOperator.apply(left, right);
            }
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getDouble(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, BigInteger.class, pLogger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, BigInteger.class, pLogger);
            return pOperator.apply(left, right);
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
        return PrimitiveObjects.getLong(pOperator.apply(left, right));
    }

    public static Object applyRelationalOperator(Object pLeft, Object pRight, RelationalOperator pOperator, Logger pLogger) throws ELException {
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, BigInteger.class, pLogger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, BigInteger.class, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
            long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right));
        }
        if (pLeft instanceof Comparable) {
            try {
                int result = ((Comparable)pLeft).compareTo(pRight);
                return PrimitiveObjects.getBoolean(pOperator.apply(result, -result));
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6034, new Object[]{pLeft.getClass().getName(), pRight == null ? "null" : pRight.getClass().getName(), pOperator.getOperatorSymbol()}, (Throwable)exc);
                return Boolean.FALSE;
            }
        }
        if (pRight instanceof Comparable) {
            try {
                int result = ((Comparable)pRight).compareTo(pLeft);
                return PrimitiveObjects.getBoolean(pOperator.apply(-result, result));
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6034, new Object[]{pRight.getClass().getName(), pLeft == null ? "null" : pLeft.getClass().getName(), pOperator.getOperatorSymbol()}, (Throwable)exc);
                return Boolean.FALSE;
            }
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6028, new Object[]{pOperator.getOperatorSymbol(), pLeft.getClass().getName(), pRight.getClass().getName()});
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object pLeft, Object pRight, EqualityOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == pRight) {
            return PrimitiveObjects.getBoolean(pOperator.apply(true, pLogger));
        }
        if (pLeft == null || pRight == null) {
            return PrimitiveObjects.getBoolean(pOperator.apply(false, pLogger));
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigDecimal(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double right;
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue()), pLogger));
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, BigInteger.class, pLogger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, BigInteger.class, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long right;
            long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue()), pLogger));
        }
        if (pLeft instanceof Boolean || pRight instanceof Boolean) {
            boolean right;
            boolean left = Coercions.coerceToBoolean(pLeft, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToBoolean(pRight, pLogger).booleanValue()), pLogger));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        try {
            return PrimitiveObjects.getBoolean(pOperator.apply(pLeft.equals(pRight), pLogger));
        }
        catch (Exception exc) {
            ExceptionHandler.handle(JeusMessage_WebContainer6._6030, new Object[]{pLeft.getClass().getName(), pRight.getClass().getName(), pOperator.getOperatorSymbol()}, (Throwable)exc);
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && Coercions.isFloatingPointType(pObject.getClass());
    }

    public static boolean isFloatingPointType(Class pClass) {
        return pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch != '.' && ch != 'e' && ch != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object pObject) {
        return pObject != null && Coercions.isIntegerType(pObject.getClass());
    }

    public static boolean isIntegerType(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Character.class || pClass == Character.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE;
    }

    public static boolean isBigInteger(Object pObject) {
        return pObject != null && pObject instanceof BigInteger;
    }

    public static boolean isBigDecimal(Object pObject) {
        return pObject != null && pObject instanceof BigDecimal;
    }
}

