/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import jeus.servlet.jsp.el.Coercions;
import jeus.servlet.jsp.el.ExceptionHandler;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.jsp.el.PrimitiveObjects;
import jeus.servlet.jsp.el.UnaryOperator;
import jeus.util.message.JeusMessage_WebContainer6;

public class UnaryMinusOperator
extends UnaryOperator {
    public static final UnaryMinusOperator SINGLETON = new UnaryMinusOperator();

    public String getOperatorSymbol() {
        return "-";
    }

    public Object apply(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return PrimitiveObjects.getInteger(0);
        }
        if (pValue instanceof BigInteger) {
            return ((BigInteger)pValue).negate();
        }
        if (pValue instanceof BigDecimal) {
            return ((BigDecimal)pValue).negate();
        }
        if (pValue instanceof String) {
            if (Coercions.isFloatingPointString(pValue)) {
                double dval = Coercions.coerceToPrimitiveNumber(pValue, Double.class, pLogger).doubleValue();
                return PrimitiveObjects.getDouble(-dval);
            }
            long lval = Coercions.coerceToPrimitiveNumber(pValue, Long.class, pLogger).longValue();
            return PrimitiveObjects.getLong(-lval);
        }
        if (pValue instanceof Byte) {
            return PrimitiveObjects.getByte(-((Byte)pValue).byteValue());
        }
        if (pValue instanceof Short) {
            return PrimitiveObjects.getShort(-((Short)pValue).shortValue());
        }
        if (pValue instanceof Integer) {
            return PrimitiveObjects.getInteger(-((Integer)pValue).intValue());
        }
        if (pValue instanceof Long) {
            return PrimitiveObjects.getLong(-((Long)pValue).longValue());
        }
        if (pValue instanceof Float) {
            return PrimitiveObjects.getFloat(-((Float)pValue).floatValue());
        }
        if (pValue instanceof Double) {
            return PrimitiveObjects.getDouble(-((Double)pValue).doubleValue());
        }
        ExceptionHandler.handle(JeusMessage_WebContainer6._6031, new Object[]{this.getOperatorSymbol(), pValue.getClass().getName()});
        return PrimitiveObjects.getInteger(0);
    }
}

