/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.compiler.ErrorDispatcher;
import jeus.servlet.jsp2.compiler.JspUtil;
import jeus.servlet.jsp2.compiler.Node;
import jeus.servlet.jsp2.compiler.PageInfo;
import jeus.servlet.jsp2.compiler.tagplugin.TagPlugin;
import jeus.servlet.jsp2.compiler.tagplugin.TagPluginContext;
import jeus.servlet.jsp2.xmlparser.ParserUtils;
import jeus.servlet.jsp2.xmlparser.TreeNode;

public class TagPluginManager {
    private static final String TAG_PLUGINS_XML = "/WEB-INF/tagPlugins.xml";
    private static final String TAG_PLUGINS_ROOT_ELEM = "tag-plugins";
    private boolean initialized = false;
    private HashMap tagPlugins = null;
    private ServletContext ctxt;
    private PageInfo pageInfo;

    public TagPluginManager(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    public void apply(Node.Nodes page, ErrorDispatcher err, PageInfo pageInfo) throws Jsp2EngineException {
        this.init(err);
        if (this.tagPlugins == null || this.tagPlugins.size() == 0) {
            return;
        }
        this.pageInfo = pageInfo;
        page.visit(new Node.Visitor(){

            public void visit(Node.CustomTag n) throws Jsp2EngineException {
                TagPluginManager.this.invokePlugin(n);
                this.visitBody(n);
            }
        });
    }

    private void init(ErrorDispatcher err) throws Jsp2EngineException {
        if (this.initialized) {
            return;
        }
        InputStream is = this.ctxt.getResourceAsStream(TAG_PLUGINS_XML);
        if (is == null) {
            return;
        }
        TreeNode root = new ParserUtils().parseXMLDocument(TAG_PLUGINS_XML, is);
        if (root == null) {
            return;
        }
        if (!TAG_PLUGINS_ROOT_ELEM.equals(root.getName())) {
            err.jspError("jsp.error.plugin.wrongRootElement", TAG_PLUGINS_XML, TAG_PLUGINS_ROOT_ELEM);
        }
        this.tagPlugins = new HashMap();
        Iterator pluginList = root.findChildren("tag-plugin");
        while (pluginList.hasNext()) {
            TreeNode pluginNode = (TreeNode)pluginList.next();
            TreeNode tagClassNode = pluginNode.findChild("tag-class");
            if (tagClassNode == null) {
                return;
            }
            String tagClass = tagClassNode.getBody().trim();
            TreeNode pluginClassNode = pluginNode.findChild("plugin-class");
            if (pluginClassNode == null) {
                return;
            }
            String pluginClassStr = pluginClassNode.getBody();
            TagPlugin tagPlugin = null;
            try {
                Class<?> pluginClass = Class.forName(pluginClassStr);
                tagPlugin = (TagPlugin)pluginClass.newInstance();
            }
            catch (Exception e) {
                throw new Jsp2EngineException(e);
            }
            if (tagPlugin == null) {
                return;
            }
            this.tagPlugins.put(tagClass, tagPlugin);
        }
        this.initialized = true;
    }

    private void invokePlugin(Node.CustomTag n) {
        TagPlugin tagPlugin = (TagPlugin)this.tagPlugins.get(n.getTagHandlerClass().getName());
        if (tagPlugin == null) {
            return;
        }
        TagPluginContextImpl tagPluginContext = new TagPluginContextImpl(n, this.pageInfo);
        n.setTagPluginContext(tagPluginContext);
        tagPlugin.doTag(tagPluginContext);
    }

    static class TagPluginContextImpl
    implements TagPluginContext {
        private Node.CustomTag node;
        private Node.Nodes curNodes;
        private PageInfo pageInfo;
        private HashMap pluginAttributes;

        TagPluginContextImpl(Node.CustomTag n, PageInfo pageInfo) {
            this.node = n;
            this.pageInfo = pageInfo;
            this.curNodes = new Node.Nodes();
            n.setAtETag(this.curNodes);
            this.curNodes = new Node.Nodes();
            n.setAtSTag(this.curNodes);
            n.setUseTagPlugin(true);
            this.pluginAttributes = new HashMap();
        }

        public TagPluginContext getParentContext() {
            Node parent = this.node.getParent();
            if (!(parent instanceof Node.CustomTag)) {
                return null;
            }
            return ((Node.CustomTag)parent).getTagPluginContext();
        }

        public void setPluginAttribute(String key, Object value) {
            this.pluginAttributes.put(key, value);
        }

        public Object getPluginAttribute(String key) {
            return this.pluginAttributes.get(key);
        }

        public boolean isScriptless() {
            return this.node.getChildInfo().isScriptless();
        }

        public boolean isConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return false;
            }
            return attr.isLiteral();
        }

        public String getConstantAttribute(String attribute) {
            Node.JspAttribute attr = this.getNodeAttribute(attribute);
            if (attr == null) {
                return null;
            }
            return attr.getValue();
        }

        public boolean isAttributeSpecified(String attribute) {
            return this.getNodeAttribute(attribute) != null;
        }

        public String getTemporaryVariableName() {
            return JspUtil.nextTemporaryVariableName();
        }

        public void generateImport(String imp) {
            this.pageInfo.addImport(imp);
        }

        public void generateDeclaration(String id, String text) {
            if (this.pageInfo.isPluginDeclared(id)) {
                return;
            }
            this.curNodes.add(new Node.Declaration(text, this.node.getStart(), null));
        }

        public void generateJavaSource(String sourceCode) {
            this.curNodes.add(new Node.Scriptlet(sourceCode, this.node.getStart(), null));
        }

        public void generateAttribute(String attributeName) {
            this.curNodes.add(new Node.AttributeGenerator(this.node.getStart(), attributeName, this.node));
        }

        public void dontUseTagPlugin() {
            this.node.setUseTagPlugin(false);
        }

        public void generateBody() {
            this.curNodes = this.node.getAtETag();
        }

        private Node.JspAttribute getNodeAttribute(String attribute) {
            Node.JspAttribute[] attrs = this.node.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(attribute)) continue;
                return attrs[i];
            }
            return null;
        }
    }
}

