/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.Localizer;
import jeus.servlet.jsp2.servlet.JspCServletContext;
import jeus.servlet.jsp2.xmlparser.ParserUtils;
import jeus.servlet.jsp2.xmlparser.TreeNode;
import jeus.servlet.loader.ContextLoader;
import jeus.util.JeusRootClassLoader;

public class TldLocationsCache {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet noTldJars = new HashSet();
    private static HashSet systemJars;
    private static HashSet<String> systemUris;
    private Hashtable mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private boolean redeployMode;
    private Options options;

    public TldLocationsCache(ServletContext ctxt, Options options) {
        this(ctxt, options, true);
    }

    public TldLocationsCache(ServletContext ctxt, Options options, boolean redeployMode) {
        this.ctxt = ctxt;
        this.options = options;
        this.redeployMode = redeployMode;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public String[] getLocation(String uri) throws Jsp2EngineException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws Jsp2EngineException {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.scanJars2();
            this.processTldsInFileSystem("/WEB-INF/");
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.internal.tldinit"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebDotXml() throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctxt.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    is = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {}
            } else {
                is = this.ctxt.getResourceAsStream(WEB_XML);
            }
            if (is == null) {
                return;
            }
            TreeNode webtld = null;
            webtld = altDDName != null ? new ParserUtils().parseXMLDocument(altDDName, is) : new ParserUtils().parseXMLDocument(WEB_XML, is);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if (systemUris.contains(tagUri)) continue;
                child = taglib.findChild("taglib-location");
                if (child != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctxt.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(JarURLConnection conn, boolean ignore, boolean ignoreSystemUri) throws Jsp2EngineException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            if (this.redeployMode) {
                conn.setUseCaches(false);
            }
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                InputStream stream = jarFile.getInputStream(entry);
                try {
                    String uri = this.getUriFromTld(resourcePath, stream);
                    if (uri == null || this.mappings.get(uri) != null || ignoreSystemUri && systemUris.contains(uri)) continue;
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
                finally {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (Exception ex) {
            if (!this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (!ignore) {
                throw new Jsp2EngineException(ex);
            }
        }
        finally {
            if (this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                String uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (uri == null || systemUris.contains(uri) || this.mappings.get(uri) != null) continue;
                this.mappings.put(uri, new String[]{path, null});
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws Jsp2EngineException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in, true, this.options.isTldValidationEnabled());
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            boolean ignoreSystem;
            URL[] urls = null;
            boolean bl = ignoreSystem = loader == webappLoader;
            if (loader instanceof ContextLoader) {
                ContextLoader contextLoader = (ContextLoader)loader;
                urls = contextLoader.getURLs();
                if (contextLoader.loadWebinfFirst()) {
                    ignoreSystem = false;
                }
            } else if (loader instanceof URLClassLoader) {
                urls = ((URLClassLoader)loader).getURLs();
            }
            if (urls == null) continue;
            for (int i = 0; i < urls.length; ++i) {
                URLConnection conn = urls[i].openConnection();
                if (conn instanceof JarURLConnection) {
                    if (!this.needScanJar(ignoreSystem, ((JarURLConnection)conn).getJarFile().getName())) continue;
                    this.scanJar((JarURLConnection)conn, true, ignoreSystem);
                    continue;
                }
                String urlStr = urls[i].toString();
                if (!urlStr.startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX) || !this.needScanJar(ignoreSystem, urlStr)) continue;
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), true, ignoreSystem);
            }
        }
    }

    private void scanJars2() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!(loader instanceof ContextLoader)) {
            this.batchScanJars2(loader);
            return;
        }
        ContextLoader contextLoader = (ContextLoader)loader;
        URL[] urls = contextLoader.getURLs();
        loader = contextLoader.getParent();
        String rootClasspath = JeusRootClassLoader.getRootClassPaths(loader);
        boolean ignoreSystem = false;
        if (contextLoader.loadWebinfFirst()) {
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    this.scanJar(ignoreSystem, urls[i]);
                }
            }
            this.scanJar(ignoreSystem, rootClasspath);
        } else {
            this.scanJar(ignoreSystem, rootClasspath);
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    this.scanJar(ignoreSystem, urls[i]);
                }
            }
        }
    }

    private void batchScanJars2(ClassLoader loader) throws Exception {
        String classpath = JeusRootClassLoader.getRootClassPaths(loader);
        ArrayList<URL> urlArray = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urlArray.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        URL[] urls = new URL[urlArray.size()];
        urlArray.toArray(urls);
        JspCServletContext jspcContext = (JspCServletContext)this.ctxt;
        boolean webinfFirst = jspcContext.isWebinfFirst();
        ArrayList<URL> systemUrlList = new ArrayList<URL>();
        ArrayList<URL> contextUrlList = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i].toString().indexOf("WEB-INF") > 0) {
                contextUrlList.add(urls[i]);
                continue;
            }
            systemUrlList.add(urls[i]);
        }
        boolean ignoreSystem = false;
        if (webinfFirst) {
            for (URL url : contextUrlList) {
                this.scanJar(ignoreSystem, url);
            }
            for (URL url : systemUrlList) {
                this.scanJar(ignoreSystem, url);
            }
        } else {
            for (URL url : systemUrlList) {
                this.scanJar(ignoreSystem, url);
            }
            for (URL url : contextUrlList) {
                this.scanJar(ignoreSystem, url);
            }
        }
    }

    private void scanJar(boolean ignoreSystem, URL url) throws IOException, Jsp2EngineException, MalformedURLException {
        URLConnection conn = url.openConnection();
        if (conn instanceof JarURLConnection) {
            if (this.needScanJar(ignoreSystem, ((JarURLConnection)conn).getJarFile().getName())) {
                this.scanJar((JarURLConnection)conn, true, ignoreSystem);
            }
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX) && this.needScanJar(ignoreSystem, urlStr)) {
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), true, ignoreSystem);
            }
        }
    }

    private void scanJar(boolean ignoreSystem, String rootClasspath) throws MalformedURLException, Jsp2EngineException, IOException {
        if (rootClasspath != null) {
            String[] classpaths = rootClasspath.split(System.getProperty("path.separator"));
            for (int i = 0; i < classpaths.length; ++i) {
                String urlStr;
                if (!classpaths[i].endsWith(JAR_FILE_SUFFIX) || !(urlStr = new File(classpaths[i]).toURL().toString()).startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX) || !this.needScanJar(ignoreSystem, urlStr)) continue;
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), true, ignoreSystem);
            }
        }
    }

    private boolean needScanJar(boolean ignoreSystemJar, String jarPath) {
        String jarName = jarPath;
        int slash = jarPath.lastIndexOf(47);
        if (slash >= 0) {
            jarName = jarPath.substring(slash + 1);
        }
        if (ignoreSystemJar) {
            return !systemJars.contains(jarName);
        }
        return !noTldJars.contains(jarName);
    }

    static {
        noTldJars.add("ant.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-cluster.jar");
        noTldJars.add("catalina-optional.jar");
        noTldJars.add("catalina-i18n-fr.jar");
        noTldJars.add("catalina-i18n-ja.jar");
        noTldJars.add("catalina-i18n-es.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-modeler.jar");
        noTldJars.add("commons-logging-api.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("commons-el.jar");
        noTldJars.add("jakarta-regexp-1.2.jar");
        noTldJars.add("jasper-compiler.jar");
        noTldJars.add("jasper-runtime.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("jkshm.jar");
        noTldJars.add("jkconfig.jar");
        noTldJars.add("naming-common.jar");
        noTldJars.add("naming-resources.jar");
        noTldJars.add("naming-factory.jar");
        noTldJars.add("naming-java.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("servlets-default.jar");
        noTldJars.add("servlets-invoker.jar");
        noTldJars.add("servlets-common.jar");
        noTldJars.add("servlets-webdav.jar");
        noTldJars.add("tomcat-util.jar");
        noTldJars.add("tomcat-http11.jar");
        noTldJars.add("tomcat-jni.jar");
        noTldJars.add("tomcat-jk.jar");
        noTldJars.add("tomcat-jk2.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        noTldJars.add("FastInfoset.jar");
        noTldJars.add("jaxb-xjc.jar");
        noTldJars.add("ldap.jar");
        noTldJars.add("sjsxp.jar");
        noTldJars.add("activation.jar");
        noTldJars.add("extension.jar");
        noTldJars.add("jaxb1-impl.jar");
        noTldJars.add("jeusjaxb.jar");
        noTldJars.add("mail.jar");
        noTldJars.add("snmp_agent.jar");
        noTldJars.add("howl.jar");
        noTldJars.add("namespace.jar");
        noTldJars.add("webt30.jar");
        noTldJars.add("http.jar");
        noTldJars.add("jaxws-rt.jar");
        noTldJars.add("jeusutil.jar");
        noTldJars.add("wsaddr.jar");
        noTldJars.add("bootstrap.jar");
        noTldJars.add("j2com.jar");
        noTldJars.add("jaxws-tools.jar");
        noTldJars.add("jmxremote.jar");
        noTldJars.add("jtmax.jar");
        noTldJars.add("resolver.jar");
        noTldJars.add("wsrm.jar");
        noTldJars.add("bootstrap_release.jar");
        noTldJars.add("javaee.jar");
        noTldJars.add("jeus-hibernate.jar");
        noTldJars.add("jmxri.jar");
        noTldJars.add("jxalan.jar");
        noTldJars.add("wstx.jar");
        noTldJars.add("jeus-toplink-essentials.jar");
        noTldJars.add("jmxtools.jar");
        noTldJars.add("jxerces.jar");
        noTldJars.add("saaj-impl.jar");
        noTldJars.add("xml_resource.jar");
        noTldJars.add("jaxb-impl.jar");
        noTldJars.add("jeus.jar");
        noTldJars.add("jxml-impl.jar");
        noTldJars.add("sasl.jar");
        noTldJars.add("xmlsec.jar");
        noTldJars.add("base.jar");
        noTldJars.add("broker.jar");
        noTldJars.add("cloudclient.jar");
        noTldJars.add("cloudscape.jar");
        noTldJars.add("cloudutil.jar");
        noTldJars.add("com.ibm.mq.jar");
        noTldJars.add("com.ibm.mqjms.jar");
        noTldJars.add("jconn2.jar");
        noTldJars.add("msbase.jar");
        noTldJars.add("mssqlserver.jar");
        noTldJars.add("msutil.jar");
        noTldJars.add("ojdbc14.jar");
        noTldJars.add("oracle.jar");
        noTldJars.add("RmiJdbc.jar");
        noTldJars.add("util.jar");
        systemJars = new HashSet();
        systemJars.add("standard.jar");
        systemJars.add("appserv-jstl.jar");
        systemJars.add("jstl.jar");
        systemJars.add("jstl12_impl.jar");
        systemJars.add("jsf-impl.jar");
        systemUris = new HashSet();
        systemUris.add("http://java.sun.com/jsf/core");
        systemUris.add("http://java.sun.com/jsf/html");
        systemUris.add("http://java.sun.com/jsp/jstl/core");
    }
}

