/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.jsp2.EmbeddedServletOptions;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.jsp2.servlet.JspServletWrapper;

public class JspServlet
extends HttpServlet {
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;
    private int countErrors;
    private Object errorCountLk = new Object();
    private String httpMethodsString = null;
    private HashSet httpMethodsSet = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.options = new EmbeddedServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        this.httpMethodsString = config.getInitParameter("httpMethods");
        if (this.httpMethodsString != null && !this.httpMethodsString.equals("*")) {
            this.httpMethodsSet = new HashSet();
            StringTokenizer tokenizer = new StringTokenizer(this.httpMethodsString, ", \t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                this.httpMethodsSet.add(tokenizer.nextToken());
            }
        }
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    public int getJspErrorCount() {
        return this.countErrors;
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.httpMethodsSet != null) {
            String method = request.getMethod();
            if (method == null) {
                return;
            }
            boolean isSupportedMethod = this.httpMethodsSet.contains(method);
            if (!isSupportedMethod) {
                if (method.equals("OPTIONS")) {
                    response.addHeader("Allow", this.httpMethodsString);
                } else {
                    super.service(request, response);
                }
                return;
            }
        }
        String jspUri = null;
        String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
        if (jspFile != null) {
            jspUri = jspFile;
        } else {
            String pathInfo;
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            }
        }
        try {
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (ServletException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (IOException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (Throwable e) {
            this.incrementErrorCount();
            throw new ServletException(e);
        }
    }

    public void destroy() {
        this.rctxt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (null == this.context.getResource(jspUri) && !this.options.getUsePrecompiled()) {
                        String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                        if (includeRequestUri != null) {
                            throw new FileNotFoundException(jspUri);
                        }
                        response.sendError(404);
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementErrorCount() {
        Object object = this.errorCountLk;
        synchronized (object) {
            ++this.countErrors;
        }
    }
}

