/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.compiler.Localizer;
import jeus.servlet.jsp2.xmlparser.MyEntityResolver;
import jeus.servlet.jsp2.xmlparser.MyErrorHandler;
import jeus.servlet.jsp2.xmlparser.MyLSResourceResolver;
import jeus.servlet.jsp2.xmlparser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static ErrorHandler errorHandler = new MyErrorHandler();
    static EntityResolver entityResolver = new MyEntityResolver();
    static String schemaResourcePrefix;
    private static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    private static final String SCHEMA_LOCATION_JSP_20 = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd";
    private static final String SCHEMA_LOCATION_JSP_21 = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd";
    static final String[] CACHED_DTD_RESOURCE_PATHS;
    static final String[] CACHED_SCHEMA_RESOURCE_PATHS;

    public static void setSchemaResourcePrefix(String prefix) {
        schemaResourcePrefix = prefix;
        for (int i = 0; i < CACHED_SCHEMA_RESOURCE_PATHS.length; ++i) {
            String path = CACHED_SCHEMA_RESOURCE_PATHS[i];
            int index = path.lastIndexOf(47);
            if (index == -1) continue;
            ParserUtils.CACHED_SCHEMA_RESOURCE_PATHS[i] = prefix + path.substring(index + 1);
        }
    }

    public static void setDtdResourcePrefix(String prefix) {
        for (int i = 0; i < CACHED_DTD_RESOURCE_PATHS.length; ++i) {
            String path = CACHED_DTD_RESOURCE_PATHS[i];
            int index = path.lastIndexOf(47);
            if (index == -1) continue;
            ParserUtils.CACHED_DTD_RESOURCE_PATHS[i] = prefix + path.substring(index + 1);
        }
    }

    public TreeNode parseXMLDocument(String uri, InputSource is) throws Jsp2EngineException {
        return this.parseXMLDocument(uri, is, false, false);
    }

    public TreeNode parseXMLDocument(String uri, InputSource is, boolean isTld, boolean validate) throws Jsp2EngineException {
        Document document = null;
        try {
            Schema schema;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(entityResolver);
            builder.setErrorHandler(errorHandler);
            document = builder.parse(is);
            document.setDocumentURI(uri);
            if (isTld && validate && (schema = this.getTaglibSchema(document)) != null) {
                schema.newValidator().validate(new DOMSource(document));
            }
        }
        catch (ParserConfigurationException ex) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.parse.xml", uri), ex);
        }
        catch (SAXParseException ex) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.parse.xml.line", uri, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber())), ex);
        }
        catch (SAXException sx) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.parse.xml", uri), sx);
        }
        catch (IOException io) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.parse.xml", uri), io);
        }
        return this.convert(null, document.getDocumentElement());
    }

    public TreeNode parseXMLDocument(String uri, InputStream is) throws Jsp2EngineException {
        return this.parseXMLDocument(uri, new InputSource(is), false, false);
    }

    public TreeNode parseXMLDocument(String uri, InputStream is, boolean isTld, boolean validate) throws Jsp2EngineException {
        return this.parseXMLDocument(uri, new InputSource(is), isTld, validate);
    }

    protected TreeNode convert(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child instanceof Comment) continue;
                if (child instanceof Text) {
                    String body = ((Text)child).getData();
                    if (body == null || (body = body.trim()).length() <= 0) continue;
                    treeNode.setBody(body);
                    continue;
                }
                TreeNode treeChild = this.convert(treeNode, child);
            }
        }
        return treeNode;
    }

    private Schema getTaglibSchema(Document document) throws SAXException, Jsp2EngineException {
        Schema schema = null;
        Element root = document.getDocumentElement();
        NamedNodeMap map = root.getAttributes();
        for (int i = 0; map != null && i < map.getLength(); ++i) {
            if (!SCHEMA_LOCATION_ATTR.equals(map.item(i).getLocalName())) continue;
            if (SCHEMA_LOCATION_JSP_20.equals(map.item(i).getNodeValue())) {
                schema = this.getTaglibSchema("web-jsptaglibrary_2_0.xsd");
                break;
            }
            if (SCHEMA_LOCATION_JSP_21.equals(map.item(i).getNodeValue())) {
                schema = this.getTaglibSchema("web-jsptaglibrary_2_1.xsd");
                break;
            }
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.parse.unknownTldSchemaLocation", document.getDocumentURI(), map.item(i).getNodeValue()));
        }
        return schema;
    }

    private Schema getTaglibSchema(String schemaPublicId) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new MyLSResourceResolver());
        schemaFactory.setErrorHandler(new MyErrorHandler());
        return schemaFactory.newSchema(new StreamSource(this.getClass().getResourceAsStream(schemaResourcePrefix + schemaPublicId)));
    }

    static {
        CACHED_DTD_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "/javax/servlet/resources/web-app_2_2.dtd", "/javax/servlet/resources/web-app_2_3.dtd"};
        CACHED_SCHEMA_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", "/javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", "/javax/servlet/resources/web-app_2_4.xsd", "/javax/servlet/resources/web-app_2_5.xsd"};
    }
}

