/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.beans.Introspector;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.el.BeanELResolver;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.servlet.loader.ContextLoader;
import sun.misc.SoftCache;

public class ApplicationClassReleaser {
    public static void releaseApplicationClasses(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        if (loader instanceof ContextLoader) {
            ApplicationClassReleaser.releaseBeanUtils(loader);
            ApplicationClassReleaser.releaseIntrospector(loader);
            ApplicationClassReleaser.releaseFactoryFinder(loader);
            ApplicationClassReleaser.releaseJaxbInjector(loader);
            ApplicationClassReleaser.releaseResourceBundle(loader);
            ApplicationClassReleaser.releaseResourceBundleJDK6(loader);
            ApplicationClassReleaser.releaseResourceManager(loader);
            ApplicationClassReleaser.releaseProxy(loader);
            ApplicationClassReleaser.releasePropertyEditors(loader);
            ApplicationClassReleaser.releaseFacesContext(loader);
            ApplicationClassReleaser.releaseDigesterFactory(loader);
        }
        ApplicationClassReleaser.releaseLogFactory(loader);
        ApplicationClassReleaser.releaseSerialization(loader);
        ApplicationClassReleaser.releaseNamingResourceManager(loader);
        ApplicationClassReleaser.releaseELResolver(loader);
        if (loader instanceof EJBRootClassLoader) {
            ApplicationClassReleaser.releaseUnicastServerRef(loader);
        }
    }

    private static void releaseResourceManager(ClassLoader loader) {
        try {
            Class<?> resourceManager = loader.loadClass("com.sun.naming.internal.ResourceManager");
            Field urlFactoryCache = resourceManager.getDeclaredField("urlFactoryCache");
            urlFactoryCache.setAccessible(true);
            Map map = (Map)urlFactoryCache.get(null);
            map.remove(loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseProxy(ClassLoader loader) {
        Map map;
        Class<?> proxy;
        try {
            proxy = loader.loadClass("java.lang.reflect.Proxy");
            Field proxyClasses = proxy.getDeclaredField("proxyClasses");
            proxyClasses.setAccessible(true);
            map = (Map)proxyClasses.get(null);
            for (Class clazz : map.keySet()) {
                if (!loader.equals(clazz.getClassLoader())) continue;
                map.remove(clazz);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            proxy = loader.loadClass("java.lang.reflect.Proxy");
            Field loaderToCache = proxy.getDeclaredField("loaderToCache");
            loaderToCache.setAccessible(true);
            map = (Map)loaderToCache.get(null);
            map.remove(loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releasePropertyEditors(ClassLoader loader) {
        Map map = null;
        ArrayList<Class> keys = new ArrayList<Class>();
        try {
            Class<?> manager = loader.loadClass("java.beans.PropertyEditorManager");
            Field registry = manager.getDeclaredField("registry");
            registry.setAccessible(true);
            map = (Map)registry.get(null);
            for (Class keyClass : map.keySet()) {
                Class valueClass = (Class)map.get(keyClass);
                ClassLoader valueClassLoader = valueClass.getClassLoader();
                if (valueClassLoader == null || !loader.equals(valueClassLoader) && !loader.equals(valueClassLoader.getClass().getClassLoader())) continue;
                keys.add(keyClass);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            for (Class clazz : keys) {
                map.remove(clazz);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseFacesContext(ClassLoader loader) {
        try {
            Class<?> facesContext = loader.loadClass("javax.faces.context.FacesContext");
            Field instance = facesContext.getDeclaredField("instance");
            instance.setAccessible(true);
            instance.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseDigesterFactory(ClassLoader loader) {
        try {
            Class<?> digesterFactory = loader.loadClass("com.sun.faces.config.DigesterFactory");
            Field versionListener = digesterFactory.getDeclaredField("versionListener");
            versionListener.setAccessible(true);
            versionListener.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseJaxbInjector(ClassLoader loader) {
        try {
            Class<?> injector = loader.loadClass("com.sun.xml.bind.v2.runtime.reflect.opt.Injector");
            Field injectors = injector.getDeclaredField("injectors");
            injectors.setAccessible(true);
            Map map = (Map)injectors.get(null);
            map.remove(loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseResourceBundle(ClassLoader loader) {
        try {
            Class<?> resourceBundle = loader.loadClass("java.util.ResourceBundle");
            Field cacheList = resourceBundle.getDeclaredField("cacheList");
            cacheList.setAccessible(true);
            SoftCache softCacheObject = (SoftCache)cacheList.get(null);
            Class<?> resourceCacheKey = loader.loadClass("java.util.ResourceBundle$ResourceCacheKey");
            Field loaderRef = resourceCacheKey.getDeclaredField("loaderRef");
            loaderRef.setAccessible(true);
            Method resourceCacheKeyClear = resourceCacheKey.getDeclaredMethod("clear", null);
            resourceCacheKeyClear.setAccessible(true);
            Class<?> reference = loader.loadClass("java.lang.ref.Reference");
            Field referent = reference.getDeclaredField("referent");
            referent.setAccessible(true);
            SoftCache softCache = softCacheObject;
            synchronized (softCache) {
                ArrayList contextLoaderReferentKeys = new ArrayList();
                Set keySet = softCacheObject.keySet();
                for (Object key : keySet) {
                    Object loaderRefObj = loaderRef.get(key);
                    Object referentObj = referent.get(loaderRefObj);
                    if (!loader.equals(referentObj)) continue;
                    contextLoaderReferentKeys.add(key);
                }
                for (Object key : contextLoaderReferentKeys) {
                    softCacheObject.remove(key);
                    resourceCacheKeyClear.invoke(key, null);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseResourceBundleJDK6(ClassLoader loader) {
        try {
            Class<?> resourceBundle = loader.loadClass("java.util.ResourceBundle");
            Method cacheKeyGetLoaderMethod = resourceBundle.getDeclaredMethod("clearCache", ClassLoader.class);
            cacheKeyGetLoaderMethod.setAccessible(true);
            cacheKeyGetLoaderMethod.invoke(null, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseIntrospector(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        try {
            Introspector.flushCaches();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseBeanUtils(ClassLoader loader) {
        Class<?> ctxClLocalCls;
        Object ctxClLocal;
        Field field;
        Object beanUtilsBean;
        Method m;
        Class<?> beanUtilsBeanCls;
        Method createMethod;
        Class<?> releaseMe;
        if (loader == null) {
            return;
        }
        try {
            releaseMe = loader.loadClass("org.apache.commons.beanutils.PropertyUtils");
            createMethod = releaseMe.getMethod("clearDescriptors", null);
            createMethod.invoke(null, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            releaseMe = loader.loadClass("com.sun.org.apache.commons.beanutils.PropertyUtils");
            createMethod = releaseMe.getMethod("clearDescriptors", null);
            createMethod.invoke(null, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            beanUtilsBeanCls = loader.loadClass("org.apache.commons.beanutils.BeanUtilsBean");
            m = beanUtilsBeanCls.getMethod("getInstance", null);
            beanUtilsBean = m.invoke(null, null);
            field = beanUtilsBeanCls.getDeclaredField("beansByClassLoader");
            field.setAccessible(true);
            ctxClLocal = field.get(beanUtilsBean);
            ctxClLocalCls = loader.loadClass("org.apache.commons.beanutils.ContextClassLoaderLocal");
            m = ctxClLocalCls.getMethod("unset", ClassLoader.class);
            m.invoke(ctxClLocal, loader);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            beanUtilsBeanCls = loader.loadClass("com.sun.org.apache.commons.beanutils.BeanUtilsBean");
            m = beanUtilsBeanCls.getMethod("getInstance", null);
            beanUtilsBean = m.invoke(null, null);
            field = beanUtilsBeanCls.getDeclaredField("beansByClassLoader");
            field.setAccessible(true);
            ctxClLocal = field.get(beanUtilsBean);
            ctxClLocalCls = loader.loadClass("com.sun.org.apache.commons.beanutils.ContextClassLoaderLocal");
            m = ctxClLocalCls.getMethod("unset", ClassLoader.class);
            m.invoke(ctxClLocal, loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void releaseLogFactory(ClassLoader loader) {
        Object[] args;
        Method createMethod;
        Class<?> releaseMe;
        if (loader == null) {
            return;
        }
        try {
            releaseMe = loader.loadClass("org.apache.commons.logging.LogFactory");
            createMethod = releaseMe.getMethod("release", ClassLoader.class);
            args = new Object[]{loader};
            createMethod.invoke(null, args);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            releaseMe = loader.loadClass("com.sun.org.apache.commons.logging.LogFactory");
            createMethod = releaseMe.getMethod("release", ClassLoader.class);
            args = new Object[]{loader};
            createMethod.invoke(null, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseFactoryFinder(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        try {
            Class<?> releaseMe = loader.loadClass("javax.faces.FactoryFinder");
            ApplicationClassReleaser.removeClassLoader(loader, releaseMe, "_registeredFactoryNames");
            ApplicationClassReleaser.removeClassLoader(loader, releaseMe, "_factories");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeClassLoader(ClassLoader loader, Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        if (loader == null || clazz == null || fieldName == null) {
            return;
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Map cache = (Map)field.get(null);
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                if (cache != null) {
                    cache.remove(loader);
                }
            }
        }
    }

    private static void releaseSerialization(ClassLoader loader) {
        try {
            ApplicationClassReleaser.clearMap(null, ObjectStreamClass.class, "reflectors");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ApplicationClassReleaser.clearMap(null, ObjectStreamClass.class, "localDescs");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ApplicationClassReleaser.clearMap(null, ObjectInputStream.class, "subclassAudits");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ApplicationClassReleaser.clearMap(null, ObjectOutputStream.class, "subclassAudits");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void releaseELResolver(ClassLoader loader) {
        try {
            ApplicationClassReleaser.clearMap(null, BeanELResolver.class, "properties");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ApplicationClassReleaser.clearMap(null, BeanELResolver.class, "properties2");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseNamingResourceManager(ClassLoader loader) {
        block6: {
            try {
                Class<?> clazz = loader.loadClass("com.sun.naming.internal.ResourceManager");
                Field field = clazz.getDeclaredField("propertiesCache");
                field.setAccessible(true);
                WeakHashMap cache = (WeakHashMap)field.get(null);
                if (cache == null) break block6;
                WeakHashMap weakHashMap = cache;
                synchronized (weakHashMap) {
                    Iterator i = cache.keySet().iterator();
                    while (i.hasNext()) {
                        Object key = i.next();
                        if (!(key instanceof ClassLoader) || (ClassLoader)key != loader) continue;
                        i.remove();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void releaseUnicastServerRef(ClassLoader loader) {
        try {
            Class<?> clazz = loader.loadClass("sun.rmi.server.UnicastServerRef");
            ApplicationClassReleaser.clearClassKeyedMap(loader, null, clazz, "methodTableCache");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMap(Object obj, Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null || fieldName == null) {
            return;
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Map cache = (Map)field.get(obj);
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearClassKeyedMap(ClassLoader loader, Object obj, Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null || fieldName == null) {
            return;
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Map cache = (Map)field.get(obj);
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                Iterator i = cache.keySet().iterator();
                while (i.hasNext()) {
                    Class cls = (Class)i.next();
                    ClassLoader cl = cls.getClassLoader();
                    if (cl != loader) continue;
                    i.remove();
                }
            }
        }
    }
}

