/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.servlet.engine.DummyInstancePool;
import jeus.servlet.engine.InstancePool;
import jeus.servlet.engine.SmartInstancePool;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.PrivateClassLoader;
import jeus.servlet.loader.PrivateReloader;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer1;

public class ServletReloader
extends PrivateReloader {
    protected ServletConfig servletConfig;
    protected boolean isSTM;
    protected InstancePool instancePool;
    protected boolean suspended;
    protected boolean destroyed;
    protected String jaxRpcImplClassName;

    ServletReloader(ContextLoader parent, String className, ServletConfig config) {
        super(parent, className);
        this.servletConfig = config;
        this.classLoader = new PrivateClassLoader(parent, this, className);
        this.isSTM = false;
        this.readClassAnnotation();
    }

    protected ServletReloader(ContextLoader parent, String className) {
        super(parent, className);
        this.isSTM = false;
    }

    public Servlet getServlet() throws ServletException {
        if (this.unavailable) {
            return this.contextLoader.getUnavailableServlet();
        }
        if (this.suspended) {
            return this.contextLoader.getSuspendServlet();
        }
        Servlet servlet = (Servlet)this.getInstance();
        if (this.isSTM) {
            return this.instancePool.getFreeInstance();
        }
        return servlet;
    }

    public void putServlet(Servlet servlet) {
        if (this.isSTM) {
            this.instancePool.putActiveInstance(servlet);
        }
    }

    protected void doInitInstance(Object obj) throws ServletException {
        if (!(obj instanceof Servlet)) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2208, (Object)this.className));
        }
        ((Servlet)obj).init(this.servletConfig);
        if (obj instanceof SingleThreadModel) {
            this.isSTM = true;
            int poolSize = this.contextLoader.getContext().getMaxInstancePoolSize();
            this.instancePool = poolSize >= 0 ? new SmartInstancePool(poolSize, obj.getClass(), this.servletConfig, (Servlet)obj) : new DummyInstancePool(obj.getClass(), this.servletConfig);
        }
    }

    protected final void doDestroyInstance() {
        block4: {
            try {
                Servlet servlet = (Servlet)this.instance;
                this.unavailable = true;
                if (servlet != null) {
                    servlet.destroy();
                    this.destroyed = true;
                    if (logger.isLoggable(JeusMessage_WebContainer1._2207_LEVEL)) {
                        logger.log(JeusMessage_WebContainer1._2207_LEVEL, JeusMessage_WebContainer1._2207, (Object)this.className);
                    }
                }
                this.instance = null;
                this.unavailable = false;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebContainer1._2206_LEVEL)) break block4;
                logger.log(JeusMessage_WebContainer1._2206_LEVEL, JeusMessage_WebContainer1._2206, (Object)this.className, t);
            }
        }
    }

    public final void destroyServlet() {
        this.destroy();
    }

    public final boolean suspend() {
        this.suspended = true;
        return this.suspended;
    }

    public final boolean resume() {
        this.suspended = false;
        return true;
    }

    public ServletInfo getServletInfo(String servletName, long count) {
        int state = 0;
        if (this.instance != null) {
            state = 1;
        }
        if (this.suspended) {
            state = 2;
        }
        if (this.destroyed) {
            state = 3;
        }
        if (this.jaxRpcImplClassName == null) {
            return new ServletInfo(servletName, this.className, null, state, count);
        }
        ServletInfo info = new ServletInfo(servletName, this.jaxRpcImplClassName, null, state, count);
        info.setWebserviceServlet(true);
        return info;
    }

    public void setJaxRpcImplClassName(String jaxRpcImplClassName) {
        this.jaxRpcImplClassName = jaxRpcImplClassName;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }
}

