/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import jeus.container.annotation.ClassAnnotationReader;
import jeus.container.namingenv.EnvironmentAnnotationProcessor;
import jeus.container.namingenv.NamingEnvManager;
import jeus.container.namingenv.NamingEnvironment;
import jeus.container.security.SecurityAnnotationInfo;
import jeus.container.security.SecurityAnnotationProcessor;
import jeus.deploy.InvalidAnnotationException;
import jeus.servlet.engine.Context;
import jeus.servlet.loader.ContextLoader;

public class WebAnnotationProcessor {
    private String runAs = null;
    private ContextLoader loader;
    private NamingEnvManager namingEnvManager = null;

    public WebAnnotationProcessor(ContextLoader loader, Class clazz) throws InvalidAnnotationException {
        this.loader = loader;
        Context context = loader.getContext();
        this.namingEnvManager = context.getNamingEnvManager();
        if (this.namingEnvManager == null) {
            throw new InvalidAnnotationException("the NamingEnvManager must be initialized");
        }
        NamingEnvironment environment = this.namingEnvManager.getNamingEnvironment();
        EnvironmentAnnotationProcessor envProcessor = new EnvironmentAnnotationProcessor(environment);
        SecurityAnnotationProcessor securityProcessor = new SecurityAnnotationProcessor();
        securityProcessor.setIgnoreMethodLevel(true);
        if (clazz != null) {
            ClassAnnotationReader reader = new ClassAnnotationReader(clazz);
            reader.addAnnotationProcessor(envProcessor);
            reader.addAnnotationProcessor(securityProcessor);
            reader.process();
        }
        SecurityAnnotationInfo securityInfo = securityProcessor.getSecurityInfo();
        this.runAs = securityInfo.getRunAsRole();
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void inject(Object obj) throws Throwable {
        Class<?> clazz = obj.getClass();
        this.namingEnvManager.rebindClassEntries(clazz, this.loader.getContext().getEnvContext());
        this.namingEnvManager.resolveInjections(clazz, obj);
    }

    public void invokePostConstruct(Object obj) throws Throwable {
        this.namingEnvManager.invokePostConstructCallbacks(obj.getClass(), obj);
    }

    public void invokePreDestroy(Object obj) throws Throwable {
        this.namingEnvManager.invokePreDestroyCallbacks(obj.getClass(), obj);
    }
}

