/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import jeus.servlet.reverseproxy.ServerChain;
import jeus.servlet.reverseproxy.model.Server;
import jeus.util.logging.JeusLogger;

public final class UrlRewritingOutputStream
extends ServletOutputStream {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private ServletOutputStream originalStream;
    private ByteArrayOutputStream stream;
    private String ownHostName;
    private String contextPath;
    private ServerChain serverChain;
    private static Pattern linkPattern = Pattern.compile("\\b(href=|src=|action=|location=|url\\()(\\s*[\"'])(([^/]+://)([^/<>]+))?([^\"'>]*)[\"']", 130);

    public UrlRewritingOutputStream(ServletOutputStream originalStream, String ownHostName, String contextPath, ServerChain serverChain) {
        this.originalStream = originalStream;
        this.ownHostName = ownHostName;
        this.contextPath = contextPath;
        this.serverChain = serverChain;
        this.stream = new ByteArrayOutputStream();
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    public void rewrite(Server server, String charSet) throws IOException {
        StringBuffer page = new StringBuffer();
        Matcher matcher = null;
        matcher = charSet == null ? linkPattern.matcher(this.stream.toString()) : linkPattern.matcher(this.stream.toString(charSet));
        while (matcher.find()) {
            String link = matcher.group(6).replaceAll("\\$", "\\\\\\$");
            if (link.length() == 0) {
                link = "/";
            }
            String rewritten = null;
            if (matcher.group(4) != null) {
                rewritten = this.handleExternalLink(matcher, link);
            } else if (link.startsWith("/")) {
                rewritten = this.handleLocalLink(server, matcher, link);
            }
            if (rewritten == null) continue;
            logger.log(Level.FINEST, "Found link " + link + " >> " + rewritten);
            matcher.appendReplacement(page, rewritten);
        }
        matcher.appendTail(page);
        if (charSet == null) {
            this.originalStream.write(page.toString().getBytes());
        } else {
            this.originalStream.write(page.toString().getBytes(charSet));
        }
    }

    private String handleExternalLink(Matcher matcher, String link) {
        String location = matcher.group(5) + link;
        Server matchingServer = this.serverChain.getServerMapped(location);
        if (matchingServer != null) {
            link = link.substring(matchingServer.getPath().length());
            link = matchingServer.getRule().revert(link);
            String type = matcher.group(1);
            String separator = matcher.group(2);
            String protocol = matcher.group(4);
            return type + separator + protocol + this.ownHostName + this.contextPath + link + separator;
        }
        return null;
    }

    private String handleLocalLink(Server server, Matcher matcher, String link) {
        String serverDir = server.getPath();
        if (serverDir.equals("") || link.startsWith(serverDir + "/")) {
            link = server.getRule().revert(link.substring(serverDir.length()));
            String type = matcher.group(1);
            String separator = matcher.group(2);
            return type + separator + this.contextPath + link + separator;
        }
        link = server.getRule().revert(link);
        String type = matcher.group(1);
        String separator = matcher.group(2);
        return type + separator + link + separator;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

