/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.factories;

import java.net.HttpURLConnection;
import jeus.servlet.reverseproxy.factories.MethodNotAllowedException;
import jeus.servlet.reverseproxy.model.AllowedMethodHandler;
import jeus.servlet.reverseproxy.model.ResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.DeleteResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.GetResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.HeadResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.OptionsResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.PostResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.PutResponseHandler;
import jeus.servlet.reverseproxy.responsehandlers.ResponseHandlerBase;
import jeus.servlet.reverseproxy.responsehandlers.TraceResponseHandler;

public class ResponseHandlerFactory {
    private static final String handledMethods = "OPTIONS,GET,HEAD,POST,PUT,DELETE,TRACE";

    public static ResponseHandler createResponseHandler(HttpURLConnection httpURLConnection) throws MethodNotAllowedException {
        String requestMethod = httpURLConnection.getRequestMethod();
        if (!AllowedMethodHandler.methodAllowed(requestMethod)) {
            throw new MethodNotAllowedException("The method " + requestMethod + " is not in the AllowedHeaderHandler's list of allowed methods.", AllowedMethodHandler.getAllowHeader());
        }
        ResponseHandlerBase handler = null;
        if (requestMethod.equals("OPTIONS")) {
            handler = new OptionsResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("GET")) {
            handler = new GetResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("HEAD")) {
            handler = new HeadResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("POST")) {
            handler = new PostResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("PUT")) {
            handler = new PutResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("DELETE")) {
            handler = new DeleteResponseHandler(httpURLConnection);
        } else if (requestMethod.equals("TRACE")) {
            handler = new TraceResponseHandler(httpURLConnection);
        } else {
            throw new MethodNotAllowedException("The method " + requestMethod + " was allowed by the AllowedMethodHandler, not by the factory.", handledMethods);
        }
        return handler;
    }
}

