/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.requesthandlers;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.requesthandlers.RequestHandlerBase;

public class MaxForwardRequestHandler
extends RequestHandlerBase {
    public HttpURLConnection process(HttpServletRequest request, String url, String hostName) throws IOException {
        URL addr = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)addr.openConnection();
        String method = request.getMethod();
        if (!method.equalsIgnoreCase("OPTIONS") && !method.equalsIgnoreCase("TRACE")) {
            return null;
        }
        httpURLConnection.setRequestMethod(method);
        try {
            int max = request.getIntHeader("Max-Forwards");
            if (max == 0 || request.getRequestURI().equals("*")) {
                this.setAllHeaders(httpURLConnection, request);
                httpURLConnection.setRequestProperty("Host", hostName);
            } else if (max != -1) {
                this.setHeaders(httpURLConnection, request);
                httpURLConnection.setRequestProperty("Host", hostName);
                httpURLConnection.setRequestProperty("Max-Forwards", "" + max--);
                httpURLConnection.connect();
            } else {
                this.setHeaders(httpURLConnection, request);
                httpURLConnection.setRequestProperty("Host", hostName);
                httpURLConnection.connect();
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return httpURLConnection;
    }

    private void setAllHeaders(HttpURLConnection httpURLConnection, HttpServletRequest request) {
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            Enumeration value = request.getHeaders(name);
            while (value.hasMoreElements()) {
                httpURLConnection.setRequestProperty(name, (String)value.nextElement());
            }
        }
    }
}

