/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.responsehandlers;

import java.io.IOException;
import java.net.HttpURLConnection;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.model.AllowedMethodHandler;
import jeus.servlet.reverseproxy.responsehandlers.ResponseHandlerBase;
import jeus.util.message.JeusMessage_WebContainer10;

public class OptionsResponseHandler
extends ResponseHandlerBase {
    private boolean useOwnAllow = true;

    public OptionsResponseHandler(HttpURLConnection httpURLConnection) {
        super(httpURLConnection);
    }

    public void process(HttpServletResponse response) {
        if (this.useOwnAllow) {
            response.setStatus(200);
            response.setHeader("allow", AllowedMethodHandler.getAllowHeader());
            response.setHeader("Connection", "close");
            response.setHeader("content-length", "0");
        } else {
            this.setHeaders(response);
            response.setStatus(this.getStatusCode());
            String allow = this.httpURLConnection.getHeaderField("allow");
            response.setHeader("allow", AllowedMethodHandler.processAllowHeader(allow));
            String contentLength = this.httpURLConnection.getHeaderField("Content-Length");
            if (contentLength == null || contentLength.equals("0")) {
                response.setHeader("Content-Length", "0");
            } else {
                try {
                    this.sendStreamToClient((ServletResponse)response);
                }
                catch (IOException e) {
                    logger.log(JeusMessage_WebContainer10._10415_LEVEL, JeusMessage_WebContainer10._10415, (Throwable)e);
                    response.setHeader("Content-Length", "0");
                }
            }
        }
    }

    public int getStatusCode() {
        if (this.useOwnAllow) {
            return 200;
        }
        return super.getStatusCode();
    }
}

