/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.servers;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import jeus.servlet.reverseproxy.model.Server;
import jeus.servlet.reverseproxy.servers.ServerStatusListener;
import jeus.util.logging.JeusLogger;

public class ServerStatusChecker
extends Thread {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private LinkedList online;
    private LinkedList offline;
    private ServerStatusListener listener;
    private long pollingTime;

    public ServerStatusChecker(ServerStatusListener listener, long pollingTime) {
        this.listener = listener;
        this.pollingTime = Math.max(30000L, pollingTime);
        this.setPriority(4);
        this.setDaemon(true);
        this.online = new LinkedList();
        this.offline = new LinkedList();
    }

    public void run() {
        while (true) {
            this.checkOnlineServers();
            this.checkOfflineServers();
            try {
                ServerStatusChecker.sleep(this.pollingTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkOnlineServers() {
        ListIterator itr = this.online.listIterator();
        HttpURLConnection httpURLConnection = null;
        while (itr.hasNext()) {
            Server server = (Server)itr.next();
            String url = this.getServerURL(server);
            try {
                URL u = new URL(url);
                httpURLConnection = (HttpURLConnection)u.openConnection();
                HttpURLConnection.setFollowRedirects(false);
                httpURLConnection.connect();
                if (this.okServerResponse(httpURLConnection.getResponseCode())) continue;
                this.offline.add(server);
                itr.remove();
                logger.log(Level.FINEST, "Server going OFFLINE! " + this.getServerURL(server));
                this.listener.serverOffline(server);
            }
            catch (Exception e) {
                this.offline.add(server);
                itr.remove();
                logger.log(Level.FINEST, "Server going OFFLINE! " + this.getServerURL(server));
                this.listener.serverOffline(server);
            }
            finally {
                if (httpURLConnection == null) continue;
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkOfflineServers() {
        ListIterator itr = this.offline.listIterator();
        HttpURLConnection httpURLConnection = null;
        while (itr.hasNext()) {
            Server server = (Server)itr.next();
            String url = this.getServerURL(server);
            try {
                URL u = new URL(url);
                httpURLConnection = (HttpURLConnection)u.openConnection();
                HttpURLConnection.setFollowRedirects(false);
                httpURLConnection.connect();
                if (!this.okServerResponse(httpURLConnection.getResponseCode())) continue;
                this.online.add(server);
                itr.remove();
                logger.log(Level.FINEST, "Server back online " + this.getServerURL(server));
                this.listener.serverOnline(server);
            }
            catch (Exception e) {
                this.listener.serverOffline(server);
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
    }

    private String getServerURL(Server server) {
        String url = "http://" + server.getDomainName() + server.getPath() + "/";
        return url;
    }

    private boolean okServerResponse(int statusCode) {
        return statusCode / 100 != 5;
    }

    public synchronized void addServer(Server server) {
        this.offline.add(server);
    }
}

