/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.TmaxThreadPoolManager;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxHeaderVer3;
import jeus.servlet.engine.io.TmaxUtil;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.servlet.tcp.TmaxServletRequest;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer1;

public class TmaxServletRequestImpl
extends TmaxServletRequest {
    private OutputStream out;
    protected int headerLength;
    public long startTime;
    private int webtobMessageType;
    private int webtobBodySize;
    private int webtobSequenceNumber;
    private int webtobClientId;
    private int webtobEtc;
    private int webtobSvciFlags;
    private int webtobSvciCd;
    private int webtobQcount;
    private TmaxHeader tmaxHeader;
    public boolean isHttpGW = false;

    public TmaxServletRequestImpl(ContextGroup ctxGroup, ThreadPoolManager manager, TCPDispatcherConfig config) {
        super(ctxGroup, manager, config);
        this.tmaxHeader = ((TmaxThreadPoolManager)manager).getTmaxHeader();
        if (this.tmaxHeader == null) {
            throw new IllegalArgumentException("tmaxHeader is null");
        }
        this.headerLength = this.tmaxHeader.TMAX_HEADER_SIZE();
        this.isHttpGW = ((TmaxThreadPoolManager)manager).getConnector().isHttpGW();
    }

    public String getListenerId() {
        return this.tpoolManager.getListenerId();
    }

    public String getServerGroupName() {
        return this.getConnectionDescriptor().getServerGroupName();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.tpoolManager.getConnectionDescriptor();
    }

    public void setSocket(Socket soc) throws IOException {
        super.setSocket(soc);
        this.out = soc.getOutputStream();
    }

    public void copySocket(HttpServletRequestImpl copy) {
        if (copy == null) {
            return;
        }
        if (!(copy instanceof TmaxServletRequestImpl)) {
            return;
        }
        TmaxServletRequestImpl copyTmaxReq = (TmaxServletRequestImpl)copy;
        super.copySocket(copyTmaxReq);
        this.out = copyTmaxReq.out;
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException, InterruptedException {
        int msgtype;
        if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        while (true) {
            this.header = TmaxUtil.recvHeader(this.tmaxHeader, this.bin);
            msgtype = TmaxUtil.readInt(this.header, this.tmaxHeader.MSGTYPE_OFFSET());
            if (msgtype != 203) break;
            this.processPingRequest(this.header);
        }
        if (msgtype == 108) {
            try {
                TmaxUtil.unregisterConnection(this.tmaxHeader, this.out, (InputStream)((Object)this.in), false, -1);
            }
            catch (IOException e) {
                // empty catch block
            }
            return msgtype;
        }
        return this.processRequest(postdataReadTimeout);
    }

    private int processRequest(int postdataReadTimeout) throws IOException, InterruptedException {
        this.method.setString("GET");
        this.contentLength = this.config.getBodyLength(this.header);
        this.contextPath = this.config.getContextPath(this.header);
        this.servletPath = this.config.getServletPath(this.header);
        if (this.servletPath != null && !this.servletPath.startsWith("/")) {
            this.servletPath = "/" + this.servletPath;
        }
        this.pathInfo = this.config.getPathInfo(this.header);
        this.requestURI.setString(this.contextPath);
        if (this.servletPath != null && !this.servletPath.equals("/")) {
            this.requestURI.setString(this.requestURI.getString() + this.servletPath);
        }
        if (this.pathInfo != null) {
            this.requestURI.setString(this.requestURI.getString() + this.pathInfo);
        }
        this.processCommonRequest(this.requestURI, null, null);
        int clen = this.getContentLength();
        if (clen > 0) {
            this.in.setLimit(clen);
        } else {
            this.in.setLimit(0);
        }
        if (this.tmaxHeader instanceof TmaxHeaderVer3) {
            int gw = TmaxUtil.readInt(this.header, this.tmaxHeader.XID_SEQNO_OFFSET());
            if (gw == 100) {
                this.isHttpGW = true;
                this.webtobReadRequest();
            } else {
                this.isHttpGW = false;
            }
        }
        if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(postdataReadTimeout);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private void processPingRequest(byte[] header) throws IOException {
        TmaxUtil.writeInt(header, 1203, this.tmaxHeader.MSGTYPE_OFFSET());
        this.out.write(header);
        this.out.flush();
    }

    private boolean isSystemMessage() {
        return this.webtobMessageType == 2105 || this.webtobMessageType == 1105 || this.webtobMessageType == 108 || this.webtobMessageType == 1124 || this.webtobMessageType == 140;
    }

    public int webtobReadRequest() throws IOException {
        this.webtobMessageType = 0;
        this.webtobBodySize = 0;
        this.webtobQcount = 0;
        this.parseWebtobHeader();
        if (logger.isLoggable(JeusMessage_WebContainer1._2401_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\tcontext-path : " + this.contextPath + StringUtil.lineSeparator);
            buf.append("\tservlet-path : " + this.servletPath + StringUtil.lineSeparator);
            buf.append("\tpath-info    : " + this.pathInfo + StringUtil.lineSeparator);
            buf.append("\trequest-uri  : " + this.requestURI + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + this.contentLength + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer1._2401_LEVEL, JeusMessage_WebContainer1._2401, (Object)buf.toString());
        }
        if (this.isSystemMessage()) {
            return this.webtobMessageType;
        }
        if (this.webtobBodySize <= 0) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)9767, (Object[])new String[]{String.valueOf(this.webtobBodySize)}));
        }
        int httpHeaderSize = this.webtobBodySize - this.contentLength;
        byte[] buf = new byte[httpHeaderSize];
        int size = this.in.readFully(buf, 0, httpHeaderSize);
        if (size != httpHeaderSize) {
            throw new IOException("[HttpGW-TmaxRequest] [E] read size not equal to message size (" + size + ", " + httpHeaderSize + ")");
        }
        int clen = this.getContentLength();
        if (clen > 0) {
            this.in.setLimit(clen);
        } else {
            this.in.setLimit(0);
        }
        int mark = 0;
        int fieldSize = 0;
        block16: while (mark < httpHeaderSize) {
            if ((fieldSize = (buf[mark++] - 48) * 1000 + (buf[mark++] - 48) * 100 + (buf[mark++] - 48) * 10 + (buf[mark++] - 48)) < 0) {
                throw new IOException("[HttpGW-TmaxRequest] [E] invalid message size : " + fieldSize);
            }
            if (fieldSize == 0) break;
            byte id = buf[mark++];
            String str = null;
            try {
                str = new String(buf, mark, fieldSize, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                str = new String(buf, mark, fieldSize);
            }
            mark += fieldSize;
            switch (id) {
                case 83: {
                    if (str == null || str.indexOf(".") <= 0) continue block16;
                    this.serverName = str;
                    break;
                }
                case 67: {
                    this.contextPath = str.substring(0, str.length() - 1);
                    this.contextPath = this.contextPath.trim();
                    break;
                }
                case 82: {
                    int indexQ = str.indexOf("?");
                    int rLen = str.length();
                    if (indexQ > -1 && indexQ < rLen) {
                        this.requestURI.setString(str.substring(0, indexQ));
                        this.queryString.setString(str.substring(indexQ + 1, rLen));
                        break;
                    }
                    this.requestURI.setString(str);
                    break;
                }
                case 77: {
                    this.method.setString(str);
                    break;
                }
                case 80: {
                    this.protocol.setString(str);
                    break;
                }
                case 69: {
                    int pos = str.indexOf("\t");
                    if (pos <= 0) continue block16;
                    String name = str.substring(0, pos);
                    String value = str.substring(pos + 1);
                    if (name.equals("REMOTE_ADDR")) {
                        this.remoteAddr = value;
                        break;
                    }
                    if (name.equals("REMOTE_HOST")) {
                        this.remoteHost = value;
                        break;
                    }
                    if (name.equals("SERVER_PORT")) {
                        this.serverPort = Integer.parseInt(value);
                        break;
                    }
                    if (name.equals("REMOTE_USER")) break;
                    if (name.equals("REQUEST_SCHEME")) {
                        this.scheme = value.toLowerCase();
                        break;
                    }
                    if (!name.equals("AUTH_TYPE") || value == null || value.equals("")) continue block16;
                    if (value.equalsIgnoreCase("basic")) {
                        this.authType = "BASIC";
                        break;
                    }
                    if (value.equalsIgnoreCase("digest")) {
                        this.authType = "DIGEST";
                        break;
                    }
                    this.authType = value;
                    break;
                }
                case 72: {
                    int pos = str.indexOf("\t");
                    if (pos <= 0) continue block16;
                    String name = str.substring(0, pos);
                    String value = str.substring(pos + 1);
                    this.addHeader(name, value);
                    break;
                }
                case 88: {
                    int pos = str.indexOf("\t");
                    if (pos <= 0) continue block16;
                    String name = str.substring(0, pos);
                    String value = str.substring(pos + 1);
                    this.addHeader(name, value);
                    break;
                }
                case 81: {
                    this.scheme = str.toLowerCase();
                    break;
                }
                case 86: {
                    try {
                        this.serverPort = Integer.parseInt(str);
                    }
                    catch (Exception e) {}
                    break;
                }
                default: {
                    throw new IOException(ErrorMsgManager.getLocalizedString((int)9763, (Object[])new String[]{new Byte(id).toString()}));
                }
            }
        }
        if (mark > httpHeaderSize) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)9764));
        }
        this.requestURI.setString(this.encodeRequestURI(this.requestURI.getString()));
        if (this.contextPath.length() == 0) {
            this.context = this.contextGroup.getContextByPath(this.getServerName(), this.requestURI.getString());
            if (this.context != null) {
                this.contextPath = this.context.getContextPath();
            }
        } else {
            this.context = this.contextGroup.getContextByPath(this.getServerName(), this.contextPath);
        }
        if (logger.isLoggable(JeusMessage_WebContainer1._2401_LEVEL)) {
            StringBuffer buff = new StringBuffer();
            buff.append("\theader length  : " + httpHeaderSize + StringUtil.lineSeparator);
            buff.append("\tcontent length : " + this.contentLength + StringUtil.lineSeparator);
            buff.append("\tcontent type   : " + this.getContentType() + StringUtil.lineSeparator);
            buff.append("\tserver name    : " + this.getServerName() + StringUtil.lineSeparator);
            buff.append("\trequest uri    : " + this.requestURI + StringUtil.lineSeparator);
            buff.append("\tquery string   : " + this.queryString + StringUtil.lineSeparator);
            buff.append("\tmethod         : " + this.method + StringUtil.lineSeparator);
            buff.append("\tprotocol       : " + this.protocol + StringUtil.lineSeparator);
            buff.append("\tcontext path   : " + this.contextPath + StringUtil.lineSeparator);
            buff.append("\tcontext name   : " + this.context.getContextName() + StringUtil.lineSeparator);
            buff.append("\t>>>>>>>>>>>>>>>>>>> request parse end " + Thread.currentThread().getName() + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer1._2401_LEVEL, JeusMessage_WebContainer1._2401, (Object)buf.toString());
        }
        return this.webtobMessageType;
    }

    private void parseWebtobHeader() throws IOException {
        byte[] header = new byte[96];
        int size = this.in.readFully(header, 0, 96);
        if (size < 96) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)9765, (Object)String.valueOf(size)));
        }
        this.startTime = System.currentTimeMillis();
        int magic = this.byteArrayToInt(header, 0);
        this.webtobQcount = this.byteArrayToInt(header, 20);
        this.webtobBodySize = this.byteArrayToInt(header, 84);
        this.webtobMessageType = this.byteArrayToInt(header, 16);
        this.webtobSequenceNumber = this.byteArrayToInt(header, 4);
        this.webtobClientId = this.byteArrayToInt(header, 24);
        this.webtobEtc = this.byteArrayToInt(header, 28);
        this.webtobSvciFlags = this.byteArrayToInt(header, 88);
        this.webtobSvciCd = this.byteArrayToInt(header, 92);
        this.contentLength = this.byteArrayToInt(header, 32);
        if (magic != 9999) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)9766, (Object[])new String[]{String.valueOf(magic)}));
        }
    }

    private int byteArrayToInt(byte[] array, int offset) {
        int ch1 = array[offset] >= 0 ? array[offset] : 256 + array[offset];
        int ch2 = array[offset + 1] >= 0 ? array[offset + 1] : 256 + array[offset + 1];
        int ch3 = array[offset + 2] >= 0 ? array[offset + 2] : 256 + array[offset + 2];
        int ch4 = array[offset + 3] >= 0 ? array[offset + 3] : 256 + array[offset + 3];
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public int getWebtobSequenceNumber() {
        return this.webtobSequenceNumber;
    }

    public int getWebtobClientId() {
        return this.webtobClientId;
    }

    public int getWebtobSvciFlags() {
        return this.webtobSvciFlags;
    }

    public int getWebtobEtc() {
        return this.webtobEtc;
    }

    public int getWebtobSvciCd() {
        return this.webtobSvciCd;
    }

    public TmaxHeader getTmaxHeader() {
        return this.tmaxHeader;
    }

    public final void clearPostData2() throws IOException {
        if (this.isHttpGW) {
            this.clearPostData();
        } else {
            if (this.body != null) {
                return;
            }
            this.getBody();
        }
    }

    public void clearing() {
        this.header = null;
        this.body = null;
        super.clearing();
    }

    public String getRequestInfo() {
        String servletName = "unknown";
        if (this.wrapper != null) {
            servletName = this.wrapper.getClassName();
        }
        return "request from " + this.getRemoteAddr() + ":" + this.getRemotePort() + ". servlet = " + servletName + ", hdrlen = " + this.headerLength + ", bodylen = " + this.contentLength;
    }
}

