/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jeus.util.SimpleLogDateFormat;

public class Logger {
    public static final String ERROR_LOG_DEFAULT_NAME = "error.log";
    public static final String ACCESS_LOG_DEFAULT_NAME = "access.log";
    public static final String USER_LOG_DEFAULT_NAME = "user.log";
    protected PrintWriter out;
    protected int bufferSize;
    protected boolean noBuffering = false;
    protected int logLevel = 3;
    protected SimpleLogDateFormat df = new SimpleLogDateFormat("[yyyy.MM.dd HH:mm:ss]");
    protected File logDir;
    protected String logFileName;
    protected String logFileNamePrefix;
    protected File logFile;
    private int validHours = -1;
    private int logsPerDaySuffix = -1;
    protected int validDays = -1;
    protected int lastCreatedDay;
    protected SimpleDateFormat fn = new SimpleDateFormat("MMddyyyy");
    protected boolean isConsoleOut = false;

    protected Logger(File file, int bsize) {
        if (file != null) {
            try {
                this.bufferSize = bsize;
                if (bsize == 0) {
                    this.noBuffering = true;
                }
                this.createLogStream(this.logFile.toString(), this.noBuffering, this.bufferSize);
            }
            catch (IOException ioe) {
                String msg = "Error: Getting Log file(" + this.logFile.toString() + "): " + ioe.getMessage();
                System.out.println(msg);
                ioe.printStackTrace();
                file = null;
            }
        }
        if (file == null) {
            this.validDays = -1;
            this.isConsoleOut = true;
            this.out = null;
            this.logFile = null;
        }
    }

    protected Logger(File file, String defaultDir, int bsize, int days) {
        this(file, defaultDir, bsize, days, 1);
    }

    protected Logger(File file, String defaultDir, int bsize, int days, int numLogs) {
        if (numLogs > 1) {
            days = 1;
        }
        if (file != null) {
            try {
                this.validDays = days;
                this.validHours = numLogs > 1 ? 24 / numLogs : -1;
                if (days > 0) {
                    String logDirPath = file.getParent() + System.getProperty("file.separator") + defaultDir;
                    this.logDir = new File(logDirPath);
                    this.logDir.mkdirs();
                    this.logFileName = file.getName();
                    Calendar cal = Calendar.getInstance();
                    String suffix = this.fn.format(cal.getTime());
                    int pos = this.logFileName.lastIndexOf(".");
                    this.logFileNamePrefix = pos < 0 ? this.logFileName : this.logFileName.substring(0, pos);
                    if (this.validHours > 0) {
                        int hours = cal.get(11);
                        this.logsPerDaySuffix = hours / this.validHours;
                        this.logFile = new File(this.logDir, this.logFileNamePrefix + "_" + suffix + "_" + this.logsPerDaySuffix + ".log");
                    } else {
                        this.logFile = new File(this.logDir, this.logFileNamePrefix + "_" + suffix + ".log");
                    }
                    this.lastCreatedDay = cal.get(6);
                } else {
                    this.logFile = file;
                }
                this.bufferSize = bsize;
                if (bsize == 0) {
                    this.noBuffering = true;
                }
                this.createLogStream(this.logFile.toString(), this.noBuffering, this.bufferSize);
            }
            catch (IOException ioe) {
                String msg = "Error: Getting Log file(" + this.logFile.toString() + "): " + ioe.getMessage();
                System.out.println(msg);
                ioe.printStackTrace();
                file = null;
            }
        }
        if (file == null) {
            this.validDays = -1;
            this.isConsoleOut = true;
            this.out = null;
            this.logFile = null;
        }
    }

    protected synchronized void createNewLogger() {
        File lastFile = this.logFile;
        try {
            this.out.close();
            Calendar cal = Calendar.getInstance();
            String suffix = this.fn.format(cal.getTime());
            if (this.validHours > 0) {
                int hours = cal.get(11);
                this.logsPerDaySuffix = hours / this.validHours;
                this.logFile = new File(this.logDir, this.logFileNamePrefix + "_" + suffix + "_" + this.logsPerDaySuffix + ".log");
            } else {
                this.logFile = new File(this.logDir, this.logFileNamePrefix + "_" + suffix + ".log");
            }
            this.lastCreatedDay = cal.get(6);
            this.createLogStream(this.logFile.toString(), this.noBuffering, this.bufferSize);
        }
        catch (IOException ioe) {
            String msg = "Error: Getting Log file(" + this.logFile.toString() + "): " + ioe.getMessage();
            System.out.println(msg);
            ioe.printStackTrace();
            try {
                this.createLogStream(lastFile.toString(), this.noBuffering, this.bufferSize);
            }
            catch (IOException ex) {
                this.out = null;
                this.isConsoleOut = true;
                this.validDays = -1;
            }
        }
    }

    protected void createLogStream(String fileName, boolean notBuffering, int bSize) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName, true);
        BufferedOutputStream bos = null;
        bos = notBuffering ? new BufferedOutputStream(fos) : new BufferedOutputStream(fos, bSize);
        this.out = new PrintWriter(bos, true);
    }

    private boolean invalidLogSuffix(Calendar cal) {
        if (this.validHours > 0) {
            int hour = cal.get(11);
            int newSuffix = hour / this.validHours;
            return newSuffix != this.logsPerDaySuffix;
        }
        return false;
    }

    private boolean invalidLogFile() {
        Calendar cal = Calendar.getInstance();
        int thisDay = cal.get(6);
        if (thisDay == this.lastCreatedDay) {
            return this.invalidLogSuffix(cal);
        }
        if (thisDay > this.lastCreatedDay) {
            if (thisDay - this.lastCreatedDay >= this.validDays) {
                return true;
            }
            return this.invalidLogSuffix(cal);
        }
        if (365 - this.lastCreatedDay + thisDay >= this.validDays) {
            return true;
        }
        return this.invalidLogSuffix(cal);
    }

    public void checkLogFile() {
        this.flush();
        if (this.validDays > 0 && this.invalidLogFile()) {
            this.createNewLogger();
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.logFile != null && this.out != null) {
            this.out.close();
        }
    }
}

