/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import jeus.servlet.util.NotAllowedAddressException;

public class SecureServerSocket
extends ServerSocket {
    private int port;
    private Vector filterList;

    public SecureServerSocket(int port, Vector addresses) throws IOException {
        super(port);
        this.port = port;
        this.filterList = addresses;
    }

    public Socket accept() throws IOException {
        Socket soc = null;
        InetAddress inetAddr = null;
        String addr = null;
        while (true) {
            try {
                soc = super.accept();
                inetAddr = soc.getInetAddress();
                addr = inetAddr.getHostAddress();
            }
            catch (IOException ioe) {
                continue;
            }
            break;
        }
        if (this.filterList.contains(addr)) {
            return soc;
        }
        byte[] elements = inetAddr.getAddress();
        int el1 = elements[0] < 0 ? 256 + elements[0] : elements[0];
        int el2 = elements[1] < 0 ? 256 + elements[1] : elements[1];
        int el3 = elements[2] < 0 ? 256 + elements[2] : elements[2];
        String part1 = String.valueOf(el1);
        String part2 = String.valueOf(el2);
        String part3 = String.valueOf(el3);
        StringBuffer netAddr = new StringBuffer(part1);
        netAddr.append(".").append(part2).append(".").append(part3).append(".*");
        addr = netAddr.toString();
        if (this.filterList.contains(addr)) {
            return soc;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".").append(part2).append(".*.*");
        addr = netAddr.toString();
        if (this.filterList.contains(addr)) {
            return soc;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".*.*.*");
        addr = netAddr.toString();
        if (this.filterList.contains(addr)) {
            return soc;
        }
        try {
            soc.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        addr = inetAddr.getHostAddress();
        throw new NotAllowedAddressException(addr);
    }
}

