/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.util.Logger;

public class UserLogger
extends Logger {
    public UserLogger(File file, int bsize) {
        super(file, bsize);
    }

    public UserLogger(File file, int bsize, int days) {
        super(file, "userlog", bsize, days);
    }

    public UserLogger(File file, int bsize, int days, int numLogs) {
        super(file, "userlog", bsize, days, numLogs);
    }

    public void log(String msg) {
        Date d = new Date();
        String date = null;
        Thread t = Thread.currentThread();
        if (t instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)t;
            date = this.df.format(d) + "[t" + rp.getThreadId() + "] ";
        } else {
            date = this.df.format(d);
        }
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + msg);
        } else {
            this.out.println(date + msg);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String step, String msg) {
        Date d = new Date();
        String date = null;
        Thread t = Thread.currentThread();
        if (t instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)Thread.currentThread();
            date = this.df.format(d) + "[t" + rp.getThreadId() + "] ";
        } else {
            date = this.df.format(d);
        }
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + "[" + step + "]" + msg);
        } else {
            this.out.println(date + "[" + step + "]" + msg);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String msg, Throwable e) {
        Date d = new Date();
        String date = null;
        Thread t = Thread.currentThread();
        if (t instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)Thread.currentThread();
            date = this.df.format(d) + "[t" + rp.getThreadId() + "] ";
        } else {
            date = this.df.format(d);
        }
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + msg, e);
        } else {
            this.out.println(date + msg);
            e.printStackTrace(this.out);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String step, String msg, Throwable e) {
        Date d = new Date();
        String date = null;
        Thread t = Thread.currentThread();
        if (t instanceof RequestProcessor) {
            RequestProcessor rp = (RequestProcessor)Thread.currentThread();
            date = this.df.format(d) + "[t" + rp.getThreadId() + "] ";
        } else {
            date = this.df.format(d);
        }
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + "[" + step + "]" + msg, e);
        } else {
            this.out.println(date + "[" + step + "]" + msg);
            e.printStackTrace(this.out);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String title, Vector msgs) {
        Date d = new Date();
        String date = this.df.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + "[" + title + "]");
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo info = (ThreadStateInfo)msgs.elementAt(i);
                jeus.util.Logger.directLog(info.toString());
            }
            jeus.util.Logger.directLog(" ");
        } else {
            this.out.println(date + "[" + title + "]");
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo info = (ThreadStateInfo)msgs.elementAt(i);
                this.out.println(info.toString());
            }
            this.out.println();
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }
}

