/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util2.res;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private Locale locale;
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        this(packageName, Locale.getDefault());
    }

    private StringManager(String packageName, Locale loc) {
        String bundleName = packageName + ".LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName, loc);
        this.locale = this.bundle.getLocale();
    }

    private StringManager(ResourceBundle bundle) {
        this.bundle = bundle;
        this.locale = bundle.getLocale();
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        String str = null;
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public String getString(String key, Object[] args) {
        String iString = null;
        String value = this.getString(key);
        try {
            if (args == null) {
                args = new Object[1];
            }
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            if (value == null) {
                value = key;
            }
            MessageFormat mf = new MessageFormat(value);
            mf.setLocale(this.locale);
            iString = mf.format(nonNullArgs, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(ResourceBundle bundle) {
        return new StringManager(bundle);
    }

    public static synchronized StringManager getManager(String packageName, Locale loc) {
        StringManager mgr = (StringManager)managers.get(packageName + "_" + loc.toString());
        if (mgr == null) {
            mgr = new StringManager(packageName, loc);
            managers.put(packageName + "_" + loc.toString(), mgr);
        }
        return mgr;
    }
}

