/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.Invocation;
import jeus.sessionmanager.LifeCycleSupport;
import jeus.sessionmanager.Router;
import jeus.sessionmanager.SessionActivationListener;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionFactory;
import jeus.sessionmanager.SessionListener;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.SessionMonitoring;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SecureSessionIdGenerator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session4;

public abstract class AbstractSessionManager
extends LifeCycleSupport
implements SessionManager,
SessionListener,
SessionActivationListener,
SessionMonitoring {
    protected static final JeusLogger logger = Constants.SESSION_LOGGER;
    protected ConcurrentHashMap sessions = new ConcurrentHashMap();
    protected J2EEManagedObject sessionManagedObject;
    protected SessionConfig config;
    protected SessionFactory sessionFactory;
    protected AtomicBoolean scavengeFlag;
    protected long scavengeTimeStamp;
    private int maxInactiveInterval = Integer.MAX_VALUE;
    private String name;

    public AbstractSessionManager(SessionFactory sessionFactory, SessionConfig config) {
        this.sessionFactory = sessionFactory;
        this.config = config;
        this.config.setManager(this);
        this.scavengeFlag = new AtomicBoolean(false);
    }

    public void doStart() throws Exception {
        this.scavengeTimeStamp = -1L;
    }

    public void doStop() throws Exception {
        this.sessions.clear();
        this.scavengeTimeStamp = -1L;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int secondsInterval) {
        this.maxInactiveInterval = secondsInterval;
    }

    public Session createSession() {
        return this.createSession(null, null);
    }

    public Session createSession(String sessionId) {
        return this.createSession(sessionId, null);
    }

    public Session createSession(Object param) {
        return this.createSession(null, param);
    }

    public Session createSession(String sessionId, Object param) {
        Session session = this.sessionFactory.createSession(this.config, param);
        if (sessionId == null) {
            sessionId = SecureSessionIdGenerator.generateId();
        }
        long currentTime = System.currentTimeMillis();
        session.initialize(sessionId);
        session.initialize(currentTime, currentTime, currentTime, this.maxInactiveInterval);
        session.setNeedUpdate(true);
        this.notifySessionCreation(session);
        if (logger.isLoggable(JeusMessage_Session4._49002_LEVEL)) {
            logger.log(JeusMessage_Session4._49002_LEVEL, JeusMessage_Session4._49002, (Object[])new String[]{this.getInfo(), session.getId()});
        }
        return session;
    }

    public void destroy(Session session) {
        block3: {
            try {
                this.notifySessionDestruction(session);
                session.destroy();
                if (logger.isLoggable(JeusMessage_Session4._49003_LEVEL)) {
                    logger.log(JeusMessage_Session4._49003_LEVEL, JeusMessage_Session4._49003, (Object[])new String[]{this.getInfo(), session.getId()});
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session4._49010_LEVEL)) break block3;
                logger.log(JeusMessage_Session4._49010_LEVEL, JeusMessage_Session4._49010, (Object)this.getInfo(), (Throwable)e);
            }
        }
    }

    public void passivate() {
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            this.passivate((Session)i.next());
        }
    }

    public void reroute(Invocation invocation) {
        this.config.getRouter().reroute(invocation);
    }

    public void backupLocalSessions(boolean removeSession) {
        if (removeSession) {
            this.sessions.clear();
            return;
        }
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            ((Session)i.next()).backupSessions();
        }
    }

    public Router getRouter() {
        return this.config.getRouter();
    }

    public SessionConfig getSessionConfig() {
        return this.config;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void notifySessionCreation(Session session) {
        SessionListener listenerSupport = session.getPostCreationListenerSupport();
        if (listenerSupport != null) {
            listenerSupport.notifySessionCreation(session);
        }
    }

    public void notifySessionDestruction(Session session) {
        SessionListener listenerSupport = session.getPreDestructionListenerSupport();
        if (listenerSupport != null) {
            listenerSupport.notifySessionDestruction(session);
        }
    }

    public void notifySessionActivation(Session session) {
        SessionActivationListener listenerSupport = session.getPostActivationListenerSupport();
        if (listenerSupport != null) {
            listenerSupport.notifySessionActivation(session);
        }
    }

    public void notifySessionPassivation(Session session) {
        SessionActivationListener listenerSupport = session.getPrePassivationListenerSupport();
        if (listenerSupport != null) {
            listenerSupport.notifySessionPassivation(session);
        }
    }

    public void destroyMBean() {
        if (this.sessionManagedObject != null) {
            this.sessionManagedObject.destroyMBean();
            this.sessionManagedObject = null;
        }
    }

    protected boolean validate(Session session) {
        if (session == null) {
            return false;
        }
        if (!session.validate()) {
            this.destroy(session);
            return false;
        }
        return true;
    }

    protected void passivate(Session session) {
        if (logger.isLoggable(JeusMessage_Session4._49004_LEVEL)) {
            logger.log(JeusMessage_Session4._49004_LEVEL, JeusMessage_Session4._49004, (Object[])new String[]{this.getInfo(), session.getId()});
        }
        this.notifySessionPassivation(session);
    }

    protected void scavenge() {
        int total = this.sessions.size();
        int invalid = 0;
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            if (this.validate((Session)i.next())) continue;
            ++invalid;
        }
        if (invalid > 0) {
            int valid = total - invalid;
            if (logger.isLoggable(JeusMessage_Session4._49001_LEVEL)) {
                logger.log(JeusMessage_Session4._49001_LEVEL, JeusMessage_Session4._49001, (Object[])new String[]{this.getInfo(), String.valueOf(total), String.valueOf(valid), String.valueOf(invalid)});
            }
        }
    }

    protected String getInfo() {
        return this + " [" + this.name + "]";
    }
}

