/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import jeus.sessionmanager.Constants;
import jeus.sessionmanager.LifeCycle;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session4;

public abstract class LifeCycleSupport
implements LifeCycle {
    private static final JeusLogger logger = Constants.SESSION_LOGGER;
    private volatile transient int state = 0;

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    public final synchronized void start() throws Throwable {
        try {
            if (this.state == 2) {
                return;
            }
            this.state = 1;
            this.doStart();
            if (logger.isLoggable(JeusMessage_Session4._49006_LEVEL)) {
                logger.log(JeusMessage_Session4._49006_LEVEL, JeusMessage_Session4._49006, (Object)this);
            }
            this.state = 2;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Session4._49007_LEVEL)) {
                logger.log(JeusMessage_Session4._49007_LEVEL, JeusMessage_Session4._49007, (Object)this);
            }
            this.state = -1;
            throw t;
        }
    }

    public final synchronized void stop() throws Throwable {
        try {
            if (this.state < 1) {
                return;
            }
            this.state = 3;
            this.doStop();
            if (logger.isLoggable(JeusMessage_Session4._49008_LEVEL)) {
                logger.log(JeusMessage_Session4._49008_LEVEL, JeusMessage_Session4._49008, (Object)this);
            }
            this.state = 0;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Session4._49009_LEVEL)) {
                logger.log(JeusMessage_Session4._49009_LEVEL, JeusMessage_Session4._49009, (Object)this);
            }
            this.state = -1;
            throw t;
        }
    }

    public boolean isRunning() {
        return this.state == 2 || this.state == 1;
    }

    public boolean isStarted() {
        return this.state == 2;
    }

    public boolean isStarting() {
        return this.state == 1;
    }

    public boolean isStopping() {
        return this.state == 3;
    }

    public boolean isFailed() {
        return this.state == -1;
    }
}

