/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import jeus.sessionmanager.AbstractSessionManager;
import jeus.sessionmanager.LifeCycle;
import jeus.sessionmanager.ManagerConfig;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionFactory;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.SessionMonitoring;
import jeus.sessionmanager.StandardSessionManager;
import jeus.sessionmanager.central.CentralManagerConfig;
import jeus.sessionmanager.central.CentralSessionManager;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.distributed.LightSessionManager;
import jeus.sessionmanager.util.AbstractGlobalObjectFactory;

public class SessionManagerFactory
extends AbstractGlobalObjectFactory {
    public static final int STANDARD_SESSION_MANAGER_TYPE = 1;
    public static final int CENTRAL_SESSION_MANAGER_TYPE = 2;
    public static final int DISTRIBUTED_SESSION_MANAGER_TYPE = 3;
    public static final int LIGHT_SESSION_MANAGER_TYPE = 4;
    private static final SessionManagerFactory MANAGER_FACTORY_SINGLETON = new SessionManagerFactory();

    public static SessionManager createSessionManager(SessionFactory factory, SessionConfig sessionConfig, ManagerConfig managerConfig, int type) {
        return SessionManagerFactory.createSessionManager(null, factory, sessionConfig, managerConfig, type);
    }

    public static SessionManager createSessionManager(String scope, SessionFactory factory, SessionConfig sessionConfig, ManagerConfig managerConfig, int type) {
        return (SessionManager)MANAGER_FACTORY_SINGLETON.createObject(scope, factory, sessionConfig, managerConfig, new Integer(type));
    }

    public static void destroySessionManager(String scope) {
        MANAGER_FACTORY_SINGLETON.destroyObject(scope);
    }

    public static void destroy() {
        MANAGER_FACTORY_SINGLETON.destroyAll();
    }

    protected Object allocateObject(Object[] params) {
        int type;
        ManagerConfig managerConfig;
        SessionConfig sessionConfig;
        SessionFactory factory;
        if (params == null) {
            return null;
        }
        if (params.length != 4) {
            return null;
        }
        try {
            factory = (SessionFactory)params[0];
            sessionConfig = (SessionConfig)params[1];
            managerConfig = (ManagerConfig)params[2];
            Integer intType = (Integer)params[3];
            type = intType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        AbstractSessionManager manager = null;
        switch (type) {
            case 1: {
                manager = new StandardSessionManager(factory, sessionConfig);
                break;
            }
            case 2: {
                if (!(managerConfig instanceof CentralManagerConfig)) break;
                manager = new CentralSessionManager(factory, sessionConfig, (CentralManagerConfig)managerConfig);
            }
            case 3: {
                if (!(managerConfig instanceof DistributedManagerConfig)) break;
                manager = new DistributedSessionManager(factory, sessionConfig, (DistributedManagerConfig)managerConfig);
                break;
            }
            case 4: {
                if (!(managerConfig instanceof DistributedManagerConfig)) break;
                manager = new LightSessionManager(factory, sessionConfig, (DistributedManagerConfig)managerConfig);
                break;
            }
        }
        return manager;
    }

    protected void destroyObject(Object object) {
        if (object == null) {
            return;
        }
        try {
            ((SessionMonitoring)object).destroyMBean();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ((LifeCycle)object).stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

