/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.j2ee.servlet.SessionContainerMo;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.servlet.common.SessionInfo;
import jeus.sessionmanager.AbstractSessionManager;
import jeus.sessionmanager.ManagerConfig;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionFactory;
import jeus.sessionmanager.session.Session;
import jeus.util.message.JeusMessage_Session4;

public class StandardSessionManager
extends AbstractSessionManager {
    public StandardSessionManager(SessionFactory sessionFactory, SessionConfig config) {
        super(sessionFactory, config);
        this.setName("LocalMemory");
    }

    public void doStop() throws Exception {
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            this.destroy((Session)i.next());
        }
        super.doStop();
    }

    public Session createSession(String sessionId, Object param) {
        Session session = super.createSession(sessionId, param);
        this.sessions.put(session.getInternalId(), session);
        return session;
    }

    public void destroy(Session session) {
        if (session == null) {
            return;
        }
        this.sessions.remove(session.getInternalId());
        super.destroy(session);
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        Session session = (Session)this.sessions.get(this.config.getRouter().strip(sessionId));
        if (!this.validate(session)) {
            return null;
        }
        return session;
    }

    public void updateSession(Session session, boolean synchronousSending) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge(long timeStamp) {
        if (!this.scavengeFlag.compareAndSet(false, true)) {
            return;
        }
        if (this.scavengeTimeStamp == timeStamp) {
            return;
        }
        try {
            this.scavenge();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.scavengeTimeStamp = timeStamp;
            this.scavengeFlag.compareAndSet(true, false);
        }
    }

    public ManagerConfig getManagerConfig() {
        return null;
    }

    public SessionInfo getSessionInfo() {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setLocalSessionSize(this.sessions.size());
        return sessionInfo;
    }

    public int getAllSessionsSize() {
        return this.sessions.size();
    }

    public int getActiveSessionsSize() {
        return this.getAllSessionsSize();
    }

    public int getPassivateSessionsSize() {
        return 0;
    }

    public int getLocalSessionsSize() {
        return this.getAllSessionsSize();
    }

    public void createMBean(ObjectName parent, String exportName) {
        block3: {
            if (this.sessionManagedObject == null) {
                try {
                    this.sessionManagedObject = SessionContainerMo.createMBean(exportName, parent, this);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (!logger.isLoggable(JeusMessage_Session4._47804_LEVEL)) break block3;
                    logger.log(JeusMessage_Session4._47804_LEVEL, JeusMessage_Session4._47804, (Object[])new String[]{this.getInfo(), exportName}, (Throwable)e);
                }
            }
        }
    }

    public Stats updateStats(SessionContainerStatsImpl stats) {
        int active_size = this.getActiveSessionsSize();
        ((CountStatisticImpl)stats.getLocalSessionCount()).setValue((long)active_size);
        return stats;
    }

    public boolean isExist(String key) {
        if (key == null) {
            return false;
        }
        Session session = (Session)this.sessions.get(this.config.getRouter().strip(key));
        return session != null;
    }

    public ArrayList getLocalSessionKeys() {
        return new ArrayList(this.sessions.keySet());
    }

    public boolean invalidateSession(String id) {
        if (id == null) {
            return false;
        }
        Session session = (Session)this.sessions.get(this.config.getRouter().strip(id));
        if (session == null) {
            return false;
        }
        this.destroy(session);
        return true;
    }

    public void passivate(Session session) {
        if (session == null) {
            return;
        }
        super.passivate(session);
        this.sessions.remove(session.getInternalId());
    }

    public String toString() {
        return "S-SessionManager@" + Integer.toHexString(this.hashCode());
    }
}

