/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.j2ee.servlet.CentralSessionServerInfoImpl;
import jeus.management.j2ee.servlet.CurrentSessionServerInfo;
import jeus.management.j2ee.servlet.SessionContainerCentralMo;
import jeus.management.j2ee.servlet.SessionContainerCentralStatsImpl;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.servlet.common.SessionInfo;
import jeus.sessionmanager.AbstractSessionManager;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.ManagerConfig;
import jeus.sessionmanager.Router;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionFactory;
import jeus.sessionmanager.central.CentralManagerConfig;
import jeus.sessionmanager.central.CentralSessionMonitoring;
import jeus.sessionmanager.central.CentralSessionServerInfo;
import jeus.sessionmanager.central.SessionServerConnector;
import jeus.sessionmanager.session.CentralSession;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session2;
import jeus.util.message.JeusMessage_Session4;

public class CentralSessionManager
extends AbstractSessionManager
implements CentralSessionMonitoring {
    private SessionServerConnector connector;
    private String serverName;
    private String backupServerName;
    private long connectTimeout;
    private long readTimeout;
    private CentralManagerConfig centralManagerConfig;

    public CentralSessionManager(SessionFactory sessionFactory, SessionConfig config, CentralManagerConfig centralManagerConfig) {
        super(sessionFactory, config);
        this.centralManagerConfig = centralManagerConfig;
        this.serverName = centralManagerConfig.getServerName();
        this.backupServerName = centralManagerConfig.getBackupName();
        this.connectTimeout = centralManagerConfig.getConnectTimeout();
        this.readTimeout = centralManagerConfig.getReplyTimeout();
        this.setName(this.serverName);
    }

    public void doStart() throws Exception {
        block3: {
            super.doStart();
            if (this.connector == null) {
                this.connector = new SessionServerConnector("", this.serverName);
                try {
                    this.connector.initialize(this.connectTimeout, this.readTimeout);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_Session2._27755_LEVEL)) break block3;
                    logger.log(JeusMessage_Session2._27755_LEVEL, JeusMessage_Session2._27755, (Object[])new String[]{this.getInfo(), this.serverName}, (Throwable)e);
                }
            }
        }
    }

    public void doStop() throws Exception {
        if (this.connector != null) {
            this.connector.destroy();
            this.connector = null;
        }
        try {
            this.passivate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.doStop();
    }

    public Session createSession(String sessionId, Object param) {
        Session session = super.createSession(sessionId, param);
        if (!(session instanceof CentralSession)) {
            if (logger.isLoggable(JeusMessage_Session2._29001_LEVEL)) {
                logger.log(JeusMessage_Session2._29001_LEVEL, JeusMessage_Session2._29001, new Object[]{this.getInfo(), this.connector.getServerName(), session});
            }
            return null;
        }
        CentralSession centralSession = (CentralSession)session;
        centralSession.setUniqueCreation(true);
        centralSession.setCheckModified(this.centralManagerConfig.getCheckLevelInt() == 1);
        if (this.config.getRouter().isStickySession()) {
            this.sessions.put(centralSession.getInternalId(), centralSession);
        }
        return centralSession;
    }

    public void destroy(Session session) {
        if (session == null) {
            return;
        }
        String internalId = session.getInternalId();
        if (this.config.getRouter().isStickySession()) {
            this.sessions.remove(internalId);
        }
        this.destroyFromServer(internalId);
        super.destroy(session);
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        Router router = this.config.getRouter();
        String internalId = router.strip(sessionId);
        Session localSession = null;
        Session remoteSession = null;
        Session session = null;
        if (router.isStickySession() && (localSession = (Session)this.sessions.get(internalId)) != null && router.isRoutingIdMatched(sessionId)) {
            session = localSession;
            if (this.validate(session)) {
                return session;
            }
            return null;
        }
        remoteSession = this.getSessionFromServer(internalId);
        session = this.selectLastSession(localSession, remoteSession);
        if (session == null) {
            return null;
        }
        if (!this.validate(session)) {
            return null;
        }
        if (router.isStickySession()) {
            this.sessions.put(internalId, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(Session session, boolean synchronousSending) throws Exception {
        if (!(session instanceof CentralSession) || session.isExpired()) {
            return;
        }
        int checkLevel = this.centralManagerConfig.getCheckLevelInt();
        if (checkLevel == 2) {
            session.setNeedUpdate(true);
        }
        if (!session.isNeedUpdate() && checkLevel != 1) {
            return;
        }
        SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)Constants.SESSION_OUTPUT_STREAM.get();
        sbaos.reset();
        session.getWriteLock().lock();
        try {
            session.writeSession(sbaos);
        }
        finally {
            session.getWriteLock().unlock();
        }
        if (session.isNeedUpdate()) {
            if (!this.config.getRouter().isStickySession()) {
                this.notifySessionPassivation(session);
            }
            this.updateSessionToServer((CentralSession)session, sbaos);
            session.setNeedUpdate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge(long timeStamp) {
        if (!this.scavengeFlag.compareAndSet(false, true)) {
            return;
        }
        if (this.scavengeTimeStamp == timeStamp) {
            return;
        }
        try {
            this.scavenge();
            this.checkServer();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.scavengeTimeStamp = timeStamp;
            this.scavengeFlag.compareAndSet(true, false);
        }
    }

    public ManagerConfig getManagerConfig() {
        return this.centralManagerConfig;
    }

    public SessionInfo getSessionInfo() {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setVersion(2);
        sessionInfo.setLocalSessionSize(this.sessions.size());
        int remoteActive = this.getActiveSessionsSize();
        int remotePassive = this.getPassivateSessionsSize();
        sessionInfo.setRemoteActiveSessionSize(remoteActive);
        sessionInfo.setRemotePassivatedSessionSize(remotePassive);
        sessionInfo.setRemoteSessionSize(remoteActive + remotePassive);
        sessionInfo.setServerName(this.serverName);
        sessionInfo.setBackupServerName(this.backupServerName);
        if (this.isStarted()) {
            sessionInfo.setCurrentServerName(this.connector.getServerName());
            sessionInfo.setServerStatus(this.connector.checkConnector());
            int connections = this.connector.getCurrentConnections();
            sessionInfo.setTotalConnections(connections);
            sessionInfo.setUsedConnections(connections);
        }
        return sessionInfo;
    }

    public int getAllSessionsSize() {
        if (!this.isStarted()) {
            return -1;
        }
        String connectorName = this.connector.getServerName();
        int connectorId = this.connector.getConnectorId();
        try {
            return this.connector.getAllSessionsSize();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session2._27760_LEVEL)) {
                logger.log(JeusMessage_Session2._27760_LEVEL, JeusMessage_Session2._27760, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
            }
            this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
            try {
                return this.connector.getAllSessionsSize();
            }
            catch (Exception e1) {
                return -1;
            }
        }
    }

    public int getActiveSessionsSize() {
        if (!this.isStarted()) {
            return -1;
        }
        String connectorName = this.connector.getServerName();
        int connectorId = this.connector.getConnectorId();
        try {
            return this.connector.getActiveSessionsSize();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session2._27760_LEVEL)) {
                logger.log(JeusMessage_Session2._27760_LEVEL, JeusMessage_Session2._27760, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
            }
            this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
            try {
                return this.connector.getActiveSessionsSize();
            }
            catch (Exception e1) {
                return -1;
            }
        }
    }

    public int getPassivateSessionsSize() {
        if (!this.isStarted()) {
            return -1;
        }
        String connectorName = this.connector.getServerName();
        int connectorId = this.connector.getConnectorId();
        try {
            return this.connector.getPassivateSessionsSize();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session2._27760_LEVEL)) {
                logger.log(JeusMessage_Session2._27760_LEVEL, JeusMessage_Session2._27760, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
            }
            this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
            try {
                return this.connector.getPassivateSessionsSize();
            }
            catch (Exception e1) {
                return -1;
            }
        }
    }

    public int getLocalSessionsSize() {
        return this.sessions.size();
    }

    public void createMBean(ObjectName parent, String exportName) {
        block3: {
            if (this.sessionManagedObject == null) {
                try {
                    this.sessionManagedObject = SessionContainerCentralMo.createMBean("Centralized_Session_Server-" + this.serverName, parent, this);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (!logger.isLoggable(JeusMessage_Session2._27804_LEVEL)) break block3;
                    logger.log(JeusMessage_Session2._27804_LEVEL, JeusMessage_Session2._27804, (Object[])new String[]{this.getInfo(), exportName}, (Throwable)e);
                }
            }
        }
    }

    public Stats updateStats(SessionContainerStatsImpl stats) {
        if (!(stats instanceof SessionContainerCentralStatsImpl)) {
            return new SessionContainerCentralStatsImpl();
        }
        SessionContainerCentralStatsImpl centralStats = (SessionContainerCentralStatsImpl)stats;
        ((CountStatisticImpl)centralStats.getLocalSessionCount()).setValue((long)this.sessions.size());
        ((CountStatisticImpl)centralStats.getRemoteActiveSessionCount()).setValue((long)this.getActiveSessionsSize());
        ((CountStatisticImpl)centralStats.getRemotePassivatedSessionCount()).setValue((long)this.getPassivateSessionsSize());
        if (this.isStarted()) {
            int connections = this.connector.getCurrentConnections();
            ((CountStatisticImpl)centralStats.getTotalConnectionCount()).setValue((long)connections);
            ((CountStatisticImpl)centralStats.getInuseConnectionCount()).setValue((long)connections);
        }
        return stats;
    }

    public boolean isExist(String key) {
        if (key == null) {
            return false;
        }
        Router router = this.config.getRouter();
        String internalSessionID = router.strip(key);
        return this.sessions.get(internalSessionID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getLocalSessionKeys() {
        ConcurrentHashMap concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            return new ArrayList(this.sessions.keySet());
        }
    }

    public boolean invalidateSession(String id) {
        if (id == null) {
            return false;
        }
        Router router = this.config.getRouter();
        String internalSessionID = router.strip(id);
        Session session = (Session)this.sessions.get(internalSessionID);
        if (session == null) {
            return false;
        }
        this.destroy(session);
        return true;
    }

    public CentralSessionServerInfo getServerInfo() {
        CentralSessionServerInfoImpl info = new CentralSessionServerInfoImpl();
        info.setPrimaryServerName(this.serverName);
        info.setBackupServerName(this.backupServerName);
        CurrentSessionServerInfo cinfo = new CurrentSessionServerInfo();
        if (this.isStarted()) {
            cinfo.setCurrentServerName(this.connector.getServerName());
            cinfo.setServerStatus(this.connector.checkConnector());
        }
        cinfo.setRemoteActiveSessionSize(this.getActiveSessionsSize());
        cinfo.setRemotePassivatedSessionSize(this.getPassivateSessionsSize());
        info.addCurrentServerInfo(cinfo);
        return info;
    }

    public static boolean checkModified(SessionByteArrayOutputStream sbaos, byte[] storedBytes) {
        if (sbaos == null || storedBytes == null) {
            return false;
        }
        int count = sbaos.getCount();
        byte[] buf = sbaos.getByteArray();
        if (storedBytes.length == count) {
            boolean equals = true;
            for (int i = 16; i < count; ++i) {
                if (storedBytes[i] == buf[i]) continue;
                equals = false;
                break;
            }
            return equals;
        }
        return false;
    }

    public void passivate(Session session) {
        if (session == null) {
            return;
        }
        super.passivate(session);
        if (this.config.getRouter().isStickySession()) {
            this.sessions.remove(session.getInternalId());
        }
    }

    public String toString() {
        return "C-SessionManager@" + Integer.toHexString(this.hashCode());
    }

    private Session getSessionFromServer(String internalId) {
        byte[] result;
        block11: {
            if (!this.isStarted()) {
                return null;
            }
            result = null;
            String connectorName = this.connector.getServerName();
            int connectorId = this.connector.getConnectorId();
            try {
                result = this.connector.getSession(internalId);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session2._27760_LEVEL)) {
                    logger.log(JeusMessage_Session2._27760_LEVEL, JeusMessage_Session2._27760, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
                }
                this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
                try {
                    result = this.connector.getSession(internalId);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_Session2._29002_LEVEL)) break block11;
                    logger.log(JeusMessage_Session2._29002_LEVEL, JeusMessage_Session2._29002, (Object[])new String[]{this.getInfo(), this.connector.getServerName(), internalId}, (Throwable)ex);
                }
            }
        }
        if (result == null) {
            return null;
        }
        CentralSession session = this.createCentralSessionType();
        if (session == null) {
            return null;
        }
        session.initialize(internalId);
        try {
            session.readSession(result);
        }
        catch (Exception e) {
            return null;
        }
        this.notifySessionActivation(session);
        if (logger.isLoggable(JeusMessage_Session4._49005_LEVEL)) {
            logger.log(JeusMessage_Session4._49005_LEVEL, JeusMessage_Session4._49005, (Object[])new String[]{this.getInfo(), session.getId()});
        }
        return session;
    }

    private void destroyFromServer(String internalId) {
        block6: {
            if (!this.isStarted()) {
                return;
            }
            String connectorName = this.connector.getServerName();
            int connectorId = this.connector.getConnectorId();
            try {
                this.connector.removeSession(internalId);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session2._27762_LEVEL)) {
                    logger.log(JeusMessage_Session2._27762_LEVEL, JeusMessage_Session2._27762, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
                }
                this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
                try {
                    this.connector.removeSession(internalId);
                }
                catch (Exception e1) {
                    if (!logger.isLoggable(JeusMessage_Session2._29003_LEVEL)) break block6;
                    logger.log(JeusMessage_Session2._29003_LEVEL, JeusMessage_Session2._29003, (Object[])new String[]{this.getInfo(), this.connector.getServerName(), internalId}, (Throwable)e1);
                }
            }
        }
    }

    private void updateSessionToServer(CentralSession session, SessionByteArrayOutputStream sbaos) throws Exception {
        if (!this.isStarted()) {
            return;
        }
        if (logger.isLoggable(JeusMessage_Session2._28001_LEVEL)) {
            logger.log(JeusMessage_Session2._28001_LEVEL, JeusMessage_Session2._28001, new Object[]{this.getInfo(), session.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
        }
        String connectorName = this.connector.getServerName();
        int connectorId = this.connector.getConnectorId();
        try {
            if (session.isUniqueCreation()) {
                this.connector.addNewSession(session.getInternalId(), sbaos.getByteArray());
                session.setUniqueCreation(false);
            } else {
                this.connector.addSession(session.getInternalId(), sbaos.getByteArray());
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session2._27758_LEVEL)) {
                logger.log(JeusMessage_Session2._27758_LEVEL, JeusMessage_Session2._27758, (Object[])new String[]{this.getInfo(), connectorName}, (Throwable)e);
            }
            this.connector.takeover(this.serverName, this.backupServerName, connectorId, "communication error", e, this.connectTimeout, this.readTimeout);
            try {
                if (logger.isLoggable(JeusMessage_Session2._28001_LEVEL)) {
                    logger.log(JeusMessage_Session2._28001_LEVEL, JeusMessage_Session2._28001, new Object[]{this.getInfo(), session.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
                }
                if (session.isUniqueCreation()) {
                    this.connector.addNewSession(session.getInternalId(), sbaos.getByteArray());
                    session.setUniqueCreation(false);
                } else {
                    this.connector.addSession(session.getInternalId(), sbaos.getByteArray());
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(JeusMessage_Session2._29004_LEVEL)) {
                    logger.log(JeusMessage_Session2._29004_LEVEL, JeusMessage_Session2._29004, (Object[])new String[]{this.getInfo(), this.connector.getServerName(), session.getInternalId()}, (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    private void checkServer() {
        if (!this.isStarted()) {
            return;
        }
        String currentServerName = this.connector.getServerName();
        boolean alive = this.connector.checkConnector();
        if (logger.isLoggable(JeusMessage_Session2._27763_LEVEL)) {
            logger.log(JeusMessage_Session2._27763_LEVEL, JeusMessage_Session2._27763, (Object[])new String[]{this.getInfo(), currentServerName, String.valueOf(alive)});
        }
        if (!this.serverName.equals(this.connector.getServerName())) {
            if (logger.isLoggable(JeusMessage_Session2._27765_LEVEL)) {
                logger.log(JeusMessage_Session2._27765_LEVEL, JeusMessage_Session2._27765, (Object[])new String[]{this.getInfo(), this.serverName});
            }
            if (this.connector.checkReady(this.serverName, this.connectTimeout, this.readTimeout)) {
                if (logger.isLoggable(JeusMessage_Session2._27766_LEVEL)) {
                    logger.log(JeusMessage_Session2._27766_LEVEL, JeusMessage_Session2._27766, (Object[])new String[]{this.getInfo(), this.serverName});
                }
                this.connector.takeover(this.serverName, true, "main server is booted up", this.connectTimeout, this.readTimeout);
                return;
            }
        }
        if (!alive) {
            this.connector.takeover(this.backupServerName, true, "main server is down", this.connectTimeout, this.readTimeout);
        }
    }

    private CentralSession createCentralSessionType() {
        Session session = this.sessionFactory.createSession(this.config, null);
        if (!(session instanceof CentralSession)) {
            return null;
        }
        return (CentralSession)session;
    }

    private Session selectLastSession(Session session1, Session session2) {
        if (session1 == null) {
            return session2;
        }
        if (session2 == null) {
            return session1;
        }
        if (session1.getThisAccessedTime() >= session2.getThisAccessedTime()) {
            return session1;
        }
        return session2;
    }
}

