/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.j2ee.statistics.Stats;
import jeus.descriptor.jeusserver.SessionServerDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.server.service.SessionManagerMo;
import jeus.server.service.SessionManagerStatsImpl;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.BackupThread;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.SessionManagerClient;
import jeus.sessionmanager.central.SessionServerException;
import jeus.sessionmanager.central.SessionStatistic;
import jeus.sessionmanager.central.SessionStorage;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusPort;
import jeus.util.cnet.NetUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public abstract class SessionManager {
    protected static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private static final int INIT_CAPACITY = 1000;
    protected SessionServerDescriptor desc;
    protected long checkTo;
    protected SessionStorage storage;
    protected Hashtable sessions;
    protected BackupThread backupThread = null;
    protected Hashtable entryBuffer;
    protected int backupTrigger;
    protected boolean buffering = false;
    protected int buffered = 0;
    protected final Object countSync = new Object();
    protected boolean ready = false;
    protected boolean recovered = false;
    protected long connectionTimeout;
    protected long replyWaitTimeout;
    protected SessionStatistic sessionStat;
    private final Object sync2 = new Object();
    private final Object sync3 = new Object();
    private long passivationTO;
    private long removalTO;
    private SessionManagerMo mbean;
    private Object checkingMemoryLock = new Object();
    private Object[] sortedEntries = new Object[0];
    private double passivationRatio;
    private long memoryMaxBytes;
    private boolean gcForcefully;

    public SessionManager(SessionServerDescriptor desc) throws SessionServerException {
        String serverName = null;
        try {
            String fileDbName;
            if (desc == null) {
                throw new SessionServerException("SessionServerDescriptor must be initialized");
            }
            this.desc = desc;
            serverName = desc.getServerName();
            this.connectionTimeout = desc.getConnectTimeout();
            this.replyWaitTimeout = desc.getReadTimeout();
            this.passivationTO = desc.getPassivationTimeout();
            this.removalTO = desc.getRemovalTimeout();
            this.checkTo = desc.getCheckTimeout();
            String fileDbPath = desc.getFileDbPath();
            if (fileDbPath == null || fileDbPath.equals("")) {
                String jeusHome = JeusBootstrapProperties.JEUS_HOME;
                if (jeusHome == null) {
                    throw new SessionServerException("jeus.home property must be set for session manager.");
                }
                desc.setFileDbPath(jeusHome + File.separator + "sessiondb" + File.separator + "central" + File.separator + serverName);
            }
            if ((fileDbName = desc.getFileDbName()) == null || fileDbName.equals("")) {
                desc.setFileDbName(serverName);
            }
            this.storage = new SessionStorage(desc.getFileDbPath(), desc.getFileDbName(), this.removalTO, 1000);
            this.storage.setMinHole(desc.getMinHole());
            this.storage.setPackingRate(desc.getPackingRate());
            this.sessions = new Hashtable(1000);
            this.configureSessionMemory();
            this.sessionStat = new SessionStatistic(JeusPort.JeusBase, serverName);
        }
        catch (Throwable ex) {
            throw new SessionServerException(JeusMessage_Session2._21005, serverName, ex);
        }
    }

    private void configureSessionMemory() {
        this.memoryMaxBytes = CentralConstants.SESSION_MEMORY_LIMIT_BYTES;
        this.passivationRatio = CentralConstants.SESSION_MEMORY_LIMIT_RATIO;
        this.gcForcefully = CentralConstants.SESSION_MEMORY_LIMIT_GC_FORCEFULLY;
        if (logger.isLoggable(JeusMessage_Session2._29005_LEVEL)) {
            logger.log(JeusMessage_Session2._29005_LEVEL, JeusMessage_Session2._29005, new Object[]{this.memoryMaxBytes, this.passivationRatio, this.gcForcefully});
        }
    }

    public void export(String bindName, J2EEManagedObject parent) throws SessionServerException {
        try {
            this.mbean = (SessionManagerMo)SessionManagerMo.createMBean(this.desc.getServerName(), parent.getObjectName(), this);
            if (this.sessionStat != null) {
                this.sessionStat.start();
            }
        }
        catch (Throwable ex) {
            throw new SessionServerException(JeusMessage_Session2._21005, this.desc.getServerName(), ex);
        }
        this.export0(bindName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport() throws SessionServerException {
        try {
            if (this.sessionStat != null) {
                this.sessionStat.stop();
                this.sessionStat.finish();
                this.sessionStat = null;
            }
            this.unexport0();
        }
        finally {
            if (this.mbean != null) {
                this.mbean.destroyMBean();
                this.mbean = null;
            }
        }
    }

    public byte[] getSession(Object key) {
        if (!this.ready) {
            return null;
        }
        try {
            Entry entry = (Entry)this.sessions.get(key);
            if (entry != null) {
                long lastAccessTime = entry.lastAccessTime;
                entry.lastAccessTime = System.currentTimeMillis();
                if (entry.contents != null) {
                    NetUtil.writeLong((byte[])entry.contents, (int)0, (long)lastAccessTime);
                }
                return entry.contents;
            }
            entry = new Entry(key, null, 0L);
            byte[] value = this.storage.load(entry);
            entry.contents = value;
            entry.lastAccessTime = System.currentTimeMillis();
            this.checkSessionMemory();
            this.sessions.put(key, entry);
            if (this.sessionStat != null) {
                this.sessionStat.gather(null, entry);
            }
            return value;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public byte[] getServletSession(Object key) {
        if (!this.ready) {
            return null;
        }
        try {
            Entry entry = (Entry)this.sessions.get(key);
            if (entry != null) {
                long lastAccessTime = entry.lastAccessTime;
                entry.lastAccessTime = System.currentTimeMillis();
                if (entry.contents != null) {
                    NetUtil.writeLong((byte[])entry.contents, (int)0, (long)lastAccessTime);
                }
                return entry.contents;
            }
            entry = new Entry(key, null, 0L);
            byte[] value = this.storage.load(entry);
            entry.contents = value;
            entry.lastAccessTime = System.currentTimeMillis();
            this.checkSessionMemory();
            this.sessions.put(key, entry);
            if (this.sessionStat != null) {
                this.sessionStat.gather(null, entry);
            }
            return value;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBackupData(boolean all) {
        Vector list;
        if (!all) {
            Object object = this.countSync;
            synchronized (object) {
                this.buffered = 0;
            }
            object = this.entryBuffer;
            synchronized (object) {
                list = new Vector(this.entryBuffer.values());
                this.entryBuffer = new Hashtable(1000);
            }
        }
        Hashtable hashtable = this.entryBuffer;
        synchronized (hashtable) {
            list = new Vector(this.sessions.values());
            this.entryBuffer = new Hashtable(1000);
            this.buffered = 0;
            this.buffering = true;
        }
        return list;
    }

    public final byte[] getDBData(Entry key) {
        if (this.storage == null) {
            return null;
        }
        try {
            return this.storage.load(key, false);
        }
        catch (SessionServerException e) {
            return null;
        }
    }

    public Vector getBackupDataDB() {
        if (this.storage != null) {
            Hashtable t = this.storage.getEntries();
            Enumeration enum1 = t.keys();
            Vector v = new Vector();
            while (enum1.hasMoreElements()) {
                v.add(enum1.nextElement());
            }
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBackupData() {
        Vector list;
        Object object = this.sync3;
        synchronized (object) {
            list = new Vector(this.sessions.values());
        }
        return list;
    }

    public void backupDead() {
        this.buffering = false;
        this.entryBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSession() {
        long currentTime = System.currentTimeMillis();
        if (this.passivationTO == -1L) {
            if (this.removalTO == -1L) {
                return;
            }
            Enumeration entries = this.sessions.elements();
            while (entries.hasMoreElements()) {
                boolean isRemove;
                Entry entry = (Entry)entries.nextElement();
                Object object = this.sync2;
                synchronized (object) {
                    isRemove = currentTime - entry.lastAccessTime > this.removalTO;
                }
                if (!isRemove) continue;
                Entry removeEntry = (Entry)this.sessions.remove(entry.key);
                if (this.sessionStat != null) {
                    this.sessionStat.gather(removeEntry, null);
                }
                if (!logger.isLoggable(JeusMessage_Session2._21335_LEVEL)) continue;
                logger.log(JeusMessage_Session2._21335_LEVEL, JeusMessage_Session2._21335, new Object[]{this.desc.getServerName(), entry.key});
            }
        } else {
            ArrayList<Entry> liveEntries = new ArrayList<Entry>();
            Enumeration entries = this.sessions.elements();
            while (entries.hasMoreElements()) {
                boolean isPassivate;
                Entry entry = (Entry)entries.nextElement();
                Object object = this.sync2;
                synchronized (object) {
                    isPassivate = currentTime - entry.lastAccessTime > this.passivationTO;
                }
                if (isPassivate && this.passivateEntry(entry)) continue;
                liveEntries.add(entry);
            }
            Object object = this.checkingMemoryLock;
            synchronized (object) {
                this.sortedEntries = liveEntries.toArray();
                liveEntries.clear();
                Arrays.sort(this.sortedEntries);
            }
            this.checkSessionMemory();
            this.storage.removeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean passivateEntry(Entry entry) {
        if (this.sessions.remove(entry.key) == null) {
            return false;
        }
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            block9: {
                if (this.sessionStat != null) {
                    this.sessionStat.gather(entry, null);
                }
                if (entry.contents != null) {
                    NetUtil.writeLong((byte[])entry.contents, (int)0, (long)entry.lastAccessTime);
                }
                byte[] contents = entry.contents;
                try {
                    this.storage.store(entry, contents);
                    if (logger.isLoggable(JeusMessage_Session2._21305_LEVEL)) {
                        logger.log(JeusMessage_Session2._21305_LEVEL, JeusMessage_Session2._21305, new Object[]{this.desc.getServerName(), entry.key});
                    }
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_Session2._21011_LEVEL)) break block9;
                    logger.log(JeusMessage_Session2._21011_LEVEL, JeusMessage_Session2._21011, (Object[])new String[]{this.desc.getServerName(), entry.key.toString()}, ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSessionMemory() {
        if (this.memoryMaxBytes <= 0L) {
            return;
        }
        long beforeLogicalMemory = this.sessionStat.getTotalSessionMemory();
        if (this.memoryMaxBytes > beforeLogicalMemory) {
            return;
        }
        if (logger.isLoggable(JeusMessage_Session2._29006_LEVEL)) {
            logger.log(JeusMessage_Session2._29006_LEVEL, JeusMessage_Session2._29006, new Object[]{this.memoryMaxBytes, beforeLogicalMemory});
        }
        long limitLogicalMemory = (long)((double)beforeLogicalMemory * this.passivationRatio);
        long freeMemory = 0L;
        if (this.gcForcefully) {
            freeMemory = Runtime.getRuntime().freeMemory();
        }
        int removedMemory = 0;
        Object object = this.checkingMemoryLock;
        synchronized (object) {
            for (int i = 0; i < this.sortedEntries.length; ++i) {
                if (this.sortedEntries[i] == null) continue;
                Entry e = (Entry)this.sortedEntries[i];
                if (this.entryBuffer != null) {
                    if (this.entryBuffer.containsKey(e.key) || !this.passivateEntry(e)) continue;
                    removedMemory += e.getSize();
                    e = null;
                    this.sortedEntries[i] = null;
                    if ((long)removedMemory < limitLogicalMemory) continue;
                    break;
                }
                if (!this.passivateEntry(e)) continue;
                removedMemory += e.getSize();
                e = null;
                this.sortedEntries[i] = null;
                if ((long)removedMemory >= limitLogicalMemory) break;
            }
        }
        if (removedMemory > 0) {
            if (this.gcForcefully) {
                System.gc();
                System.runFinalization();
                if (logger.isLoggable(JeusMessage_Session2._29007_LEVEL)) {
                    logger.log(JeusMessage_Session2._29007_LEVEL, JeusMessage_Session2._29007, new Object[]{beforeLogicalMemory, this.sessionStat.getTotalSessionMemory(), freeMemory, Runtime.getRuntime().freeMemory()});
                }
            } else if (logger.isLoggable(JeusMessage_Session2._29008_LEVEL)) {
                logger.log(JeusMessage_Session2._29008_LEVEL, JeusMessage_Session2._29008, new Object[]{beforeLogicalMemory, this.sessionStat.getTotalSessionMemory()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBackup(Vector list) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            int size = list.size();
            if (size > 0) {
                this.checkSessionMemory();
            }
            for (int i = 0; i < size; ++i) {
                Entry entry = (Entry)list.elementAt(i);
                try {
                    if (entry.lastAccessTime == 0L) {
                        Entry removeEntry = (Entry)this.sessions.remove(entry.key);
                        if (this.sessionStat != null) {
                            this.sessionStat.gather(removeEntry, null);
                        }
                        if (this.storage.remove(entry) || !logger.isLoggable(JeusMessage_Session2._21306_LEVEL)) continue;
                        logger.log(JeusMessage_Session2._21306_LEVEL, JeusMessage_Session2._21306, (Object)entry);
                        continue;
                    }
                    Entry oldEntry = this.sessions.put(entry.key, entry);
                    if (this.sessionStat == null) continue;
                    this.sessionStat.gather(oldEntry, entry);
                    continue;
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_Session2._21012_LEVEL)) continue;
                    logger.log(JeusMessage_Session2._21012_LEVEL, JeusMessage_Session2._21012, (Object)entry.toString(), ex);
                }
            }
        }
    }

    public boolean isRecovery() {
        return this.ready;
    }

    public boolean isExist(String id) {
        Entry entry = (Entry)this.sessions.get(id);
        if (entry != null) {
            return true;
        }
        return this.storage.isExist(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllSessionKeys() {
        HashSet set = null;
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            set = new HashSet(this.sessions.keySet());
            set.addAll(this.storage.getAllSessionIds());
        }
        return new ArrayList(set);
    }

    public void alive() {
        if (logger.isLoggable(JeusMessage_Session2._21013_LEVEL)) {
            logger.log(JeusMessage_Session2._21013_LEVEL, JeusMessage_Session2._21013);
        }
    }

    public int getAllSessionsSize() {
        return this.sessions.size() + this.storage.getSessionSize();
    }

    public int getActiveSessionsSize() {
        return this.sessions.size();
    }

    public int getPassivateSessionsSize() {
        return this.storage.getSessionSize();
    }

    public long getPassivationTO() {
        return this.passivationTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassivationTO(long i) {
        if (i < 0L) {
            return;
        }
        Object object = this.sync2;
        synchronized (object) {
            this.passivationTO = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovalTO(long i) {
        if (i < 0L) {
            return;
        }
        Object object = this.sync2;
        synchronized (object) {
            this.removalTO = i;
            this.storage.setRemovalTO(i);
        }
    }

    public long getRemovalTO() {
        return this.removalTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupTrigger(int i) {
        if (i < 0) {
            return;
        }
        Object object = this.countSync;
        synchronized (object) {
            this.backupTrigger = i;
        }
    }

    public int getBackupTrigger() {
        return this.backupTrigger;
    }

    public long getCheckTO() {
        return this.checkTo;
    }

    public void setCheckTO(long i) {
        if (i < 0L) {
            return;
        }
        this.checkTo = i;
        if (this.backupThread != null) {
            this.backupThread.setCheckTO(i);
        }
    }

    public String getBackupManagerName() {
        if (this.backupThread == null) {
            return null;
        }
        return this.backupThread.getBackupServerName();
    }

    public boolean isBackupConnected() {
        return this.backupThread != null && this.backupThread.isBackupConnected();
    }

    public Stats updateStats(SessionManagerStatsImpl stats) {
        int active = this.sessions.size();
        int passive = this.storage.size();
        long totalMemory = 0L;
        long peakMemory = 0L;
        long memory1Min = 0L;
        long memory5Min = 0L;
        long memory15Min = 0L;
        if (this.sessionStat != null) {
            totalMemory = this.sessionStat.getTotalSessionMemory();
            peakMemory = this.sessionStat.getSessionPeakMemory();
            memory1Min = this.sessionStat.getMemory1MinuteDifference();
            memory5Min = this.sessionStat.getMemory5MinuteDifference();
            memory15Min = this.sessionStat.getMemory15MinuteDifference();
        }
        ((CountStatisticImpl)stats.getTotalSessionMemory()).setValue(totalMemory);
        ((CountStatisticImpl)stats.getSessionPeakMemory()).setValue(peakMemory);
        ((CountStatisticImpl)stats.getMemory1MinuteDifference()).setValue(memory1Min);
        ((CountStatisticImpl)stats.getMemory5MinuteDifference()).setValue(memory5Min);
        ((CountStatisticImpl)stats.getMemory15MinuteDifference()).setValue(memory15Min);
        ((CountStatisticImpl)stats.getActiveSessionCount()).setValue((long)active);
        ((CountStatisticImpl)stats.getPassivatedSessionCount()).setValue((long)passive);
        ((CountStatisticImpl)stats.getTotalSessionCount()).setValue((long)(active + passive));
        return stats;
    }

    public String getServerName() {
        if (this.desc != null) {
            return this.desc.getServerName();
        }
        return null;
    }

    public abstract void addSession(Object var1, byte[] var2);

    public abstract void addNewSession(Object var1, byte[] var2);

    public abstract void removeSession(Object var1);

    public abstract void doRecovery(SessionManagerClient var1);

    protected abstract void export0(String var1) throws SessionServerException;

    protected abstract void unexport0() throws SessionServerException;
}

