/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jeus.net.helper.MsgSync;
import jeus.net.impl.NodeInfo;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.CentralSessionServer;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.SessionManager;
import jeus.sessionmanager.central.network.Packet;
import jeus.sessionmanager.central.network.SessionTransceiver;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.WaitTimeoutException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionManagerClient {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    public static boolean ASYNC_MODE = CentralConstants.ASYNC_MODE;
    private String smName;
    private SessionTransceiver transceiver;
    private SessionManager sessionManager;
    private boolean local = false;
    private String hostname;
    private NodeInfo nodeInfo;
    private int port = JeusPort.JeusBase;
    private long connectTimeout;
    private long replyWaitTimeout;
    private static final int INVALID_SEQUENCE_NUMBER = 0;
    public static final int INVALID_ID = -1;
    public static final int DEFAULT_ID = 0;
    public int id = -1;

    public SessionManagerClient(String smName, long connectTimeout, long replyWaitTimeout) {
        this(0, smName, connectTimeout, replyWaitTimeout);
    }

    public SessionManagerClient(int id, String smName, long connectTimeout, long replyWaitTimeout) {
        this.smName = smName;
        this.connectTimeout = connectTimeout;
        this.replyWaitTimeout = replyWaitTimeout;
        this.id = id;
    }

    public void initialize() throws Exception {
        this.sessionManager = CentralSessionServer.getSessionManager(this.smName);
        if (this.sessionManager == null) {
            this.resolveSessionServerName(this.smName);
            this.nodeInfo = CentralConstants.SESSION_GLOBAL_USE_SSL ? new NodeInfo(this.hostname, this.port + 14) : new NodeInfo(this.hostname, this.port, String.valueOf(this.port + 14));
            this.transceiver = SessionTransceiver.getTransceiver(this.nodeInfo, this.connectTimeout, this.replyWaitTimeout);
            this.local = false;
        } else {
            this.local = true;
        }
    }

    public void destroy() {
        if (!this.local && this.transceiver != null) {
            this.transceiver.stop();
            this.transceiver = null;
            this.id = -1;
        }
    }

    private void resolveSessionServerName(String smName) throws NamingException {
        String host = null;
        host = VirtualDNS.getRealNodeName(smName);
        if (host == null) {
            InitialContext ctx = new InitialContext();
            host = (String)ctx.lookup(smName);
        }
        if (host == null) {
            throw new NamingException("couldn't find " + smName + "'s host informaiton");
        }
        if (host.indexOf(":") > 0) {
            this.hostname = host.substring(0, host.indexOf(":"));
            try {
                this.port = Integer.parseInt(host.substring(host.indexOf(":") + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.port <= 0) {
                this.port = JeusPort.JeusBase;
            }
        } else {
            this.hostname = host;
            this.port = JeusPort.JeusBase;
        }
    }

    private void sendAsync(Packet sndpkt) throws IOException {
        if (this.local) {
            throw new IOException("failed to send(Async) a packet because SessionManagerClient is local.");
        }
        if (this.transceiver != null) {
            try {
                this.transceiver.sendAsync(sndpkt);
            }
            catch (IOException e) {
                if (!CentralConstants.IO_FAIL_RETRY) {
                    throw e;
                }
                if (logger.isLoggable(JeusMessage_Session2._21338_LEVEL)) {
                    logger.log(JeusMessage_Session2._21338_LEVEL, JeusMessage_Session2._21338, (Object[])new String[]{this.smName, this.transceiver.toString()}, (Throwable)e);
                }
                this.transceiver.stop();
                this.transceiver = SessionTransceiver.getTransceiver(this.nodeInfo, this.connectTimeout, this.replyWaitTimeout);
                this.transceiver.sendAsync(sndpkt);
            }
        } else {
            throw new IOException("<SessionManagerClient> already shutdowned");
        }
    }

    private Packet send(Packet sndpkt, MsgSync reply) throws IOException {
        if (this.local) {
            throw new IOException("failed to send a packet because SessionManagerClient is local.");
        }
        if (this.transceiver != null) {
            try {
                return this.transceiver.send(sndpkt, reply);
            }
            catch (WaitTimeoutException wte) {
                if (!CentralConstants.IO_FAIL_RETRY) {
                    throw wte;
                }
                if (logger.isLoggable(JeusMessage_Session2._21338_LEVEL)) {
                    logger.log(JeusMessage_Session2._21338_LEVEL, JeusMessage_Session2._21338, (Object[])new String[]{this.smName, this.transceiver.toString()}, (Throwable)wte);
                }
                try {
                    Thread.sleep(reply.getWaitTimeOut() / 4L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return this.transceiver.send(sndpkt, reply);
            }
            catch (IOException ioe) {
                if (!CentralConstants.IO_FAIL_RETRY) {
                    throw ioe;
                }
                if (logger.isLoggable(JeusMessage_Session2._21338_LEVEL)) {
                    logger.log(JeusMessage_Session2._21338_LEVEL, JeusMessage_Session2._21338, (Object[])new String[]{this.smName, this.transceiver.toString()}, (Throwable)ioe);
                }
                this.transceiver.stop();
                this.transceiver = SessionTransceiver.getTransceiver(this.nodeInfo, this.connectTimeout, this.replyWaitTimeout);
                return this.transceiver.send(sndpkt, reply);
            }
        }
        throw new IOException("<SessionManagerClient> already shutdowned");
    }

    public void addSession(Object key, byte[] value) throws IOException {
        try {
            if (this.local) {
                this.sessionManager.addSession(key, value);
            } else {
                int opcode = 1;
                if (ASYNC_MODE) {
                    opcode = 31;
                }
                Packet sndpkt = Packet.makePacket(opcode, 0, this.smName, key, value);
                if (ASYNC_MODE) {
                    this.sendAsync(sndpkt);
                } else {
                    this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21010_LEVEL)) {
                logger.log(JeusMessage_Session2._21010_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21010, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public void addSession(Object key, byte[] value, int len) throws IOException {
        if (value == null) {
            return;
        }
        if (len > value.length) {
            len = value.length;
        }
        try {
            if (this.local) {
                if (len != value.length) {
                    byte[] tmp = new byte[len];
                    System.arraycopy(value, 0, tmp, 0, len);
                    value = tmp;
                }
                this.sessionManager.addSession(key, value);
            } else {
                int opcode = 1;
                if (ASYNC_MODE) {
                    opcode = 31;
                }
                Packet sndpkt = Packet.makePacket(opcode, 0, this.smName, key, value, len);
                if (ASYNC_MODE) {
                    this.sendAsync(sndpkt);
                } else {
                    this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21010_LEVEL)) {
                logger.log(JeusMessage_Session2._21010_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21010, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public void addNewSession(Object key, byte[] value) throws IOException {
        try {
            if (this.local) {
                this.sessionManager.addNewSession(key, value);
            } else {
                int opcode = 34;
                if (ASYNC_MODE) {
                    opcode = 35;
                }
                Packet sndpkt = Packet.makePacket(opcode, 0, this.smName, key, value);
                if (ASYNC_MODE) {
                    this.sendAsync(sndpkt);
                } else {
                    this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21010_LEVEL)) {
                logger.log(JeusMessage_Session2._21010_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21010, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public void addNewSession(Object key, byte[] value, int len) throws IOException {
        if (value == null) {
            return;
        }
        if (len > value.length) {
            len = value.length;
        }
        try {
            if (this.local) {
                if (len != value.length) {
                    byte[] tmp = new byte[len];
                    System.arraycopy(value, 0, tmp, 0, len);
                    value = tmp;
                }
                this.sessionManager.addNewSession(key, value);
            } else {
                int opcode = 34;
                if (ASYNC_MODE) {
                    opcode = 35;
                }
                Packet sndpkt = Packet.makePacket(opcode, 0, this.smName, key, value, len);
                if (ASYNC_MODE) {
                    this.sendAsync(sndpkt);
                } else {
                    this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21010_LEVEL)) {
                logger.log(JeusMessage_Session2._21010_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21010, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public byte[] getSession(Object key) throws IOException {
        byte[] response;
        try {
            if (this.local) {
                response = this.sessionManager.getSession(key);
            } else {
                Packet sndpkt = Packet.makePacket(2, 0, this.smName, key, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                response = rcvpkt.getValue();
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21318_LEVEL)) {
                logger.log(JeusMessage_Session2._21318_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21318, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
        return response;
    }

    public void removeSession(Object key) throws IOException {
        try {
            if (this.local) {
                this.sessionManager.removeSession(key);
            } else {
                int opcode = 3;
                if (ASYNC_MODE) {
                    opcode = 33;
                }
                Packet sndpkt = Packet.makePacket(opcode, 0, this.smName, key, null);
                if (ASYNC_MODE) {
                    this.sendAsync(sndpkt);
                } else {
                    this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21319_LEVEL)) {
                logger.log(JeusMessage_Session2._21319_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21319, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public void dumpBackup(Vector list) throws IOException {
        if (this.local || list == null || list.size() <= 0) {
            return;
        }
        try {
            byte[] dumpBuffer = new byte[131072];
            int size = list.size();
            int count = 0;
            Packet packet = Packet.makePacket(4, 0, this.smName, null, dumpBuffer);
            int acceptcnt = 0;
            packet.setEmptyValue();
            while (count < size) {
                boolean accepted = packet.dumpEntry((Entry)list.get(count));
                if (!accepted && acceptcnt == 0) {
                    dumpBuffer = new byte[dumpBuffer.length * 2];
                    packet.setEmptyValue(dumpBuffer);
                } else if (accepted) {
                    ++count;
                    ++acceptcnt;
                }
                if ((accepted || acceptcnt <= 0) && count != size) continue;
                packet.setValueIndex(acceptcnt);
                this.send(packet, new MsgSync(this.replyWaitTimeout));
                if (count != size) {
                    packet = Packet.makePacket(4, 0, this.smName, null, dumpBuffer);
                    acceptcnt = 0;
                    packet.setEmptyValue();
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21320_LEVEL)) {
                logger.log(JeusMessage_Session2._21320_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21320, (Object)this.smName), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public int getAllSessionsSize() throws IOException {
        int size;
        if (this.local) {
            size = this.sessionManager.getAllSessionsSize();
        } else {
            try {
                Packet sndpkt = Packet.makePacket(7, 0, this.smName, null, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                size = rcvpkt.getValueIndex();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21321_LEVEL)) {
                    logger.log(JeusMessage_Session2._21321_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21321, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
        return size;
    }

    public int getActiveSessionsSize() throws IOException {
        int size;
        if (this.local) {
            size = this.sessionManager.getActiveSessionsSize();
        } else {
            try {
                Packet sndpkt = Packet.makePacket(8, 0, this.smName, null, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                size = rcvpkt.getValueIndex();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21322_LEVEL)) {
                    logger.log(JeusMessage_Session2._21322_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21322, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
        return size;
    }

    public int getPassivateSessionsSize() throws IOException {
        int size;
        if (this.local) {
            size = this.sessionManager.getPassivateSessionsSize();
        } else {
            try {
                Packet sndpkt = Packet.makePacket(9, 0, this.smName, null, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                size = rcvpkt.getValueIndex();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21323_LEVEL)) {
                    logger.log(JeusMessage_Session2._21323_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21323, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
        return size;
    }

    public void alive() throws IOException {
        if (this.local) {
            this.sessionManager.alive();
        } else {
            try {
                Packet sndpkt = Packet.makePacket(5, 0, this.smName, null, null);
                this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21324_LEVEL)) {
                    logger.log(JeusMessage_Session2._21324_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21324, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
    }

    public void setPassivationTO(int i) throws IOException {
        if (this.local) {
            this.sessionManager.setPassivationTO(i);
        } else {
            try {
                Packet sndpkt = Packet.makePacket(11, 0, this.smName, i);
                this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21326_LEVEL)) {
                    logger.log(JeusMessage_Session2._21326_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21326, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
    }

    public void setRemovalTO(int i) throws IOException {
        if (this.local) {
            this.sessionManager.setRemovalTO(i);
        } else {
            try {
                Packet sndpkt = Packet.makePacket(12, 0, this.smName, i);
                this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21327_LEVEL)) {
                    logger.log(JeusMessage_Session2._21327_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21327, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
    }

    public void setBackupTrigger(int i) throws IOException {
        if (this.local) {
            this.sessionManager.setBackupTrigger(i);
        } else {
            try {
                Packet sndpkt = Packet.makePacket(13, 0, this.smName, i);
                this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21328_LEVEL)) {
                    logger.log(JeusMessage_Session2._21328_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21328, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
    }

    public void setCheckTO(int i) throws IOException {
        if (this.local) {
            this.sessionManager.setCheckTO(i);
        } else {
            try {
                Packet sndpkt = Packet.makePacket(14, 0, this.smName, i);
                this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21329_LEVEL)) {
                    logger.log(JeusMessage_Session2._21329_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21329, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
    }

    public boolean isRecovery() throws IOException {
        boolean recovery_flag;
        if (this.local) {
            recovery_flag = this.sessionManager.isRecovery();
        } else {
            try {
                Packet sndpkt = Packet.makePacket(15, 0, this.smName, null, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                int recovered = rcvpkt.getValueIndex();
                recovery_flag = recovered == 1;
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session2._21330_LEVEL)) {
                    logger.log(JeusMessage_Session2._21330_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21330, (Object)this.smName), (Throwable)ioe);
                }
                throw ioe;
            }
        }
        return recovery_flag;
    }

    public byte[] getServletSession(Object key) throws IOException {
        byte[] response;
        try {
            if (this.local) {
                response = this.sessionManager.getServletSession(key);
            } else {
                Packet sndpkt = Packet.makePacket(16, 0, this.smName, key, null);
                Packet rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                response = rcvpkt.getValue();
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21318_LEVEL)) {
                logger.log(JeusMessage_Session2._21318_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21318, (Object[])new String[]{this.smName, key.toString()}), (Throwable)ioe);
            }
            throw ioe;
        }
        return response;
    }

    public Vector getBackupData() throws IOException {
        try {
            Vector<Entry> list;
            if (this.local) {
                list = this.sessionManager.getBackupData();
            } else {
                Packet rcvpkt;
                list = new Vector<Entry>();
                do {
                    Packet sndpkt = Packet.makePacket(10, 0, this.smName, null, null);
                    rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                    Vector v = rcvpkt.getEntryList();
                    Enumeration enum1 = v.elements();
                    while (enum1.hasMoreElements()) {
                        Entry ent = (Entry)enum1.nextElement();
                        list.add(ent);
                    }
                } while (rcvpkt.hasMoreBackupData());
            }
            return list;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21331_LEVEL)) {
                logger.log(JeusMessage_Session2._21331_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21331, (Object)this.smName), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public Vector getBackupDataDB() throws IOException {
        try {
            Vector<Entry> list;
            if (this.local) {
                list = this.sessionManager.getBackupDataDB();
            } else {
                Packet rcvpkt;
                list = new Vector<Entry>();
                do {
                    Packet sndpkt = Packet.makePacket(23, 0, this.smName, null, null);
                    rcvpkt = this.send(sndpkt, new MsgSync(this.replyWaitTimeout));
                    Vector v = rcvpkt.getEntryList();
                    Enumeration enum1 = v.elements();
                    while (enum1.hasMoreElements()) {
                        Entry ent = (Entry)enum1.nextElement();
                        list.add(ent);
                    }
                } while (rcvpkt.hasMoreBackupDataDB());
            }
            return list;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session2._21334_LEVEL)) {
                logger.log(JeusMessage_Session2._21334_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21334, (Object)this.smName), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public int getCurrentConnections() {
        if (this.local) {
            return 0;
        }
        if (this.transceiver == null) {
            if (logger.isLoggable(JeusMessage_Session2._21336_LEVEL)) {
                logger.log(JeusMessage_Session2._21336_LEVEL, JeusMessage_Session2._21336);
            }
            return 0;
        }
        return this.transceiver.getCurrentConnections();
    }

    public int getId() {
        return this.id;
    }
}

