/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import jeus.descriptor.jeusserver.SessionServerDescriptor;
import jeus.sessionmanager.central.BackupThread;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.SessionManager;
import jeus.sessionmanager.central.SessionManagerClient;
import jeus.sessionmanager.central.SessionServerException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_Session2;

public class SessionManagerImpl
extends SessionManager {
    public SessionManagerImpl(SessionServerDescriptor desc) throws SessionServerException {
        super(desc);
    }

    protected void export0(String bindName) throws SessionServerException {
        String backupName = this.desc.getBackupName();
        if (!this.recovered) {
            if (logger.isLoggable(JeusMessage_Session2._21307_LEVEL)) {
                logger.log(JeusMessage_Session2._21307_LEVEL, JeusMessage_Session2._21307, (Object)this.desc.getServerName());
            }
            int recoveryTryCount = CentralConstants.RECOVERY_TRY_COUNT;
            int count = 0;
            block6: while (true) {
                try {
                    while (true) {
                        this.doRecovery(null);
                        if (this.recovered || ++count >= recoveryTryCount) break block6;
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable t) {
                    continue;
                }
                break;
            }
            this.ready = true;
        }
        try {
            InitialContext ctx = new InitialContext();
            ctx.rebind(this.desc.getServerName(), (Object)bindName);
        }
        catch (Throwable ex) {
            throw new SessionServerException(JeusMessage_Session2._21008, this.desc.getServerName(), ex);
        }
        if (backupName != null && !backupName.equals("")) {
            try {
                this.backupThread = new BackupThread(this, null, backupName, this.checkTo, this.connectionTimeout, this.replyWaitTimeout);
                this.backupTrigger = this.desc.getBackupTrigger();
                this.entryBuffer = new Hashtable(1000);
                this.buffering = true;
                this.backupThread.start();
            }
            catch (Throwable t) {
                throw new SessionServerException(JeusMessage_Session2._21007, t);
            }
        } else {
            this.buffering = false;
            this.backupThread = null;
        }
        if (logger.isLoggable(JeusMessage_Session2._21006_LEVEL)) {
            logger.log(JeusMessage_Session2._21006_LEVEL, JeusMessage_Session2._21006, (Object)bindName);
        }
    }

    public void doRecovery(SessionManagerClient abackup) {
        int recoveryMode = this.desc.getRecoveryModeInt();
        if (recoveryMode == 1) {
            if (logger.isLoggable(JeusMessage_Session2._21308_LEVEL)) {
                logger.log(JeusMessage_Session2._21308_LEVEL, JeusMessage_Session2._21308, new Object[]{this.desc.getServerName(), "0"});
            }
            this.recovered = true;
            return;
        }
        String backupName = this.desc.getBackupName();
        if (backupName == null || backupName.trim().length() == 0) {
            this.recovered = true;
            return;
        }
        try {
            if (abackup == null) {
                abackup = new SessionManagerClient(backupName, this.connectionTimeout, this.replyWaitTimeout);
                try {
                    abackup.initialize();
                    abackup.alive();
                }
                catch (Throwable ex) {
                    abackup.destroy();
                    abackup = null;
                }
            }
            if (abackup != null) {
                Vector list;
                int size1 = 0;
                if (recoveryMode == 2 && (list = abackup.getBackupDataDB()) != null && list.size() != 0) {
                    size1 = list.size();
                    this.dumpBackup(list);
                }
                if ((list = abackup.getBackupData()) != null && list.size() != 0) {
                    size1 += list.size();
                    this.dumpBackup(list);
                }
                this.recovered = true;
                if (logger.isLoggable(JeusMessage_Session2._21308_LEVEL)) {
                    logger.log(JeusMessage_Session2._21308_LEVEL, JeusMessage_Session2._21308, new Object[]{this.desc.getServerName(), String.valueOf(size1)});
                }
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Session2._21309_LEVEL)) {
                logger.log(JeusMessage_Session2._21309_LEVEL, JeusMessage_Session2._21309, (Object)this.desc.getServerName(), t);
            }
            abackup = null;
        }
    }

    protected void unexport0() throws SessionServerException {
        try {
            if (this.backupThread != null) {
                this.backupThread.blockingBackup();
                this.backupThread.close();
                this.backupThread = null;
            }
        }
        catch (Throwable ex) {
            throw new SessionServerException(JeusMessage_Session2._21009, this.desc.getServerName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(Object key, byte[] value) {
        Entry entry;
        if (!this.ready) {
            return;
        }
        try {
            entry = new Entry(key, value, System.currentTimeMillis());
            this.checkSessionMemory();
            Entry oldEntry = this.sessions.put(key, entry);
            if (this.sessionStat != null) {
                this.sessionStat.gather(oldEntry, entry);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Session2._21010_LEVEL)) {
                logger.log(JeusMessage_Session2._21010_LEVEL, JeusMessage_Session2._21010, (Object[])new String[]{this.desc.getServerName(), key.toString()}, ex);
            }
            return;
        }
        if (this.buffering) {
            try {
                this.entryBuffer.put(entry.key, entry);
                Object ex = this.countSync;
                synchronized (ex) {
                    ++this.buffered;
                    if (this.buffered == this.backupTrigger && this.backupThread != null) {
                        this.backupThread.backup();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addNewSession(Object key, byte[] value) {
        if (!this.ready) {
            return;
        }
        if (this.sessions.get(key) != null) {
            if (logger.isLoggable(JeusMessage_Session2._21337_LEVEL)) {
                logger.log(JeusMessage_Session2._21337_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21337, (Object[])new String[]{this.desc.getServerName(), key.toString()}), (Throwable)((Object)new SessionServerException("The session id is inconsistent")));
            }
            return;
        }
        this.addSession(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Object key) {
        Object object;
        if (!this.ready) {
            return;
        }
        Entry entry = null;
        try {
            object = this.sessions;
            synchronized (object) {
                Entry removeEntry = (Entry)this.sessions.remove(key);
                if (this.sessionStat != null) {
                    this.sessionStat.gather(removeEntry, null);
                }
                if (!this.storage.remove(entry = new Entry(key, null, 0L)) && logger.isLoggable(JeusMessage_Session2._21311_LEVEL)) {
                    logger.log(JeusMessage_Session2._21311_LEVEL, JeusMessage_Session2._21311, (Object)entry);
                }
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Session2._21312_LEVEL)) {
                logger.log(JeusMessage_Session2._21312_LEVEL, JeusMessage_Session2._21312, key, ex);
            }
            return;
        }
        if (this.buffering) {
            if (entry == null) {
                entry = new Entry(key, null, 0L);
            }
            this.entryBuffer.put(entry.key, entry);
            object = this.countSync;
            synchronized (object) {
                ++this.buffered;
                if (this.buffered == this.backupTrigger && this.backupThread != null) {
                    this.backupThread.backup();
                }
            }
        }
    }
}

