/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import jeus.net.ReplyListener;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.network.SMCode;
import jeus.util.ErrorMsgManager;
import jeus.util.cnet.NetUtil;
import jeus.util.message.JeusMessage_Session2;

public final class Packet
implements SMCode {
    private static final int HEADER_SIZE = 16;
    private static final int MAGIC_NUMBER = 1204;
    private static final int MAGIC_OFFSET = 0;
    private static final int OPCODE_OFFSET = 2;
    private static final int SEQNO_OFFSET = 4;
    private static final int NAMELEN_OFFSET = 8;
    private static final int KEYLEN_OFFSET = 10;
    private static final int VALUELEN_OFFSET = 12;
    private byte[] header = new byte[16];
    private byte[] smName = null;
    private byte[] key = null;
    private byte[] value = null;
    private int valueLength = 0;
    private static final int SEND_REQUEST = 1;
    private static final int SEND_REPLY_REQUEST = 2;
    private static final int SEND_REPLY_RESPONSE = 3;

    public Packet() {
        NetUtil.writeShort((byte[])this.header, (int)0, (int)1204);
    }

    public Packet(int opcode) {
        this();
        this.setOpcode(opcode);
    }

    public static Packet makePacket(int opcode, int seqno, String name1, Object key1, byte[] value1) {
        Packet packet = new Packet(opcode);
        packet.setSequenceNumber(seqno);
        packet.setName(name1);
        packet.setKey(key1);
        packet.setValue(value1);
        return packet;
    }

    public static Packet makePacket(int opcode, int seqno, String name1, Object key1, byte[] value1, int len) {
        Packet packet = new Packet(opcode);
        packet.setSequenceNumber(seqno);
        packet.setName(name1);
        packet.setKey(key1);
        packet.setValue(value1, len);
        return packet;
    }

    public static Packet makePacket(int opcode, int seqno, String name1, int value1) {
        Packet packet = new Packet(opcode);
        packet.setSequenceNumber(seqno);
        packet.setName(name1);
        byte[] value2 = new byte[4];
        NetUtil.writeInt((byte[])value2, (int)0, (int)value1);
        packet.setValue(value2);
        return packet;
    }

    public void setOpcode(int opcode) {
        NetUtil.writeShort((byte[])this.header, (int)2, (int)opcode);
    }

    private void setSequenceNumber(int opcode) {
        NetUtil.writeInt((byte[])this.header, (int)4, (int)opcode);
    }

    private void setName(String name) {
        if (name != null) {
            this.smName = name.getBytes();
            NetUtil.writeShort((byte[])this.header, (int)8, (int)this.smName.length);
        } else {
            this.smName = null;
            NetUtil.writeShort((byte[])this.header, (int)8, (int)0);
        }
    }

    public void setKey(Object k) {
        if (k != null) {
            this.key = ((String)k).getBytes();
            NetUtil.writeShort((byte[])this.header, (int)10, (int)this.key.length);
        } else {
            this.key = null;
            NetUtil.writeShort((byte[])this.header, (int)10, (int)0);
        }
    }

    public void setValue(byte[] buf) {
        if (buf == null || buf.length == 0) {
            NetUtil.writeInt((byte[])this.header, (int)12, (int)0);
            this.value = null;
            this.valueLength = 0;
        } else {
            NetUtil.writeInt((byte[])this.header, (int)12, (int)buf.length);
            this.value = buf;
            this.valueLength = buf.length;
        }
    }

    public void setValue(byte[] buf, int len) {
        NetUtil.writeInt((byte[])this.header, (int)12, (int)len);
        this.valueLength = len;
        this.value = buf;
    }

    public void setValue(int val) {
        this.value = new byte[4];
        NetUtil.writeInt((byte[])this.value, (int)0, (int)val);
        this.valueLength = 4;
        NetUtil.writeInt((byte[])this.header, (int)12, (int)4);
    }

    private void setValueLength(int size) {
        NetUtil.writeInt((byte[])this.header, (int)12, (int)size);
        this.valueLength = size;
    }

    public boolean isShutdownMessage() {
        short c = this.getOpcode();
        return c == 19 || c == 20;
    }

    public boolean hasMoreBackupData() {
        return this.getOpcode() == 17;
    }

    public boolean hasMoreBackupDataDB() {
        return this.getOpcode() == 24;
    }

    private short getMagic() {
        return NetUtil.readShort((byte[])this.header, (int)0);
    }

    public short getOpcode() {
        return NetUtil.readShort((byte[])this.header, (int)2);
    }

    public int getSequenceNumber() {
        return NetUtil.readInt((byte[])this.header, (int)4);
    }

    private short getNameLength() {
        return NetUtil.readShort((byte[])this.header, (int)8);
    }

    private short getKeyLength() {
        return NetUtil.readShort((byte[])this.header, (int)10);
    }

    private int getValueLength() {
        return NetUtil.readInt((byte[])this.header, (int)12);
    }

    public String getName() {
        if (this.smName == null) {
            return null;
        }
        return new String(this.smName);
    }

    public Object getKey() {
        if (this.key == null) {
            return null;
        }
        return new String(this.key);
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean dumpEntry(Entry entry) {
        int contlen;
        long accessTime = entry.lastAccessTime;
        byte[] key1 = ((String)entry.key).getBytes();
        byte[] contents = entry.contents;
        int n = contlen = contents == null ? 0 : contents.length;
        if (key1 != null) {
            int total = 16 + key1.length + contlen;
            if (total + this.valueLength > this.value.length) {
                return false;
            }
            NetUtil.writeLong((byte[])this.value, (int)this.valueLength, (long)accessTime);
            this.valueLength += 8;
            NetUtil.writeInt((byte[])this.value, (int)this.valueLength, (int)key1.length);
            this.valueLength += 4;
            System.arraycopy(key1, 0, this.value, this.valueLength, key1.length);
            this.valueLength += key1.length;
            if (contents != null) {
                NetUtil.writeInt((byte[])this.value, (int)this.valueLength, (int)contlen);
                this.valueLength += 4;
                System.arraycopy(contents, 0, this.value, this.valueLength, contlen);
                this.valueLength += contlen;
            } else {
                NetUtil.writeInt((byte[])this.value, (int)this.valueLength, (int)0);
                this.valueLength += 4;
            }
            NetUtil.writeInt((byte[])this.header, (int)12, (int)this.valueLength);
            return true;
        }
        return true;
    }

    public Vector getEntryList() {
        if (this.value == null) {
            return new Vector();
        }
        int size = NetUtil.readInt((byte[])this.value, (int)0);
        int bufcnt = 4;
        if (size <= 0) {
            return new Vector();
        }
        Vector<Entry> list = new Vector<Entry>(size);
        for (int i = 0; i < size; ++i) {
            long accessTime = NetUtil.readLong((byte[])this.value, (int)bufcnt);
            int keylen = NetUtil.readInt((byte[])this.value, (int)(bufcnt += 8));
            byte[] key1 = new byte[keylen];
            System.arraycopy(this.value, bufcnt += 4, key1, 0, keylen);
            int contlen = NetUtil.readInt((byte[])this.value, (int)(bufcnt += keylen));
            bufcnt += 4;
            byte[] cont = null;
            if (contlen > 0) {
                cont = new byte[contlen];
                System.arraycopy(this.value, bufcnt, cont, 0, contlen);
                bufcnt += contlen;
            }
            Entry entry = new Entry(new String(key1), cont, accessTime);
            list.add(entry);
        }
        return list;
    }

    private void writeValueInt(int off, int val) throws IOException {
        if (this.value == null) {
            throw new IOException("<packet> value is null");
        }
        if (this.value.length < off + 4) {
            throw new IOException("<packet> not enough bytes in value");
        }
        NetUtil.writeInt((byte[])this.value, (int)off, (int)val);
    }

    private int readValueInt(int off) throws IOException {
        if (this.value == null) {
            throw new IOException("<packet> value is null");
        }
        if (this.value.length < off + 4) {
            throw new IOException("<packet> not enough bytes in value");
        }
        return NetUtil.readInt((byte[])this.value, (int)off);
    }

    public void send(SocketStream14 out) throws IOException {
        out.write(this.getByteBufferSessionMsg(out, 1));
    }

    public void send(SocketStream14 out, ReplyListener reply) throws IOException {
        out.write(this.getByteBufferSessionMsg(out, 2), reply);
    }

    public void sendReply(SocketStream14 out) throws IOException {
        out.writeReply(this.getByteBufferSessionMsg(out, 3), null);
    }

    private ByteBuffer getByteBufferSessionMsg(SocketStream14 out, int sendType) {
        int smNameSize = 0;
        int keySize = 0;
        int valueSize = 0;
        if (this.smName != null && (smNameSize = this.getNameLength()) > this.smName.length) {
            smNameSize = this.smName.length;
        }
        if (this.key != null && (keySize = this.getKeyLength()) > this.key.length) {
            keySize = this.key.length;
        }
        if (this.value != null && (valueSize = this.valueLength) > this.value.length) {
            valueSize = this.value.length;
        }
        int totalSize = 16 + smNameSize + keySize + valueSize;
        ByteBuffer buffer = null;
        switch (sendType) {
            case 1: {
                buffer = out.getByteBuffer(totalSize);
                break;
            }
            case 2: {
                buffer = out.getReqeustByteBuffer(totalSize);
                break;
            }
            case 3: {
                buffer = out.getReplyByteBuffer(totalSize);
                break;
            }
            default: {
                buffer = out.getByteBuffer(totalSize);
            }
        }
        buffer.put(this.header, 0, 16);
        if (smNameSize > 0) {
            buffer.put(this.smName, 0, smNameSize);
        }
        if (keySize > 0) {
            buffer.put(this.key, 0, keySize);
        }
        if (valueSize > 0) {
            buffer.put(this.value, 0, this.valueLength);
        }
        return buffer;
    }

    public void receive(byte[] message) throws IOException {
        int offset = 0;
        System.arraycopy(message, offset, this.header, 0, 16);
        offset += 16;
        short magic = this.getMagic();
        if (magic != 1204) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._22002, (Object)String.valueOf(magic)));
        }
        short namelen = this.getNameLength();
        if (namelen > 0) {
            this.smName = new byte[namelen];
            System.arraycopy(message, offset, this.smName, 0, namelen);
            offset += namelen;
        } else {
            this.smName = null;
        }
        short keylen = this.getKeyLength();
        if (keylen > 0) {
            this.key = new byte[keylen];
            System.arraycopy(message, offset, this.key, 0, keylen);
            offset += keylen;
        } else {
            this.key = null;
        }
        int valuelen = this.getValueLength();
        if (valuelen > 0) {
            this.value = new byte[valuelen];
            System.arraycopy(message, offset, this.value, 0, valuelen);
            offset += valuelen;
        } else {
            this.value = null;
        }
    }

    public void setEmptyValue(byte[] buffer) {
        this.setValue(buffer);
        try {
            this.writeValueInt(0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setValueLength(4);
    }

    public void setEmptyValue() {
        try {
            this.writeValueInt(0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setValueLength(4);
    }

    public int getValueIndex() throws IOException {
        return this.readValueInt(0);
    }

    public void setValueIndex(int index) throws IOException {
        this.writeValueInt(0, index);
    }
}

