/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.CentralSessionServer;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.SessionManager;
import jeus.sessionmanager.central.network.Packet;
import jeus.sessionmanager.central.network.SMCode;
import jeus.sessionmanager.central.network.SessionServerAcceptor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public final class ServiceHandler
implements SMCode {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private SessionServerAcceptor acceptor;
    private ThreadLocal handlerId;
    private ThreadLocal socketId;
    private ThreadLocal sockStream;
    private Hashtable backupData;
    private Hashtable backupDataIndex;
    private Hashtable backupDataDB;
    private Hashtable backupDataDBIndex;

    public ServiceHandler(SessionServerAcceptor acceptor) {
        this.acceptor = acceptor;
        this.handlerId = new ThreadLocal();
        this.socketId = new ThreadLocal();
        this.sockStream = new ThreadLocal();
        this.backupData = new Hashtable();
        this.backupDataIndex = new Hashtable();
        this.backupDataDB = new Hashtable();
        this.backupDataDBIndex = new Hashtable();
    }

    public void destroy() {
        this.clearDataByAllSocketId();
        this.backupData = null;
        this.backupDataIndex = null;
        this.backupDataDB = null;
        this.backupDataDBIndex = null;
        this.handlerId = null;
        this.socketId = null;
        this.sockStream = null;
        this.acceptor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePacket(byte[] message, SocketStream sockStream, String Id2) {
        if (this.handlerId == null || this.socketId == null || this.sockStream == null) {
            if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to receive a packet"));
            }
            return;
        }
        SocketID socketId = sockStream.getSocketID();
        this.handlerId.set(Id2);
        this.socketId.set(socketId);
        this.sockStream.set(sockStream);
        try {
            Packet rcvpkt = new Packet();
            rcvpkt.receive(message);
            this.service(rcvpkt);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.shutdown();
            this.acceptor.removeHandler(Id2);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.shutdown();
            this.acceptor.removeHandler(Id2);
        }
        finally {
            this.handlerId.set(null);
            this.socketId.set(null);
            this.sockStream.set(null);
        }
    }

    public void shutdown() {
        if (this.sockStream == null) {
            if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to shutdown"));
            }
            return;
        }
        SocketStream socketStream = (SocketStream)this.sockStream.get();
        if (socketStream == null) {
            if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to shutdown"));
            }
            return;
        }
        socketStream.destroy();
    }

    private void service(Packet rcvpkt) {
        if (this.handlerId == null) {
            if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to service a packet"));
            }
            return;
        }
        short opcode = rcvpkt.getOpcode();
        String smname = rcvpkt.getName();
        if (smname == null) {
            if (logger.isLoggable(JeusMessage_Session2._22008_LEVEL)) {
                logger.log(JeusMessage_Session2._22008_LEVEL, JeusMessage_Session2._22008, new Object[]{this.handlerId.get(), smname});
            }
            this.returnError(rcvpkt);
            return;
        }
        SessionManager mngr = CentralSessionServer.getSessionManager(smname);
        if (mngr == null) {
            if (logger.isLoggable(JeusMessage_Session2._22008_LEVEL)) {
                logger.log(JeusMessage_Session2._22008_LEVEL, JeusMessage_Session2._22008, new Object[]{this.handlerId.get(), smname});
            }
            this.returnError(rcvpkt);
            return;
        }
        switch (opcode) {
            case 1: {
                this.addSession(mngr, rcvpkt, false, false);
                break;
            }
            case 31: {
                this.addSession(mngr, rcvpkt, true, false);
                break;
            }
            case 34: {
                this.addSession(mngr, rcvpkt, false, true);
                break;
            }
            case 35: {
                this.addSession(mngr, rcvpkt, true, true);
                break;
            }
            case 2: {
                this.getSession(mngr, rcvpkt);
                break;
            }
            case 3: {
                this.removeSession(mngr, rcvpkt, false);
                break;
            }
            case 33: {
                this.removeSession(mngr, rcvpkt, true);
                break;
            }
            case 4: {
                this.dumpBackup(mngr, rcvpkt);
                break;
            }
            case 5: {
                this.isAlive(mngr, rcvpkt);
                break;
            }
            case 7: {
                this.getAllSessionsSize(mngr, rcvpkt);
                break;
            }
            case 8: {
                this.getActiveSessionsSize(mngr, rcvpkt);
                break;
            }
            case 9: {
                this.getPassivateSessionsSize(mngr, rcvpkt);
                break;
            }
            case 14: {
                this.setCheckTO(mngr, rcvpkt);
                break;
            }
            case 13: {
                this.setBackupTrigger(mngr, rcvpkt);
                break;
            }
            case 12: {
                this.setRemovalTO(mngr, rcvpkt);
                break;
            }
            case 11: {
                this.setPassivationTO(mngr, rcvpkt);
                break;
            }
            case 15: {
                this.isRecovery(mngr, rcvpkt);
                break;
            }
            case 16: {
                this.getServletSession(mngr, rcvpkt);
                break;
            }
            case 10: {
                this.getBackupData(smname, mngr, rcvpkt);
                break;
            }
            case 23: {
                this.getBackupDataDB(smname, mngr, rcvpkt);
                break;
            }
            case 19: {
                SocketStream socketStream = (SocketStream)this.sockStream.get();
                if (socketStream == null) break;
                socketStream.destroy();
                break;
            }
            default: {
                if (!logger.isLoggable(JeusMessage_Session2._22009_LEVEL)) break;
                logger.log(JeusMessage_Session2._22009_LEVEL, JeusMessage_Session2._22009, new Object[]{this.handlerId.get(), String.valueOf(opcode)});
            }
        }
    }

    private void addSession(SessionManager sessionMan, Packet rcvpkt, boolean async, boolean isNew) {
        block20: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to add a session"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to add a session"));
                }
                return;
            }
            Object key = rcvpkt.getKey();
            byte[] contents = rcvpkt.getValue();
            if (key == null) {
                if (logger.isLoggable(JeusMessage_Session2._22010_LEVEL)) {
                    logger.log(JeusMessage_Session2._22010_LEVEL, JeusMessage_Session2._22010, this.handlerId.get());
                }
                this.returnError(rcvpkt);
                return;
            }
            if (contents == null) {
                if (logger.isLoggable(JeusMessage_Session2._22011_LEVEL)) {
                    logger.log(JeusMessage_Session2._22011_LEVEL, JeusMessage_Session2._22011, this.handlerId.get());
                }
                this.returnError(rcvpkt);
                return;
            }
            try {
                if (isNew) {
                    sessionMan.addNewSession(key, contents);
                } else {
                    sessionMan.addSession(key, contents);
                }
                if (async) {
                    return;
                }
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (CentralConstants.NEW_SESSION_CONSISTENT && isNew) {
                    if (logger.isLoggable(JeusMessage_Session2._22123_LEVEL)) {
                        logger.log(JeusMessage_Session2._22123_LEVEL, JeusMessage_Session2._22123, new Object[]{this.handlerId.get(), key}, (Throwable)ie);
                    }
                    sessionMan.removeSession(key);
                } else if (logger.isLoggable(JeusMessage_Session2._22012_LEVEL)) {
                    logger.log(JeusMessage_Session2._22012_LEVEL, JeusMessage_Session2._22012, new Object[]{this.handlerId.get(), key}, (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (CentralConstants.NEW_SESSION_CONSISTENT && isNew) {
                    if (logger.isLoggable(JeusMessage_Session2._22123_LEVEL)) {
                        logger.log(JeusMessage_Session2._22123_LEVEL, JeusMessage_Session2._22123, new Object[]{this.handlerId.get(), key}, (Throwable)e);
                    }
                    sessionMan.removeSession(key);
                }
                if (!logger.isLoggable(JeusMessage_Session2._22012_LEVEL)) break block20;
                logger.log(JeusMessage_Session2._22012_LEVEL, JeusMessage_Session2._22012, new Object[]{this.handlerId.get(), key}, (Throwable)e);
            }
        }
    }

    private void getSession(SessionManager sessionMan, Packet rcvpkt) {
        block12: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a session"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to get a session"));
                }
                return;
            }
            Object key = rcvpkt.getKey();
            if (key == null) {
                if (logger.isLoggable(JeusMessage_Session2._22013_LEVEL)) {
                    logger.log(JeusMessage_Session2._22013_LEVEL, JeusMessage_Session2._22013, this.handlerId.get());
                }
                this.returnError(rcvpkt);
                return;
            }
            try {
                byte[] contents = sessionMan.getSession(key);
                if (contents != null) {
                    rcvpkt.setValue(contents);
                    rcvpkt.sendReply(socketStream);
                } else {
                    rcvpkt.setValue(null);
                    rcvpkt.sendReply(socketStream);
                }
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22014_LEVEL)) {
                    logger.log(JeusMessage_Session2._22014_LEVEL, JeusMessage_Session2._22014, new Object[]{this.handlerId.get(), key}, (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22014_LEVEL)) break block12;
                logger.log(JeusMessage_Session2._22014_LEVEL, JeusMessage_Session2._22014, new Object[]{this.handlerId.get(), key}, (Throwable)e);
            }
        }
    }

    private void removeSession(SessionManager sessionMan, Packet rcvpkt, boolean async) {
        block11: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to remove a session"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to remove a session"));
                }
                return;
            }
            Object key = rcvpkt.getKey();
            if (key == null) {
                if (logger.isLoggable(JeusMessage_Session2._22015_LEVEL)) {
                    logger.log(JeusMessage_Session2._22015_LEVEL, JeusMessage_Session2._22015, this.handlerId.get());
                }
                this.returnError(rcvpkt);
                return;
            }
            try {
                sessionMan.removeSession(key);
                if (async) {
                    return;
                }
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22016_LEVEL)) {
                    logger.log(JeusMessage_Session2._22016_LEVEL, JeusMessage_Session2._22016, new Object[]{this.handlerId.get(), key}, (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22016_LEVEL)) break block11;
                logger.log(JeusMessage_Session2._22016_LEVEL, JeusMessage_Session2._22016, new Object[]{this.handlerId.get(), key}, (Throwable)e);
            }
        }
    }

    private void isAlive(SessionManager sessionMan, Packet rcvpkt) {
        block9: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to process isAlive()"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to process isAlive()"));
                }
                return;
            }
            try {
                sessionMan.alive();
                if (logger.isLoggable(JeusMessage_Session2._22017_LEVEL)) {
                    logger.log(JeusMessage_Session2._22017_LEVEL, JeusMessage_Session2._22017, this.handlerId.get());
                }
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22018_LEVEL)) {
                    logger.log(JeusMessage_Session2._22018_LEVEL, JeusMessage_Session2._22018, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22018_LEVEL)) break block9;
                logger.log(JeusMessage_Session2._22018_LEVEL, JeusMessage_Session2._22018, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void getAllSessionsSize(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get all sessions size"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to get all sessions size"));
                }
                return;
            }
            try {
                int size = sessionMan.getAllSessionsSize();
                rcvpkt.setValue(size);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22019_LEVEL)) {
                    logger.log(JeusMessage_Session2._22019_LEVEL, JeusMessage_Session2._22019, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22019_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22019_LEVEL, JeusMessage_Session2._22019, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void getActiveSessionsSize(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a active seesions size"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to get a active seesions size"));
                }
                return;
            }
            try {
                int size = sessionMan.getActiveSessionsSize();
                rcvpkt.setValue(size);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22020_LEVEL)) {
                    logger.log(JeusMessage_Session2._22020_LEVEL, JeusMessage_Session2._22020, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22020_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22020_LEVEL, JeusMessage_Session2._22020, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void getPassivateSessionsSize(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a passivate sessions size"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to get a passivate sessions size"));
                }
                return;
            }
            try {
                int size = sessionMan.getPassivateSessionsSize();
                rcvpkt.setValue(size);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22021_LEVEL)) {
                    logger.log(JeusMessage_Session2._22021_LEVEL, JeusMessage_Session2._22021, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22021_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22021_LEVEL, JeusMessage_Session2._22021, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void setCheckTO(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to set CheckTO()"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to set CheckTO()"));
                }
                return;
            }
            try {
                int i = rcvpkt.getValueIndex();
                sessionMan.setCheckTO(i);
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22022_LEVEL)) {
                    logger.log(JeusMessage_Session2._22022_LEVEL, JeusMessage_Session2._22022, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22022_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22022_LEVEL, JeusMessage_Session2._22022, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void setBackupTrigger(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to set a backup trigger"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to set a backup trigger"));
                }
                return;
            }
            try {
                int i = rcvpkt.getValueIndex();
                sessionMan.setBackupTrigger(i);
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22023_LEVEL)) {
                    logger.log(JeusMessage_Session2._22023_LEVEL, JeusMessage_Session2._22023, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22023_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22023_LEVEL, JeusMessage_Session2._22023, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void setRemovalTO(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to set RemovalTO"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to set RemovalTO"));
                }
                return;
            }
            try {
                int i = rcvpkt.getValueIndex();
                sessionMan.setRemovalTO(i);
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22024_LEVEL)) {
                    logger.log(JeusMessage_Session2._22024_LEVEL, JeusMessage_Session2._22024, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22024_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22024_LEVEL, JeusMessage_Session2._22024, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void setPassivationTO(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to set PassivationTO"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to set PassivationTO"));
                }
                return;
            }
            try {
                int i = rcvpkt.getValueIndex();
                sessionMan.setPassivationTO(i);
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22025_LEVEL)) {
                    logger.log(JeusMessage_Session2._22025_LEVEL, JeusMessage_Session2._22025, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22025_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22025_LEVEL, JeusMessage_Session2._22025, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void isRecovery(SessionManager sessionMan, Packet rcvpkt) {
        block8: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to process isRecovery()"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to process isRecovery()"));
                }
                return;
            }
            try {
                boolean flag = sessionMan.isRecovery();
                int value = flag ? 1 : 0;
                rcvpkt.setValue(value);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22026_LEVEL)) {
                    logger.log(JeusMessage_Session2._22026_LEVEL, JeusMessage_Session2._22026, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22026_LEVEL)) break block8;
                logger.log(JeusMessage_Session2._22026_LEVEL, JeusMessage_Session2._22026, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    public void getServletSession(SessionManager sessionMan, Packet rcvpkt) {
        block12: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a servlet seesion"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to get a servlet seesion"));
                }
                return;
            }
            Object key = rcvpkt.getKey();
            if (key == null) {
                if (logger.isLoggable(JeusMessage_Session2._22013_LEVEL)) {
                    logger.log(JeusMessage_Session2._22013_LEVEL, JeusMessage_Session2._22013, this.handlerId.get());
                }
                this.returnError(rcvpkt);
                return;
            }
            try {
                byte[] contents = sessionMan.getServletSession(key);
                if (contents != null) {
                    rcvpkt.setValue(contents);
                    rcvpkt.sendReply(socketStream);
                } else {
                    rcvpkt.setValue(null);
                    rcvpkt.sendReply(socketStream);
                }
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22014_LEVEL)) {
                    logger.log(JeusMessage_Session2._22014_LEVEL, JeusMessage_Session2._22014, new Object[]{this.handlerId.get(), key}, (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22014_LEVEL)) break block12;
                logger.log(JeusMessage_Session2._22014_LEVEL, JeusMessage_Session2._22014, new Object[]{this.handlerId.get(), key}, (Throwable)e);
            }
        }
    }

    private void dumpBackup(SessionManager sessionMan, Packet rcvpkt) {
        block9: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to dump a backup"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to dump a backup"));
                }
                return;
            }
            try {
                Vector list = rcvpkt.getEntryList();
                sessionMan.dumpBackup(list);
                if (logger.isLoggable(JeusMessage_Session2._22027_LEVEL)) {
                    logger.log(JeusMessage_Session2._22027_LEVEL, JeusMessage_Session2._22027, new Object[]{this.handlerId.get(), String.valueOf(list.size())});
                }
                rcvpkt.setValue(null);
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22028_LEVEL)) {
                    logger.log(JeusMessage_Session2._22028_LEVEL, JeusMessage_Session2._22028, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22028_LEVEL)) break block9;
                logger.log(JeusMessage_Session2._22028_LEVEL, JeusMessage_Session2._22028, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void getBackupData(String smname, SessionManager sessionMan, Packet rcvpkt) {
        block20: {
            if (this.sockStream == null || this.socketId == null || this.handlerId == null || this.backupData == null || this.backupDataIndex == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a backup data"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            SocketID id = (SocketID)this.socketId.get();
            if (socketStream == null || id == null) {
                if (logger.isLoggable(JeusMessage_Session2._22074_LEVEL)) {
                    logger.log(JeusMessage_Session2._22074_LEVEL, JeusMessage_Session2._22074, (Throwable)new Exception("failed to get a backup data"));
                }
                return;
            }
            Hashtable tempBackupData = (Hashtable)this.backupData.get(id);
            Hashtable tempBackupDataIndex = (Hashtable)this.backupDataIndex.get(id);
            if (tempBackupData == null || tempBackupDataIndex == null) {
                if (logger.isLoggable(JeusMessage_Session2._22075_LEVEL)) {
                    logger.log(JeusMessage_Session2._22075_LEVEL, JeusMessage_Session2._22075, (Object)id, (Throwable)new Exception("failed to get a backup data"));
                }
                return;
            }
            int index = 0;
            Vector list = (Vector)tempBackupData.get(smname);
            Integer tmp = (Integer)tempBackupDataIndex.get(smname);
            if (list != null) {
                index = tmp;
            } else {
                list = sessionMan.getBackupData();
            }
            try {
                if (list == null || list.size() <= 0) {
                    rcvpkt.setValue(null);
                    rcvpkt.sendReply(socketStream);
                    return;
                }
                byte[] dumpBuffer = new byte[262144];
                int size = list.size();
                int count = index;
                int acceptcnt = 0;
                rcvpkt.setEmptyValue(dumpBuffer);
                while (count < size) {
                    boolean accepted = rcvpkt.dumpEntry((Entry)list.get(count));
                    if (!accepted && acceptcnt == 0) {
                        dumpBuffer = new byte[dumpBuffer.length * 2];
                        rcvpkt.setEmptyValue(dumpBuffer);
                    } else if (accepted) {
                        ++count;
                        ++acceptcnt;
                    }
                    if (!(!accepted & acceptcnt > 0) && count != size) continue;
                    rcvpkt.setValueIndex(acceptcnt);
                    break;
                }
                if (count < size) {
                    rcvpkt.setOpcode(17);
                    tempBackupData.put(smname, list);
                    tempBackupDataIndex.put(smname, new Integer(count));
                } else {
                    tempBackupData.remove(smname);
                    tempBackupDataIndex.remove(smname);
                }
                if (logger.isLoggable(JeusMessage_Session2._22029_LEVEL)) {
                    logger.log(JeusMessage_Session2._22029_LEVEL, JeusMessage_Session2._22029, new Object[]{this.handlerId.get(), String.valueOf(count), String.valueOf(size)});
                }
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22030_LEVEL)) {
                    logger.log(JeusMessage_Session2._22030_LEVEL, JeusMessage_Session2._22030, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22030_LEVEL)) break block20;
                logger.log(JeusMessage_Session2._22030_LEVEL, JeusMessage_Session2._22030, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void getBackupDataDB(String smname, SessionManager sessionMan, Packet rcvpkt) {
        block20: {
            if (this.sockStream == null || this.socketId == null || this.handlerId == null || this.backupDataDB == null || this.backupDataDBIndex == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to get a backup data DB"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            SocketID id = (SocketID)this.socketId.get();
            if (socketStream == null || id == null) {
                if (logger.isLoggable(JeusMessage_Session2._22074_LEVEL)) {
                    logger.log(JeusMessage_Session2._22074_LEVEL, JeusMessage_Session2._22074, (Throwable)new Exception("failed to get a backup data DB"));
                }
                return;
            }
            Hashtable tempBackupDataDB = (Hashtable)this.backupDataDB.get(id);
            Hashtable tempBackupDataDBIndex = (Hashtable)this.backupDataDBIndex.get(id);
            if (tempBackupDataDB == null || tempBackupDataDBIndex == null) {
                if (logger.isLoggable(JeusMessage_Session2._22076_LEVEL)) {
                    logger.log(JeusMessage_Session2._22076_LEVEL, JeusMessage_Session2._22076, (Object)id, (Throwable)new Exception("failed to get a backup data DB"));
                }
                return;
            }
            int index = 0;
            Vector list = (Vector)tempBackupDataDB.get(smname);
            Integer tmp = (Integer)tempBackupDataDBIndex.get(smname);
            if (list != null) {
                index = tmp;
            } else {
                list = sessionMan.getBackupDataDB();
            }
            try {
                if (list == null || list.size() <= 0) {
                    rcvpkt.setValue(null);
                    rcvpkt.sendReply(socketStream);
                    return;
                }
                byte[] dumpBuffer = new byte[262144];
                int size = list.size();
                int count = index;
                int acceptcnt = 0;
                rcvpkt.setEmptyValue(dumpBuffer);
                while (count < size) {
                    Entry e = (Entry)list.get(count);
                    e.contents = sessionMan.getDBData(e);
                    boolean accepted = rcvpkt.dumpEntry(e);
                    if (!accepted && acceptcnt == 0) {
                        dumpBuffer = new byte[dumpBuffer.length * 2];
                        rcvpkt.setEmptyValue(dumpBuffer);
                    } else if (accepted) {
                        ++count;
                        ++acceptcnt;
                    }
                    if (!(!accepted & acceptcnt > 0) && count != size) continue;
                    rcvpkt.setValueIndex(acceptcnt);
                    break;
                }
                if (count < size) {
                    rcvpkt.setOpcode(24);
                    tempBackupDataDB.put(smname, list);
                    tempBackupDataDBIndex.put(smname, new Integer(count));
                } else {
                    tempBackupDataDB.remove(smname);
                    tempBackupDataDBIndex.remove(smname);
                }
                if (logger.isLoggable(JeusMessage_Session2._22029_LEVEL)) {
                    logger.log(JeusMessage_Session2._22029_LEVEL, JeusMessage_Session2._22029, new Object[]{this.handlerId.get(), String.valueOf(count), String.valueOf(size)});
                }
                rcvpkt.sendReply(socketStream);
            }
            catch (IOException ie) {
                if (logger.isLoggable(JeusMessage_Session2._22030_LEVEL)) {
                    logger.log(JeusMessage_Session2._22030_LEVEL, JeusMessage_Session2._22030, this.handlerId.get(), (Throwable)ie);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22030_LEVEL)) break block20;
                logger.log(JeusMessage_Session2._22030_LEVEL, JeusMessage_Session2._22030, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private void returnError(Packet pkt) {
        block6: {
            if (this.sockStream == null || this.handlerId == null) {
                if (logger.isLoggable(JeusMessage_Session2._22072_LEVEL)) {
                    logger.log(JeusMessage_Session2._22072_LEVEL, JeusMessage_Session2._22072, (Throwable)new Exception("failed to return a error"));
                }
                return;
            }
            SocketStream14 socketStream = (SocketStream14)this.sockStream.get();
            if (socketStream == null) {
                if (logger.isLoggable(JeusMessage_Session2._22073_LEVEL)) {
                    logger.log(JeusMessage_Session2._22073_LEVEL, JeusMessage_Session2._22073, (Throwable)new Exception("failed to return a error"));
                }
                return;
            }
            try {
                pkt.setOpcode(18);
                pkt.setKey(null);
                pkt.setValue(null);
                pkt.sendReply(socketStream);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._22033_LEVEL)) break block6;
                logger.log(JeusMessage_Session2._22033_LEVEL, JeusMessage_Session2._22033, this.handlerId.get(), (Throwable)e);
            }
        }
    }

    private Hashtable makeSpecialDataBySocketId(Hashtable table, SocketID id) {
        if (table == null) {
            return null;
        }
        Hashtable data = (Hashtable)table.get(id);
        if (data == null) {
            data = new Hashtable();
            table.put(id, data);
        }
        return data;
    }

    private void clearSpecialDataBySocketId(Hashtable table, SocketID id) {
        if (table == null) {
            return;
        }
        Hashtable data = (Hashtable)table.remove(id);
        if (data != null) {
            data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSpecialDataByAllSocketId(Hashtable table) {
        if (table != null) {
            Hashtable hashtable = table;
            synchronized (hashtable) {
                if (table != null) {
                    for (Hashtable data : table.values()) {
                        data.clear();
                    }
                    table.clear();
                    table = null;
                }
            }
        }
    }

    public void makeDataPerSocketId(SocketID id) {
        if (logger.isLoggable(JeusMessage_Session2._22077_LEVEL)) {
            logger.log(JeusMessage_Session2._22077_LEVEL, JeusMessage_Session2._22077, (Object)id);
        }
        this.makeSpecialDataBySocketId(this.backupData, id);
        this.makeSpecialDataBySocketId(this.backupDataIndex, id);
        this.makeSpecialDataBySocketId(this.backupDataDB, id);
        this.makeSpecialDataBySocketId(this.backupDataDBIndex, id);
    }

    public void clearDataPerSocketId(SocketID id) {
        if (logger.isLoggable(JeusMessage_Session2._22078_LEVEL)) {
            logger.log(JeusMessage_Session2._22078_LEVEL, JeusMessage_Session2._22078, (Object)id);
        }
        this.clearSpecialDataBySocketId(this.backupData, id);
        this.clearSpecialDataBySocketId(this.backupDataIndex, id);
        this.clearSpecialDataBySocketId(this.backupDataDB, id);
        this.clearSpecialDataBySocketId(this.backupDataDBIndex, id);
    }

    private void clearDataByAllSocketId() {
        this.clearSpecialDataByAllSocketId(this.backupData);
        this.clearSpecialDataByAllSocketId(this.backupDataIndex);
        this.clearSpecialDataByAllSocketId(this.backupDataDB);
        this.clearSpecialDataByAllSocketId(this.backupDataDBIndex);
    }
}

