/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.net.NoListenID;
import jeus.net.ReplyListener;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.net.impl.NodeInfo;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.CentralConstants;
import jeus.sessionmanager.central.network.Packet;
import jeus.sessionmanager.central.network.SessionTransceiverConnectionListener;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionTransceiver {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private static final ConcurrentHashMap LOCAL_SERVER_TABLE = new ConcurrentHashMap();
    private static final Object[] connectPiggybackData = new Object[0];
    private static Endpoint endpoint;
    private AtomicBoolean running = new AtomicBoolean();
    private SocketStream14 sockStream;
    private AtomicBoolean sockStreamClosed = new AtomicBoolean(false);
    private NodeInfo nodeInfo;
    private int connectionTimeout;
    private int replyWaitTimeout;

    public static SessionTransceiver getTransceiver(NodeInfo nodeInfo, long connectTimeout, long replyWaitTimeout) throws IOException {
        SessionTransceiver transceiver = (SessionTransceiver)LOCAL_SERVER_TABLE.get(nodeInfo);
        if (transceiver == null) {
            transceiver = new SessionTransceiver(nodeInfo, connectTimeout, replyWaitTimeout);
            transceiver.start();
        }
        return transceiver;
    }

    public static void destroy() {
        Iterator iter = LOCAL_SERVER_TABLE.values().iterator();
        while (iter.hasNext()) {
            SessionTransceiver transceiver = (SessionTransceiver)iter.next();
            transceiver.stop();
            iter.remove();
        }
        endpoint.unexport();
    }

    private SessionTransceiver(NodeInfo nodeInfo, long connectionTimeout, long replyWaitTimeout) {
        this.nodeInfo = nodeInfo;
        this.connectionTimeout = SessionManagerUtil.safeCasting(connectionTimeout);
        this.replyWaitTimeout = SessionManagerUtil.safeCasting(replyWaitTimeout);
    }

    private void start() throws IOException {
        this.running.set(true);
        if (logger.isLoggable(JeusMessage_Session2._22100_LEVEL)) {
            logger.log(JeusMessage_Session2._22100_LEVEL, JeusMessage_Session2._22100);
        }
        try {
            this.sockStream = (SocketStream14)endpoint.getSocketStream((SocketID)this.nodeInfo, CentralConstants.CONNECTION_RETRY_COUNT, (Object)connectPiggybackData, this.connectionTimeout, this.replyWaitTimeout);
            this.sockStreamClosed.set(false);
            if (logger.isLoggable(JeusMessage_Session2._22101_LEVEL)) {
                logger.log(JeusMessage_Session2._22101_LEVEL, JeusMessage_Session2._22101, (Object)this.nodeInfo);
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Session2._22102_LEVEL)) {
                logger.log(JeusMessage_Session2._22102_LEVEL, JeusMessage_Session2._22102, (Throwable)e);
            }
            throw e;
        }
        LOCAL_SERVER_TABLE.put(this.nodeInfo, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block3: {
            if (!this.running.compareAndSet(true, false)) {
                return;
            }
            if (logger.isLoggable(JeusMessage_Session2._22103_LEVEL)) {
                logger.log(JeusMessage_Session2._22103_LEVEL, JeusMessage_Session2._22103);
            }
            if (this.sockStream != null && this.sockStreamClosed.compareAndSet(false, true)) {
                this.sockStream.destroy();
                this.sockStream = null;
            }
            LOCAL_SERVER_TABLE.remove(this.nodeInfo);
            if (!logger.isLoggable(JeusMessage_Session2._22105_LEVEL)) break block3;
            logger.log(JeusMessage_Session2._22105_LEVEL, JeusMessage_Session2._22105, (Object)this.nodeInfo);
        }
    }

    public void sendAsync(Packet sndpkt) throws IOException {
        if (!this.running.get()) {
            throw new IOException("<SessionTransceiver> try to reconnect.");
        }
        SocketStream14 currentSockStream = this.getSocketStream();
        if (currentSockStream == null) {
            throw new IOException("<SessionTransceiver> try to reconnect.");
        }
        sndpkt.send(currentSockStream);
    }

    public Packet send(Packet sndpkt, MsgSync reply) throws IOException {
        if (!this.running.get()) {
            throw new IOException("<SessionTransceiver> try to reconnect.");
        }
        SocketStream14 currentSockStream = this.getSocketStream();
        if (currentSockStream == null) {
            throw new IOException("<SessionTransceiver> try to reconnect.");
        }
        sndpkt.send(currentSockStream, (ReplyListener)reply);
        Object obj = reply.waitReply();
        if (obj instanceof byte[]) {
            Packet rcvpkt = new Packet();
            rcvpkt.receive((byte[])obj);
            return rcvpkt;
        }
        throw new IOException("<SessionTransceiver> unexpected reply message.");
    }

    private SocketStream14 getSocketStream() {
        if (this.sockStream != null && this.sockStream.isClosed() && this.sockStreamClosed.compareAndSet(false, true)) {
            this.sockStream.destroy();
            this.sockStream = null;
        }
        return this.sockStream;
    }

    public int getCurrentConnections() {
        SocketStream[] socketStreams = endpoint.getSocketStreams();
        if (socketStreams != null) {
            return socketStreams.length;
        }
        return 0;
    }

    public String toString() {
        SocketStream14 info = this.getSocketStream();
        return info == null ? "SessionTransceiver(already closed or invalid)" : "SessionTransceiver(" + info.toString() + ")";
    }

    static {
        String name = "SessionTransceiver";
        endpoint = new Endpoint(name, CentralConstants.SESSION_CLIENT_USE_NIO ? JeusIOComponentCreator.createNIOCreator((String)("IO-" + name), (int)CentralConstants.WRITE_BUFFER_LIMIT_BYTE, (int)CentralConstants.WRITE_BUFFER_RESTART_BYTE) : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), (SocketID)new NoListenID(), (StreamContentHandlerCreator)new ContentHandlerCreator(), new ConnectionListenerFactory(){

            public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
                try {
                    return new SessionTransceiverConnectionListener(LOCAL_SERVER_TABLE);
                }
                catch (Exception e) {
                    throw new JeusRuntimeException((Throwable)e);
                }
            }
        }, (Object)(CentralConstants.SESSION_GLOBAL_USE_SSL ? JeusSSLConfiguration.sslContext : null));
        try {
            endpoint.export();
        }
        catch (IOException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }
}

