/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jeus.net.SocketStream;
import jeus.servlet.common.WebContainerManager;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.BackupManager;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.FileDB;
import jeus.sessionmanager.distributed.FileDBEntry;
import jeus.sessionmanager.distributed.network.SCAddress;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.ByteArraySessionImpl;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.session.Session;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;
import jeus.util.properties.JeusNetPropertyValues;

public final class BackupStore
implements SCConstants {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private static int hostIndex = 0;
    private final SCAddress localId;
    private final Map sessions = new ConcurrentHashMap();
    private FileDB storage;

    public BackupStore(SCAddress localId, DistributedManagerConfig desc) {
        this.localId = localId;
        String engineName = localId.getEngineId();
        String nodeName = WebContainerManager.NODE_NAME;
        if (nodeName == null) {
            nodeName = JeusNetPropertyValues.LOCAL_HOSTNAME + hostIndex;
            ++hostIndex;
        }
        String fname = engineName + "_backup";
        String path = BackupManager.getFileDBPath(desc);
        if (path != null) {
            try {
                this.storage = new FileDB(path, fname, desc);
            }
            catch (IOException sse) {
                if (logger.isLoggable(JeusMessage_Session3._37000_LEVEL)) {
                    logger.log(JeusMessage_Session3._37000_LEVEL, JeusMessage_Session3._37000, (Object)(path + fname), (Throwable)sse);
                }
                this.storage = null;
            }
        } else {
            this.storage = null;
        }
    }

    public void destroy() {
        this.sessions.clear();
        if (this.storage != null) {
            this.storage.destroy();
        }
    }

    public void recover() {
        if (this.storage != null) {
            this.storage.recover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(int count, byte[] inputBytes, SocketStream sockStream) {
        CopyOnWriteArrayList<FileDBEntry> entries = null;
        int offset = 0;
        int length = 0;
        int intputBytesTotalLen = inputBytes.length;
        if (this.storage != null) {
            entries = new CopyOnWriteArrayList<FileDBEntry>();
        }
        Map map = this.sessions;
        synchronized (map) {
            block14: {
                for (int i = 0; i < count; ++i) {
                    ByteArraySessionImpl backupSession = new ByteArraySessionImpl();
                    try {
                        length = backupSession.readSession(inputBytes, offset, intputBytesTotalLen - offset);
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(JeusMessage_Session3._39101_LEVEL)) {
                            logger.log(JeusMessage_Session3._39101_LEVEL, JeusMessage_Session3._39101, (Object[])new String[]{this.localId.toString(), sockStream.toString()}, (Throwable)e);
                        }
                        return;
                    }
                    boolean valid = backupSession.validate();
                    if (entries != null) {
                        entries.add(new FileDBEntry(backupSession.getInternalId(), offset, valid ? (long)length : -1L));
                    }
                    offset += length;
                    if (valid) {
                        this.sessions.put(backupSession.getInternalId(), backupSession);
                        if (!logger.isLoggable(JeusMessage_Session3._37086_LEVEL)) continue;
                        logger.log(JeusMessage_Session3._37086_LEVEL, JeusMessage_Session3._37086, new Object[]{backupSession.getInternalId(), String.valueOf(valid)});
                        continue;
                    }
                    this.sessions.remove(backupSession.getInternalId());
                    if (!logger.isLoggable(JeusMessage_Session3._37085_LEVEL)) continue;
                    logger.log(JeusMessage_Session3._37085_LEVEL, JeusMessage_Session3._37085, (Object)backupSession.getInternalId());
                }
                if (logger.isLoggable(JeusMessage_Session3._37100_LEVEL)) {
                    logger.log(JeusMessage_Session3._37100_LEVEL, JeusMessage_Session3._37100, (Object[])new String[]{this.localId.toString(), sockStream.toString(), String.valueOf(count)});
                }
                if (this.storage != null) {
                    try {
                        this.storage.storeEntries(entries, inputBytes, inputBytes.length);
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(JeusMessage_Session3._37002_LEVEL)) break block14;
                        logger.log(JeusMessage_Session3._37002_LEVEL, JeusMessage_Session3._37002, (Throwable)ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArraySession getSession(String internalId, boolean migrate) {
        Map map = this.sessions;
        synchronized (map) {
            ByteArraySession backupSession = (ByteArraySession)this.sessions.get(internalId);
            if (backupSession != null) {
                if (this.validate(backupSession)) {
                    return backupSession;
                }
                return null;
            }
            if (this.storage == null) {
                return null;
            }
            try {
                backupSession = this.storage.load(internalId, migrate);
                if (this.validate(backupSession)) {
                    this.sessions.put(internalId, backupSession);
                    return backupSession;
                }
                return null;
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session3._37101_LEVEL)) {
                    logger.log(JeusMessage_Session3._37101_LEVEL, JeusMessage_Session3._37101, (Object)this.localId.toString(), (Throwable)ioe);
                }
                return null;
            }
        }
    }

    public void scavenge() {
        int total = this.sessions.size();
        int invalid = 0;
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            if (this.validate((Session)i.next())) continue;
            ++invalid;
        }
        if (invalid > 0) {
            int valid = total - invalid;
            if (logger.isLoggable(JeusMessage_Session3._39104_LEVEL)) {
                logger.log(JeusMessage_Session3._39104_LEVEL, JeusMessage_Session3._39104, (Object[])new String[]{this.localId.toString(), String.valueOf(total), String.valueOf(valid), String.valueOf(invalid)});
            }
        }
    }

    private boolean validate(Session session) {
        if (session == null) {
            return false;
        }
        if (!session.validate()) {
            if (logger.isLoggable(JeusMessage_Session3._37085_LEVEL)) {
                logger.log(JeusMessage_Session3._37085_LEVEL, JeusMessage_Session3._37085, (Object)session.getInternalId());
            }
            this.destroy(session);
            return false;
        }
        return true;
    }

    private void destroy(Session session) {
        if (session == null) {
            return;
        }
        this.destroy(session.getInternalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String internalId) {
        if (internalId == null) {
            return;
        }
        Session session = null;
        Map map = this.sessions;
        synchronized (map) {
            block9: {
                session = (Session)this.sessions.remove(internalId);
                if (this.storage != null) {
                    try {
                        this.storage.purge(internalId);
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(JeusMessage_Session3._39102_LEVEL)) break block9;
                        logger.log(JeusMessage_Session3._39102_LEVEL, JeusMessage_Session3._39102, (Object[])new String[]{this.localId.toString(), internalId}, (Throwable)e);
                    }
                }
            }
        }
        if (session != null) {
            session.destroy();
        }
        if (logger.isLoggable(JeusMessage_Session3._39103_LEVEL)) {
            logger.log(JeusMessage_Session3._39103_LEVEL, JeusMessage_Session3._39103, (Object[])new String[]{this.localId.toString(), internalId});
        }
    }

    public int getInMemorySessionsCount() {
        return this.sessions.size();
    }

    public int getPassivatedSessionsCount() {
        if (this.storage == null) {
            return 0;
        }
        return this.storage.size();
    }

    public long getPassivatedSessionsFileSize() {
        if (this.storage == null) {
            return 0L;
        }
        return this.storage.fileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(boolean all, long passivationTo) {
        if (this.sessions.size() <= 0) {
            return;
        }
        if (!all && passivationTo <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashMap<String, DistributableSession> passivationSessions = new HashMap<String, DistributableSession>();
        Map map = this.sessions;
        synchronized (map) {
            for (Object obj : this.sessions.values()) {
                if (!(obj instanceof DistributableSession)) continue;
                DistributableSession session = (DistributableSession)obj;
                if (all) {
                    this.sessions.remove(session.getInternalId());
                    passivationSessions.put(session.getInternalId(), session);
                    continue;
                }
                if (!session.checkPassivation(currentTime, passivationTo)) continue;
                this.sessions.remove(session.getInternalId());
                passivationSessions.put(session.getInternalId(), session);
            }
            this.storeSessions(passivationSessions);
        }
        passivationSessions.clear();
    }

    private void storeSessions(HashMap passivations) {
        if (passivations == null || this.storage == null) {
            return;
        }
        for (int criticalCnt = 0; passivations.size() > 0 && criticalCnt < 10; ++criticalCnt) {
            BackupManager.serializeNstoreSessions(passivations, null, this.storage);
        }
        if (logger.isLoggable(JeusMessage_Session3._39306_LEVEL)) {
            for (Session notResolvedSession : passivations.values()) {
                logger.log(JeusMessage_Session3._39306_LEVEL, JeusMessage_Session3._39306, new Object[]{this.localId.toString(), notResolvedSession.getId(), notResolvedSession.getConcurrentAccessCount()});
            }
        }
    }
}

